/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.CrossRegionS3RestoreSourcesAccess;
import software.amazon.awssdk.services.odb.model.CrossRegionS3RestoreSourcesAccessListCopier;
import software.amazon.awssdk.services.odb.model.KmsAccess;
import software.amazon.awssdk.services.odb.model.ManagedS3BackupAccess;
import software.amazon.awssdk.services.odb.model.S3Access;
import software.amazon.awssdk.services.odb.model.ServiceNetworkEndpoint;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.services.odb.model.StsAccess;
import software.amazon.awssdk.services.odb.model.ZeroEtlAccess;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedServices
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedServices> {
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkArn").getter(ManagedServices.getter(ManagedServices::serviceNetworkArn)).setter(ManagedServices.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()}).build();
    private static final SdkField<String> RESOURCE_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGatewayArn").getter(ManagedServices.getter(ManagedServices::resourceGatewayArn)).setter(ManagedServices.setter(Builder::resourceGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayArn").build()}).build();
    private static final SdkField<List<String>> MANAGED_SERVICES_IPV4_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedServicesIpv4Cidrs").getter(ManagedServices.getter(ManagedServices::managedServicesIpv4Cidrs)).setter(ManagedServices.setter(Builder::managedServicesIpv4Cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedServicesIpv4Cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceNetworkEndpoint> SERVICE_NETWORK_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceNetworkEndpoint").getter(ManagedServices.getter(ManagedServices::serviceNetworkEndpoint)).setter(ManagedServices.setter(Builder::serviceNetworkEndpoint)).constructor(ServiceNetworkEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkEndpoint").build()}).build();
    private static final SdkField<ManagedS3BackupAccess> MANAGED_S3_BACKUP_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedS3BackupAccess").getter(ManagedServices.getter(ManagedServices::managedS3BackupAccess)).setter(ManagedServices.setter(Builder::managedS3BackupAccess)).constructor(ManagedS3BackupAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedS3BackupAccess").build()}).build();
    private static final SdkField<ZeroEtlAccess> ZERO_ETL_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("zeroEtlAccess").getter(ManagedServices.getter(ManagedServices::zeroEtlAccess)).setter(ManagedServices.setter(Builder::zeroEtlAccess)).constructor(ZeroEtlAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()}).build();
    private static final SdkField<S3Access> S3_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Access").getter(ManagedServices.getter(ManagedServices::s3Access)).setter(ManagedServices.setter(Builder::s3Access)).constructor(S3Access::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()}).build();
    private static final SdkField<StsAccess> STS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stsAccess").getter(ManagedServices.getter(ManagedServices::stsAccess)).setter(ManagedServices.setter(Builder::stsAccess)).constructor(StsAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsAccess").build()}).build();
    private static final SdkField<KmsAccess> KMS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kmsAccess").getter(ManagedServices.getter(ManagedServices::kmsAccess)).setter(ManagedServices.setter(Builder::kmsAccess)).constructor(KmsAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccess").build()}).build();
    private static final SdkField<List<CrossRegionS3RestoreSourcesAccess>> CROSS_REGION_S3_RESTORE_SOURCES_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossRegionS3RestoreSourcesAccess").getter(ManagedServices.getter(ManagedServices::crossRegionS3RestoreSourcesAccess)).setter(ManagedServices.setter(Builder::crossRegionS3RestoreSourcesAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionS3RestoreSourcesAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossRegionS3RestoreSourcesAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NETWORK_ARN_FIELD, RESOURCE_GATEWAY_ARN_FIELD, MANAGED_SERVICES_IPV4_CIDRS_FIELD, SERVICE_NETWORK_ENDPOINT_FIELD, MANAGED_S3_BACKUP_ACCESS_FIELD, ZERO_ETL_ACCESS_FIELD, S3_ACCESS_FIELD, STS_ACCESS_FIELD, KMS_ACCESS_FIELD, CROSS_REGION_S3_RESTORE_SOURCES_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedServices.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceNetworkArn;
    private final String resourceGatewayArn;
    private final List<String> managedServicesIpv4Cidrs;
    private final ServiceNetworkEndpoint serviceNetworkEndpoint;
    private final ManagedS3BackupAccess managedS3BackupAccess;
    private final ZeroEtlAccess zeroEtlAccess;
    private final S3Access s3Access;
    private final StsAccess stsAccess;
    private final KmsAccess kmsAccess;
    private final List<CrossRegionS3RestoreSourcesAccess> crossRegionS3RestoreSourcesAccess;

    private ManagedServices(BuilderImpl builder) {
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.resourceGatewayArn = builder.resourceGatewayArn;
        this.managedServicesIpv4Cidrs = builder.managedServicesIpv4Cidrs;
        this.serviceNetworkEndpoint = builder.serviceNetworkEndpoint;
        this.managedS3BackupAccess = builder.managedS3BackupAccess;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.s3Access = builder.s3Access;
        this.stsAccess = builder.stsAccess;
        this.kmsAccess = builder.kmsAccess;
        this.crossRegionS3RestoreSourcesAccess = builder.crossRegionS3RestoreSourcesAccess;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final String resourceGatewayArn() {
        return this.resourceGatewayArn;
    }

    public final boolean hasManagedServicesIpv4Cidrs() {
        return this.managedServicesIpv4Cidrs != null && !(this.managedServicesIpv4Cidrs instanceof SdkAutoConstructList);
    }

    public final List<String> managedServicesIpv4Cidrs() {
        return this.managedServicesIpv4Cidrs;
    }

    public final ServiceNetworkEndpoint serviceNetworkEndpoint() {
        return this.serviceNetworkEndpoint;
    }

    public final ManagedS3BackupAccess managedS3BackupAccess() {
        return this.managedS3BackupAccess;
    }

    public final ZeroEtlAccess zeroEtlAccess() {
        return this.zeroEtlAccess;
    }

    public final S3Access s3Access() {
        return this.s3Access;
    }

    public final StsAccess stsAccess() {
        return this.stsAccess;
    }

    public final KmsAccess kmsAccess() {
        return this.kmsAccess;
    }

    public final boolean hasCrossRegionS3RestoreSourcesAccess() {
        return this.crossRegionS3RestoreSourcesAccess != null && !(this.crossRegionS3RestoreSourcesAccess instanceof SdkAutoConstructList);
    }

    public final List<CrossRegionS3RestoreSourcesAccess> crossRegionS3RestoreSourcesAccess() {
        return this.crossRegionS3RestoreSourcesAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedServicesIpv4Cidrs() ? this.managedServicesIpv4Cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedS3BackupAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroEtlAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Access());
        hashCode = 31 * hashCode + Objects.hashCode(this.stsAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionS3RestoreSourcesAccess() ? this.crossRegionS3RestoreSourcesAccess() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedServices)) {
            return false;
        }
        ManagedServices other = (ManagedServices)obj;
        return Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.resourceGatewayArn(), other.resourceGatewayArn()) && this.hasManagedServicesIpv4Cidrs() == other.hasManagedServicesIpv4Cidrs() && Objects.equals(this.managedServicesIpv4Cidrs(), other.managedServicesIpv4Cidrs()) && Objects.equals(this.serviceNetworkEndpoint(), other.serviceNetworkEndpoint()) && Objects.equals(this.managedS3BackupAccess(), other.managedS3BackupAccess()) && Objects.equals(this.zeroEtlAccess(), other.zeroEtlAccess()) && Objects.equals(this.s3Access(), other.s3Access()) && Objects.equals(this.stsAccess(), other.stsAccess()) && Objects.equals(this.kmsAccess(), other.kmsAccess()) && this.hasCrossRegionS3RestoreSourcesAccess() == other.hasCrossRegionS3RestoreSourcesAccess() && Objects.equals(this.crossRegionS3RestoreSourcesAccess(), other.crossRegionS3RestoreSourcesAccess());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedServices").add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("ResourceGatewayArn", (Object)this.resourceGatewayArn()).add("ManagedServicesIpv4Cidrs", this.hasManagedServicesIpv4Cidrs() ? this.managedServicesIpv4Cidrs() : null).add("ServiceNetworkEndpoint", (Object)this.serviceNetworkEndpoint()).add("ManagedS3BackupAccess", (Object)this.managedS3BackupAccess()).add("ZeroEtlAccess", (Object)this.zeroEtlAccess()).add("S3Access", (Object)this.s3Access()).add("StsAccess", (Object)this.stsAccess()).add("KmsAccess", (Object)this.kmsAccess()).add("CrossRegionS3RestoreSourcesAccess", this.hasCrossRegionS3RestoreSourcesAccess() ? this.crossRegionS3RestoreSourcesAccess() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "resourceGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.resourceGatewayArn()));
            }
            case "managedServicesIpv4Cidrs": {
                return Optional.ofNullable(clazz.cast(this.managedServicesIpv4Cidrs()));
            }
            case "serviceNetworkEndpoint": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkEndpoint()));
            }
            case "managedS3BackupAccess": {
                return Optional.ofNullable(clazz.cast(this.managedS3BackupAccess()));
            }
            case "zeroEtlAccess": {
                return Optional.ofNullable(clazz.cast(this.zeroEtlAccess()));
            }
            case "s3Access": {
                return Optional.ofNullable(clazz.cast(this.s3Access()));
            }
            case "stsAccess": {
                return Optional.ofNullable(clazz.cast(this.stsAccess()));
            }
            case "kmsAccess": {
                return Optional.ofNullable(clazz.cast(this.kmsAccess()));
            }
            case "crossRegionS3RestoreSourcesAccess": {
                return Optional.ofNullable(clazz.cast(this.crossRegionS3RestoreSourcesAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("resourceGatewayArn", RESOURCE_GATEWAY_ARN_FIELD);
        map.put("managedServicesIpv4Cidrs", MANAGED_SERVICES_IPV4_CIDRS_FIELD);
        map.put("serviceNetworkEndpoint", SERVICE_NETWORK_ENDPOINT_FIELD);
        map.put("managedS3BackupAccess", MANAGED_S3_BACKUP_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        map.put("stsAccess", STS_ACCESS_FIELD);
        map.put("kmsAccess", KMS_ACCESS_FIELD);
        map.put("crossRegionS3RestoreSourcesAccess", CROSS_REGION_S3_RESTORE_SOURCES_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedServices, T> g) {
        return obj -> g.apply((ManagedServices)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceNetworkArn;
        private String resourceGatewayArn;
        private List<String> managedServicesIpv4Cidrs = DefaultSdkAutoConstructList.getInstance();
        private ServiceNetworkEndpoint serviceNetworkEndpoint;
        private ManagedS3BackupAccess managedS3BackupAccess;
        private ZeroEtlAccess zeroEtlAccess;
        private S3Access s3Access;
        private StsAccess stsAccess;
        private KmsAccess kmsAccess;
        private List<CrossRegionS3RestoreSourcesAccess> crossRegionS3RestoreSourcesAccess = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedServices model) {
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.resourceGatewayArn(model.resourceGatewayArn);
            this.managedServicesIpv4Cidrs(model.managedServicesIpv4Cidrs);
            this.serviceNetworkEndpoint(model.serviceNetworkEndpoint);
            this.managedS3BackupAccess(model.managedS3BackupAccess);
            this.zeroEtlAccess(model.zeroEtlAccess);
            this.s3Access(model.s3Access);
            this.stsAccess(model.stsAccess);
            this.kmsAccess(model.kmsAccess);
            this.crossRegionS3RestoreSourcesAccess(model.crossRegionS3RestoreSourcesAccess);
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getResourceGatewayArn() {
            return this.resourceGatewayArn;
        }

        public final void setResourceGatewayArn(String resourceGatewayArn) {
            this.resourceGatewayArn = resourceGatewayArn;
        }

        @Override
        public final Builder resourceGatewayArn(String resourceGatewayArn) {
            this.resourceGatewayArn = resourceGatewayArn;
            return this;
        }

        public final Collection<String> getManagedServicesIpv4Cidrs() {
            if (this.managedServicesIpv4Cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedServicesIpv4Cidrs;
        }

        public final void setManagedServicesIpv4Cidrs(Collection<String> managedServicesIpv4Cidrs) {
            this.managedServicesIpv4Cidrs = StringListCopier.copy(managedServicesIpv4Cidrs);
        }

        @Override
        public final Builder managedServicesIpv4Cidrs(Collection<String> managedServicesIpv4Cidrs) {
            this.managedServicesIpv4Cidrs = StringListCopier.copy(managedServicesIpv4Cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedServicesIpv4Cidrs(String ... managedServicesIpv4Cidrs) {
            this.managedServicesIpv4Cidrs(Arrays.asList(managedServicesIpv4Cidrs));
            return this;
        }

        public final ServiceNetworkEndpoint.Builder getServiceNetworkEndpoint() {
            return this.serviceNetworkEndpoint != null ? this.serviceNetworkEndpoint.toBuilder() : null;
        }

        public final void setServiceNetworkEndpoint(ServiceNetworkEndpoint.BuilderImpl serviceNetworkEndpoint) {
            this.serviceNetworkEndpoint = serviceNetworkEndpoint != null ? serviceNetworkEndpoint.build() : null;
        }

        @Override
        public final Builder serviceNetworkEndpoint(ServiceNetworkEndpoint serviceNetworkEndpoint) {
            this.serviceNetworkEndpoint = serviceNetworkEndpoint;
            return this;
        }

        public final ManagedS3BackupAccess.Builder getManagedS3BackupAccess() {
            return this.managedS3BackupAccess != null ? this.managedS3BackupAccess.toBuilder() : null;
        }

        public final void setManagedS3BackupAccess(ManagedS3BackupAccess.BuilderImpl managedS3BackupAccess) {
            this.managedS3BackupAccess = managedS3BackupAccess != null ? managedS3BackupAccess.build() : null;
        }

        @Override
        public final Builder managedS3BackupAccess(ManagedS3BackupAccess managedS3BackupAccess) {
            this.managedS3BackupAccess = managedS3BackupAccess;
            return this;
        }

        public final ZeroEtlAccess.Builder getZeroEtlAccess() {
            return this.zeroEtlAccess != null ? this.zeroEtlAccess.toBuilder() : null;
        }

        public final void setZeroEtlAccess(ZeroEtlAccess.BuilderImpl zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess != null ? zeroEtlAccess.build() : null;
        }

        @Override
        public final Builder zeroEtlAccess(ZeroEtlAccess zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        public final S3Access.Builder getS3Access() {
            return this.s3Access != null ? this.s3Access.toBuilder() : null;
        }

        public final void setS3Access(S3Access.BuilderImpl s3Access) {
            this.s3Access = s3Access != null ? s3Access.build() : null;
        }

        @Override
        public final Builder s3Access(S3Access s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        public final StsAccess.Builder getStsAccess() {
            return this.stsAccess != null ? this.stsAccess.toBuilder() : null;
        }

        public final void setStsAccess(StsAccess.BuilderImpl stsAccess) {
            this.stsAccess = stsAccess != null ? stsAccess.build() : null;
        }

        @Override
        public final Builder stsAccess(StsAccess stsAccess) {
            this.stsAccess = stsAccess;
            return this;
        }

        public final KmsAccess.Builder getKmsAccess() {
            return this.kmsAccess != null ? this.kmsAccess.toBuilder() : null;
        }

        public final void setKmsAccess(KmsAccess.BuilderImpl kmsAccess) {
            this.kmsAccess = kmsAccess != null ? kmsAccess.build() : null;
        }

        @Override
        public final Builder kmsAccess(KmsAccess kmsAccess) {
            this.kmsAccess = kmsAccess;
            return this;
        }

        public final List<CrossRegionS3RestoreSourcesAccess.Builder> getCrossRegionS3RestoreSourcesAccess() {
            List<CrossRegionS3RestoreSourcesAccess.Builder> result = CrossRegionS3RestoreSourcesAccessListCopier.copyToBuilder(this.crossRegionS3RestoreSourcesAccess);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionS3RestoreSourcesAccess(Collection<CrossRegionS3RestoreSourcesAccess.BuilderImpl> crossRegionS3RestoreSourcesAccess) {
            this.crossRegionS3RestoreSourcesAccess = CrossRegionS3RestoreSourcesAccessListCopier.copyFromBuilder(crossRegionS3RestoreSourcesAccess);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesAccess(Collection<CrossRegionS3RestoreSourcesAccess> crossRegionS3RestoreSourcesAccess) {
            this.crossRegionS3RestoreSourcesAccess = CrossRegionS3RestoreSourcesAccessListCopier.copy(crossRegionS3RestoreSourcesAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesAccess(CrossRegionS3RestoreSourcesAccess ... crossRegionS3RestoreSourcesAccess) {
            this.crossRegionS3RestoreSourcesAccess(Arrays.asList(crossRegionS3RestoreSourcesAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesAccess(Consumer<CrossRegionS3RestoreSourcesAccess.Builder> ... crossRegionS3RestoreSourcesAccess) {
            this.crossRegionS3RestoreSourcesAccess(Stream.of(crossRegionS3RestoreSourcesAccess).map(c -> (CrossRegionS3RestoreSourcesAccess)((CrossRegionS3RestoreSourcesAccess.Builder)CrossRegionS3RestoreSourcesAccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ManagedServices build() {
            return new ManagedServices(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedServices> {
        public Builder serviceNetworkArn(String var1);

        public Builder resourceGatewayArn(String var1);

        public Builder managedServicesIpv4Cidrs(Collection<String> var1);

        public Builder managedServicesIpv4Cidrs(String ... var1);

        public Builder serviceNetworkEndpoint(ServiceNetworkEndpoint var1);

        default public Builder serviceNetworkEndpoint(Consumer<ServiceNetworkEndpoint.Builder> serviceNetworkEndpoint) {
            return this.serviceNetworkEndpoint((ServiceNetworkEndpoint)((ServiceNetworkEndpoint.Builder)ServiceNetworkEndpoint.builder().applyMutation(serviceNetworkEndpoint)).build());
        }

        public Builder managedS3BackupAccess(ManagedS3BackupAccess var1);

        default public Builder managedS3BackupAccess(Consumer<ManagedS3BackupAccess.Builder> managedS3BackupAccess) {
            return this.managedS3BackupAccess((ManagedS3BackupAccess)((ManagedS3BackupAccess.Builder)ManagedS3BackupAccess.builder().applyMutation(managedS3BackupAccess)).build());
        }

        public Builder zeroEtlAccess(ZeroEtlAccess var1);

        default public Builder zeroEtlAccess(Consumer<ZeroEtlAccess.Builder> zeroEtlAccess) {
            return this.zeroEtlAccess((ZeroEtlAccess)((ZeroEtlAccess.Builder)ZeroEtlAccess.builder().applyMutation(zeroEtlAccess)).build());
        }

        public Builder s3Access(S3Access var1);

        default public Builder s3Access(Consumer<S3Access.Builder> s3Access) {
            return this.s3Access((S3Access)((S3Access.Builder)S3Access.builder().applyMutation(s3Access)).build());
        }

        public Builder stsAccess(StsAccess var1);

        default public Builder stsAccess(Consumer<StsAccess.Builder> stsAccess) {
            return this.stsAccess((StsAccess)((StsAccess.Builder)StsAccess.builder().applyMutation(stsAccess)).build());
        }

        public Builder kmsAccess(KmsAccess var1);

        default public Builder kmsAccess(Consumer<KmsAccess.Builder> kmsAccess) {
            return this.kmsAccess((KmsAccess)((KmsAccess.Builder)KmsAccess.builder().applyMutation(kmsAccess)).build());
        }

        public Builder crossRegionS3RestoreSourcesAccess(Collection<CrossRegionS3RestoreSourcesAccess> var1);

        public Builder crossRegionS3RestoreSourcesAccess(CrossRegionS3RestoreSourcesAccess ... var1);

        public Builder crossRegionS3RestoreSourcesAccess(Consumer<CrossRegionS3RestoreSourcesAccess.Builder> ... var1);
    }
}

