/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.odb.model.LicenseModel;
import software.amazon.awssdk.services.odb.model.MaintenanceWindow;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.RequestTagMapCopier;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudAutonomousVmClusterRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, CreateCloudAutonomousVmClusterRequest> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureId").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::cloudExadataInfrastructureId)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::cloudExadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId").build()}).build();
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::odbNetworkId)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::displayName)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::clientToken)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Double> AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("autonomousDataStorageSizeInTBs").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::autonomousDataStorageSizeInTBs)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::autonomousDataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousDataStorageSizeInTBs").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_PER_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCountPerNode").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::cpuCoreCountPerNode)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::cpuCoreCountPerNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCountPerNode").build()}).build();
    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbServers").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::dbServers)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::dbServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::description)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_MTLS_ENABLED_VM_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isMtlsEnabledVmCluster").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::isMtlsEnabledVmCluster)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::isMtlsEnabledVmCluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMtlsEnabledVmCluster").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseModel").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::licenseModelAsString)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::maintenanceWindow)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<Integer> MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memoryPerOracleComputeUnitInGBs").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::memoryPerOracleComputeUnitInGBs)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::memoryPerOracleComputeUnitInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryPerOracleComputeUnitInGBs").build()}).build();
    private static final SdkField<Integer> SCAN_LISTENER_PORT_NON_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scanListenerPortNonTls").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::scanListenerPortNonTls)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::scanListenerPortNonTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortNonTls").build()}).build();
    private static final SdkField<Integer> SCAN_LISTENER_PORT_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scanListenerPortTls").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::scanListenerPortTls)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::scanListenerPortTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortTls").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::tags)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeZone").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::timeZone)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()}).build();
    private static final SdkField<Integer> TOTAL_CONTAINER_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalContainerDatabases").getter(CreateCloudAutonomousVmClusterRequest.getter(CreateCloudAutonomousVmClusterRequest::totalContainerDatabases)).setter(CreateCloudAutonomousVmClusterRequest.setter(Builder::totalContainerDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalContainerDatabases").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, ODB_NETWORK_ID_FIELD, DISPLAY_NAME_FIELD, CLIENT_TOKEN_FIELD, AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD, CPU_CORE_COUNT_PER_NODE_FIELD, DB_SERVERS_FIELD, DESCRIPTION_FIELD, IS_MTLS_ENABLED_VM_CLUSTER_FIELD, LICENSE_MODEL_FIELD, MAINTENANCE_WINDOW_FIELD, MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD, SCAN_LISTENER_PORT_NON_TLS_FIELD, SCAN_LISTENER_PORT_TLS_FIELD, TAGS_FIELD, TIME_ZONE_FIELD, TOTAL_CONTAINER_DATABASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCloudAutonomousVmClusterRequest.memberNameToFieldInitializer();
    private final String cloudExadataInfrastructureId;
    private final String odbNetworkId;
    private final String displayName;
    private final String clientToken;
    private final Double autonomousDataStorageSizeInTBs;
    private final Integer cpuCoreCountPerNode;
    private final List<String> dbServers;
    private final String description;
    private final Boolean isMtlsEnabledVmCluster;
    private final String licenseModel;
    private final MaintenanceWindow maintenanceWindow;
    private final Integer memoryPerOracleComputeUnitInGBs;
    private final Integer scanListenerPortNonTls;
    private final Integer scanListenerPortTls;
    private final Map<String, String> tags;
    private final String timeZone;
    private final Integer totalContainerDatabases;

    private CreateCloudAutonomousVmClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.clientToken = builder.clientToken;
        this.autonomousDataStorageSizeInTBs = builder.autonomousDataStorageSizeInTBs;
        this.cpuCoreCountPerNode = builder.cpuCoreCountPerNode;
        this.dbServers = builder.dbServers;
        this.description = builder.description;
        this.isMtlsEnabledVmCluster = builder.isMtlsEnabledVmCluster;
        this.licenseModel = builder.licenseModel;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.memoryPerOracleComputeUnitInGBs = builder.memoryPerOracleComputeUnitInGBs;
        this.scanListenerPortNonTls = builder.scanListenerPortNonTls;
        this.scanListenerPortTls = builder.scanListenerPortTls;
        this.tags = builder.tags;
        this.timeZone = builder.timeZone;
        this.totalContainerDatabases = builder.totalContainerDatabases;
    }

    public final String cloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Double autonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public final Integer cpuCoreCountPerNode() {
        return this.cpuCoreCountPerNode;
    }

    public final boolean hasDbServers() {
        return this.dbServers != null && !(this.dbServers instanceof SdkAutoConstructList);
    }

    public final List<String> dbServers() {
        return this.dbServers;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isMtlsEnabledVmCluster() {
        return this.isMtlsEnabledVmCluster;
    }

    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(this.licenseModel);
    }

    public final String licenseModelAsString() {
        return this.licenseModel;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final Integer memoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public final Integer scanListenerPortNonTls() {
        return this.scanListenerPortNonTls;
    }

    public final Integer scanListenerPortTls() {
        return this.scanListenerPortTls;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final Integer totalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.autonomousDataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbServers() ? this.dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMtlsEnabledVmCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryPerOracleComputeUnitInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanListenerPortNonTls());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanListenerPortTls());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalContainerDatabases());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudAutonomousVmClusterRequest)) {
            return false;
        }
        CreateCloudAutonomousVmClusterRequest other = (CreateCloudAutonomousVmClusterRequest)((Object)obj);
        return Objects.equals(this.cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId()) && Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.autonomousDataStorageSizeInTBs(), other.autonomousDataStorageSizeInTBs()) && Objects.equals(this.cpuCoreCountPerNode(), other.cpuCoreCountPerNode()) && this.hasDbServers() == other.hasDbServers() && Objects.equals(this.dbServers(), other.dbServers()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isMtlsEnabledVmCluster(), other.isMtlsEnabledVmCluster()) && Objects.equals(this.licenseModelAsString(), other.licenseModelAsString()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.memoryPerOracleComputeUnitInGBs(), other.memoryPerOracleComputeUnitInGBs()) && Objects.equals(this.scanListenerPortNonTls(), other.scanListenerPortNonTls()) && Objects.equals(this.scanListenerPortTls(), other.scanListenerPortTls()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.totalContainerDatabases(), other.totalContainerDatabases());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudAutonomousVmClusterRequest").add("CloudExadataInfrastructureId", (Object)this.cloudExadataInfrastructureId()).add("OdbNetworkId", (Object)this.odbNetworkId()).add("DisplayName", (Object)this.displayName()).add("ClientToken", (Object)this.clientToken()).add("AutonomousDataStorageSizeInTBs", (Object)this.autonomousDataStorageSizeInTBs()).add("CpuCoreCountPerNode", (Object)this.cpuCoreCountPerNode()).add("DbServers", this.hasDbServers() ? this.dbServers() : null).add("Description", (Object)this.description()).add("IsMtlsEnabledVmCluster", (Object)this.isMtlsEnabledVmCluster()).add("LicenseModel", (Object)this.licenseModelAsString()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("MemoryPerOracleComputeUnitInGBs", (Object)this.memoryPerOracleComputeUnitInGBs()).add("ScanListenerPortNonTls", (Object)this.scanListenerPortNonTls()).add("ScanListenerPortTls", (Object)this.scanListenerPortTls()).add("Tags", this.hasTags() ? this.tags() : null).add("TimeZone", (Object)this.timeZone()).add("TotalContainerDatabases", (Object)this.totalContainerDatabases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudExadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureId()));
            }
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "autonomousDataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.autonomousDataStorageSizeInTBs()));
            }
            case "cpuCoreCountPerNode": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCountPerNode()));
            }
            case "dbServers": {
                return Optional.ofNullable(clazz.cast(this.dbServers()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isMtlsEnabledVmCluster": {
                return Optional.ofNullable(clazz.cast(this.isMtlsEnabledVmCluster()));
            }
            case "licenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModelAsString()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "memoryPerOracleComputeUnitInGBs": {
                return Optional.ofNullable(clazz.cast(this.memoryPerOracleComputeUnitInGBs()));
            }
            case "scanListenerPortNonTls": {
                return Optional.ofNullable(clazz.cast(this.scanListenerPortNonTls()));
            }
            case "scanListenerPortTls": {
                return Optional.ofNullable(clazz.cast(this.scanListenerPortTls()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "timeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "totalContainerDatabases": {
                return Optional.ofNullable(clazz.cast(this.totalContainerDatabases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("autonomousDataStorageSizeInTBs", AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("cpuCoreCountPerNode", CPU_CORE_COUNT_PER_NODE_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isMtlsEnabledVmCluster", IS_MTLS_ENABLED_VM_CLUSTER_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("memoryPerOracleComputeUnitInGBs", MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD);
        map.put("scanListenerPortNonTls", SCAN_LISTENER_PORT_NON_TLS_FIELD);
        map.put("scanListenerPortTls", SCAN_LISTENER_PORT_TLS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("totalContainerDatabases", TOTAL_CONTAINER_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudAutonomousVmClusterRequest, T> g) {
        return obj -> g.apply((CreateCloudAutonomousVmClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String cloudExadataInfrastructureId;
        private String odbNetworkId;
        private String displayName;
        private String clientToken;
        private Double autonomousDataStorageSizeInTBs;
        private Integer cpuCoreCountPerNode;
        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean isMtlsEnabledVmCluster;
        private String licenseModel;
        private MaintenanceWindow maintenanceWindow;
        private Integer memoryPerOracleComputeUnitInGBs;
        private Integer scanListenerPortNonTls;
        private Integer scanListenerPortTls;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String timeZone;
        private Integer totalContainerDatabases;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudAutonomousVmClusterRequest model) {
            super(model);
            this.cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            this.odbNetworkId(model.odbNetworkId);
            this.displayName(model.displayName);
            this.clientToken(model.clientToken);
            this.autonomousDataStorageSizeInTBs(model.autonomousDataStorageSizeInTBs);
            this.cpuCoreCountPerNode(model.cpuCoreCountPerNode);
            this.dbServers(model.dbServers);
            this.description(model.description);
            this.isMtlsEnabledVmCluster(model.isMtlsEnabledVmCluster);
            this.licenseModel(model.licenseModel);
            this.maintenanceWindow(model.maintenanceWindow);
            this.memoryPerOracleComputeUnitInGBs(model.memoryPerOracleComputeUnitInGBs);
            this.scanListenerPortNonTls(model.scanListenerPortNonTls);
            this.scanListenerPortTls(model.scanListenerPortTls);
            this.tags(model.tags);
            this.timeZone(model.timeZone);
            this.totalContainerDatabases(model.totalContainerDatabases);
        }

        public final String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Double getAutonomousDataStorageSizeInTBs() {
            return this.autonomousDataStorageSizeInTBs;
        }

        public final void setAutonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        }

        @Override
        public final Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            return this;
        }

        public final Integer getCpuCoreCountPerNode() {
            return this.cpuCoreCountPerNode;
        }

        public final void setCpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        }

        @Override
        public final Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (this.dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String ... dbServers) {
            this.dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsMtlsEnabledVmCluster() {
            return this.isMtlsEnabledVmCluster;
        }

        public final void setIsMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
        }

        @Override
        public final Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getMemoryPerOracleComputeUnitInGBs() {
            return this.memoryPerOracleComputeUnitInGBs;
        }

        public final void setMemoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        }

        @Override
        public final Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            return this;
        }

        public final Integer getScanListenerPortNonTls() {
            return this.scanListenerPortNonTls;
        }

        public final void setScanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
        }

        @Override
        public final Builder scanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            return this;
        }

        public final Integer getScanListenerPortTls() {
            return this.scanListenerPortTls;
        }

        public final void setScanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
        }

        @Override
        public final Builder scanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Integer getTotalContainerDatabases() {
            return this.totalContainerDatabases;
        }

        public final void setTotalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
        }

        @Override
        public final Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudAutonomousVmClusterRequest build() {
            return new CreateCloudAutonomousVmClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudAutonomousVmClusterRequest> {
        public Builder cloudExadataInfrastructureId(String var1);

        public Builder odbNetworkId(String var1);

        public Builder displayName(String var1);

        public Builder clientToken(String var1);

        public Builder autonomousDataStorageSizeInTBs(Double var1);

        public Builder cpuCoreCountPerNode(Integer var1);

        public Builder dbServers(Collection<String> var1);

        public Builder dbServers(String ... var1);

        public Builder description(String var1);

        public Builder isMtlsEnabledVmCluster(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder licenseModel(LicenseModel var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder memoryPerOracleComputeUnitInGBs(Integer var1);

        public Builder scanListenerPortNonTls(Integer var1);

        public Builder scanListenerPortTls(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder timeZone(String var1);

        public Builder totalContainerDatabases(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

