/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ComputeModel;
import software.amazon.awssdk.services.odb.model.DataCollectionOptions;
import software.amazon.awssdk.services.odb.model.DiskRedundancy;
import software.amazon.awssdk.services.odb.model.ExadataIormConfig;
import software.amazon.awssdk.services.odb.model.LicenseModel;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.services.odb.model.SensitiveStringListCopier;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudVmCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudVmCluster> {
    private static final SdkField<String> CLOUD_VM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudVmClusterId").getter(CloudVmCluster.getter(CloudVmCluster::cloudVmClusterId)).setter(CloudVmCluster.setter(Builder::cloudVmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusterId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CloudVmCluster.getter(CloudVmCluster::displayName)).setter(CloudVmCluster.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CloudVmCluster.getter(CloudVmCluster::statusAsString)).setter(CloudVmCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CloudVmCluster.getter(CloudVmCluster::statusReason)).setter(CloudVmCluster.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CLOUD_VM_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudVmClusterArn").getter(CloudVmCluster.getter(CloudVmCluster::cloudVmClusterArn)).setter(CloudVmCluster.setter(Builder::cloudVmClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusterArn").build()}).build();
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureId").getter(CloudVmCluster.getter(CloudVmCluster::cloudExadataInfrastructureId)).setter(CloudVmCluster.setter(Builder::cloudExadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CloudVmCluster.getter(CloudVmCluster::clusterName)).setter(CloudVmCluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCount").getter(CloudVmCluster.getter(CloudVmCluster::cpuCoreCount)).setter(CloudVmCluster.setter(Builder::cpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()}).build();
    private static final SdkField<DataCollectionOptions> DATA_COLLECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataCollectionOptions").getter(CloudVmCluster.getter(CloudVmCluster::dataCollectionOptions)).setter(CloudVmCluster.setter(Builder::dataCollectionOptions)).constructor(DataCollectionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionOptions").build()}).build();
    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("dataStorageSizeInTBs").getter(CloudVmCluster.getter(CloudVmCluster::dataStorageSizeInTBs)).setter(CloudVmCluster.setter(Builder::dataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(CloudVmCluster.getter(CloudVmCluster::dbNodeStorageSizeInGBs)).setter(CloudVmCluster.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbServers").getter(CloudVmCluster.getter(CloudVmCluster::dbServers)).setter(CloudVmCluster.setter(Builder::dbServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISK_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskRedundancy").getter(CloudVmCluster.getter(CloudVmCluster::diskRedundancyAsString)).setter(CloudVmCluster.setter(Builder::diskRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskRedundancy").build()}).build();
    private static final SdkField<String> GI_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("giVersion").getter(CloudVmCluster.getter(CloudVmCluster::giVersion)).setter(CloudVmCluster.setter(Builder::giVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersion").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(CloudVmCluster.getter(CloudVmCluster::hostname)).setter(CloudVmCluster.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<ExadataIormConfig> IORM_CONFIG_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iormConfigCache").getter(CloudVmCluster.getter(CloudVmCluster::iormConfigCache)).setter(CloudVmCluster.setter(Builder::iormConfigCache)).constructor(ExadataIormConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iormConfigCache").build()}).build();
    private static final SdkField<Boolean> IS_LOCAL_BACKUP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isLocalBackupEnabled").getter(CloudVmCluster.getter(CloudVmCluster::isLocalBackupEnabled)).setter(CloudVmCluster.setter(Builder::isLocalBackupEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLocalBackupEnabled").build()}).build();
    private static final SdkField<Boolean> IS_SPARSE_DISKGROUP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSparseDiskgroupEnabled").getter(CloudVmCluster.getter(CloudVmCluster::isSparseDiskgroupEnabled)).setter(CloudVmCluster.setter(Builder::isSparseDiskgroupEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSparseDiskgroupEnabled").build()}).build();
    private static final SdkField<String> LAST_UPDATE_HISTORY_ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdateHistoryEntryId").getter(CloudVmCluster.getter(CloudVmCluster::lastUpdateHistoryEntryId)).setter(CloudVmCluster.setter(Builder::lastUpdateHistoryEntryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateHistoryEntryId").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseModel").getter(CloudVmCluster.getter(CloudVmCluster::licenseModelAsString)).setter(CloudVmCluster.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()}).build();
    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("listenerPort").getter(CloudVmCluster.getter(CloudVmCluster::listenerPort)).setter(CloudVmCluster.setter(Builder::listenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(CloudVmCluster.getter(CloudVmCluster::memorySizeInGBs)).setter(CloudVmCluster.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nodeCount").getter(CloudVmCluster.getter(CloudVmCluster::nodeCount)).setter(CloudVmCluster.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeCount").build()}).build();
    private static final SdkField<String> OCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocid").getter(CloudVmCluster.getter(CloudVmCluster::ocid)).setter(CloudVmCluster.setter(Builder::ocid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(CloudVmCluster.getter(CloudVmCluster::ociResourceAnchorName)).setter(CloudVmCluster.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final SdkField<String> OCI_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociUrl").getter(CloudVmCluster.getter(CloudVmCluster::ociUrl)).setter(CloudVmCluster.setter(Builder::ociUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociUrl").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(CloudVmCluster.getter(CloudVmCluster::domain)).setter(CloudVmCluster.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> SCAN_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanDnsName").getter(CloudVmCluster.getter(CloudVmCluster::scanDnsName)).setter(CloudVmCluster.setter(Builder::scanDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDnsName").build()}).build();
    private static final SdkField<String> SCAN_DNS_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanDnsRecordId").getter(CloudVmCluster.getter(CloudVmCluster::scanDnsRecordId)).setter(CloudVmCluster.setter(Builder::scanDnsRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDnsRecordId").build()}).build();
    private static final SdkField<List<String>> SCAN_IP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanIpIds").getter(CloudVmCluster.getter(CloudVmCluster::scanIpIds)).setter(CloudVmCluster.setter(Builder::scanIpIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanIpIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(CloudVmCluster.getter(CloudVmCluster::shape)).setter(CloudVmCluster.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<List<String>> SSH_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sshPublicKeys").getter(CloudVmCluster.getter(CloudVmCluster::sshPublicKeys)).setter(CloudVmCluster.setter(Builder::sshPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageSizeInGBs").getter(CloudVmCluster.getter(CloudVmCluster::storageSizeInGBs)).setter(CloudVmCluster.setter(Builder::storageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageSizeInGBs").build()}).build();
    private static final SdkField<String> SYSTEM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemVersion").getter(CloudVmCluster.getter(CloudVmCluster::systemVersion)).setter(CloudVmCluster.setter(Builder::systemVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CloudVmCluster.getter(CloudVmCluster::createdAt)).setter(CloudVmCluster.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeZone").getter(CloudVmCluster.getter(CloudVmCluster::timeZone)).setter(CloudVmCluster.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()}).build();
    private static final SdkField<List<String>> VIP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vipIds").getter(CloudVmCluster.getter(CloudVmCluster::vipIds)).setter(CloudVmCluster.setter(Builder::vipIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vipIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(CloudVmCluster.getter(CloudVmCluster::odbNetworkId)).setter(CloudVmCluster.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("percentProgress").getter(CloudVmCluster.getter(CloudVmCluster::percentProgress)).setter(CloudVmCluster.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()}).build();
    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeModel").getter(CloudVmCluster.getter(CloudVmCluster::computeModelAsString)).setter(CloudVmCluster.setter(Builder::computeModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_VM_CLUSTER_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CLOUD_VM_CLUSTER_ARN_FIELD, CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, CLUSTER_NAME_FIELD, CPU_CORE_COUNT_FIELD, DATA_COLLECTION_OPTIONS_FIELD, DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVERS_FIELD, DISK_REDUNDANCY_FIELD, GI_VERSION_FIELD, HOSTNAME_FIELD, IORM_CONFIG_CACHE_FIELD, IS_LOCAL_BACKUP_ENABLED_FIELD, IS_SPARSE_DISKGROUP_ENABLED_FIELD, LAST_UPDATE_HISTORY_ENTRY_ID_FIELD, LICENSE_MODEL_FIELD, LISTENER_PORT_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, NODE_COUNT_FIELD, OCID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, OCI_URL_FIELD, DOMAIN_FIELD, SCAN_DNS_NAME_FIELD, SCAN_DNS_RECORD_ID_FIELD, SCAN_IP_IDS_FIELD, SHAPE_FIELD, SSH_PUBLIC_KEYS_FIELD, STORAGE_SIZE_IN_G_BS_FIELD, SYSTEM_VERSION_FIELD, CREATED_AT_FIELD, TIME_ZONE_FIELD, VIP_IDS_FIELD, ODB_NETWORK_ID_FIELD, PERCENT_PROGRESS_FIELD, COMPUTE_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudVmCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudVmClusterId;
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final String cloudVmClusterArn;
    private final String cloudExadataInfrastructureId;
    private final String clusterName;
    private final Integer cpuCoreCount;
    private final DataCollectionOptions dataCollectionOptions;
    private final Double dataStorageSizeInTBs;
    private final Integer dbNodeStorageSizeInGBs;
    private final List<String> dbServers;
    private final String diskRedundancy;
    private final String giVersion;
    private final String hostname;
    private final ExadataIormConfig iormConfigCache;
    private final Boolean isLocalBackupEnabled;
    private final Boolean isSparseDiskgroupEnabled;
    private final String lastUpdateHistoryEntryId;
    private final String licenseModel;
    private final Integer listenerPort;
    private final Integer memorySizeInGBs;
    private final Integer nodeCount;
    private final String ocid;
    private final String ociResourceAnchorName;
    private final String ociUrl;
    private final String domain;
    private final String scanDnsName;
    private final String scanDnsRecordId;
    private final List<String> scanIpIds;
    private final String shape;
    private final List<String> sshPublicKeys;
    private final Integer storageSizeInGBs;
    private final String systemVersion;
    private final Instant createdAt;
    private final String timeZone;
    private final List<String> vipIds;
    private final String odbNetworkId;
    private final Float percentProgress;
    private final String computeModel;

    private CloudVmCluster(BuilderImpl builder) {
        this.cloudVmClusterId = builder.cloudVmClusterId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudVmClusterArn = builder.cloudVmClusterArn;
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.clusterName = builder.clusterName;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.dataCollectionOptions = builder.dataCollectionOptions;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServers = builder.dbServers;
        this.diskRedundancy = builder.diskRedundancy;
        this.giVersion = builder.giVersion;
        this.hostname = builder.hostname;
        this.iormConfigCache = builder.iormConfigCache;
        this.isLocalBackupEnabled = builder.isLocalBackupEnabled;
        this.isSparseDiskgroupEnabled = builder.isSparseDiskgroupEnabled;
        this.lastUpdateHistoryEntryId = builder.lastUpdateHistoryEntryId;
        this.licenseModel = builder.licenseModel;
        this.listenerPort = builder.listenerPort;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.nodeCount = builder.nodeCount;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.ociUrl = builder.ociUrl;
        this.domain = builder.domain;
        this.scanDnsName = builder.scanDnsName;
        this.scanDnsRecordId = builder.scanDnsRecordId;
        this.scanIpIds = builder.scanIpIds;
        this.shape = builder.shape;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.storageSizeInGBs = builder.storageSizeInGBs;
        this.systemVersion = builder.systemVersion;
        this.createdAt = builder.createdAt;
        this.timeZone = builder.timeZone;
        this.vipIds = builder.vipIds;
        this.odbNetworkId = builder.odbNetworkId;
        this.percentProgress = builder.percentProgress;
        this.computeModel = builder.computeModel;
    }

    public final String cloudVmClusterId() {
        return this.cloudVmClusterId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String cloudVmClusterArn() {
        return this.cloudVmClusterArn;
    }

    public final String cloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Integer cpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final DataCollectionOptions dataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public final Double dataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final boolean hasDbServers() {
        return this.dbServers != null && !(this.dbServers instanceof SdkAutoConstructList);
    }

    public final List<String> dbServers() {
        return this.dbServers;
    }

    public final DiskRedundancy diskRedundancy() {
        return DiskRedundancy.fromValue(this.diskRedundancy);
    }

    public final String diskRedundancyAsString() {
        return this.diskRedundancy;
    }

    public final String giVersion() {
        return this.giVersion;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final ExadataIormConfig iormConfigCache() {
        return this.iormConfigCache;
    }

    public final Boolean isLocalBackupEnabled() {
        return this.isLocalBackupEnabled;
    }

    public final Boolean isSparseDiskgroupEnabled() {
        return this.isSparseDiskgroupEnabled;
    }

    public final String lastUpdateHistoryEntryId() {
        return this.lastUpdateHistoryEntryId;
    }

    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(this.licenseModel);
    }

    public final String licenseModelAsString() {
        return this.licenseModel;
    }

    public final Integer listenerPort() {
        return this.listenerPort;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final Integer nodeCount() {
        return this.nodeCount;
    }

    public final String ocid() {
        return this.ocid;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public final String ociUrl() {
        return this.ociUrl;
    }

    public final String domain() {
        return this.domain;
    }

    public final String scanDnsName() {
        return this.scanDnsName;
    }

    public final String scanDnsRecordId() {
        return this.scanDnsRecordId;
    }

    public final boolean hasScanIpIds() {
        return this.scanIpIds != null && !(this.scanIpIds instanceof SdkAutoConstructList);
    }

    public final List<String> scanIpIds() {
        return this.scanIpIds;
    }

    public final String shape() {
        return this.shape;
    }

    public final boolean hasSshPublicKeys() {
        return this.sshPublicKeys != null && !(this.sshPublicKeys instanceof SdkAutoConstructList);
    }

    public final List<String> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public final Integer storageSizeInGBs() {
        return this.storageSizeInGBs;
    }

    public final String systemVersion() {
        return this.systemVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final boolean hasVipIds() {
        return this.vipIds != null && !(this.vipIds instanceof SdkAutoConstructList);
    }

    public final List<String> vipIds() {
        return this.vipIds;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final Float percentProgress() {
        return this.percentProgress;
    }

    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(this.computeModel);
    }

    public final String computeModelAsString() {
        return this.computeModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudVmClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCollectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbServers() ? this.dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.diskRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.giVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.iormConfigCache());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLocalBackupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSparseDiskgroupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateHistoryEntryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanDnsRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanIpIds() ? this.scanIpIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.shape());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshPublicKeys() ? this.sshPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVipIds() ? this.vipIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudVmCluster)) {
            return false;
        }
        CloudVmCluster other = (CloudVmCluster)obj;
        return Objects.equals(this.cloudVmClusterId(), other.cloudVmClusterId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.cloudVmClusterArn(), other.cloudVmClusterArn()) && Objects.equals(this.cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(this.dataCollectionOptions(), other.dataCollectionOptions()) && Objects.equals(this.dataStorageSizeInTBs(), other.dataStorageSizeInTBs()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && this.hasDbServers() == other.hasDbServers() && Objects.equals(this.dbServers(), other.dbServers()) && Objects.equals(this.diskRedundancyAsString(), other.diskRedundancyAsString()) && Objects.equals(this.giVersion(), other.giVersion()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.iormConfigCache(), other.iormConfigCache()) && Objects.equals(this.isLocalBackupEnabled(), other.isLocalBackupEnabled()) && Objects.equals(this.isSparseDiskgroupEnabled(), other.isSparseDiskgroupEnabled()) && Objects.equals(this.lastUpdateHistoryEntryId(), other.lastUpdateHistoryEntryId()) && Objects.equals(this.licenseModelAsString(), other.licenseModelAsString()) && Objects.equals(this.listenerPort(), other.listenerPort()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.nodeCount(), other.nodeCount()) && Objects.equals(this.ocid(), other.ocid()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName()) && Objects.equals(this.ociUrl(), other.ociUrl()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.scanDnsName(), other.scanDnsName()) && Objects.equals(this.scanDnsRecordId(), other.scanDnsRecordId()) && this.hasScanIpIds() == other.hasScanIpIds() && Objects.equals(this.scanIpIds(), other.scanIpIds()) && Objects.equals(this.shape(), other.shape()) && this.hasSshPublicKeys() == other.hasSshPublicKeys() && Objects.equals(this.sshPublicKeys(), other.sshPublicKeys()) && Objects.equals(this.storageSizeInGBs(), other.storageSizeInGBs()) && Objects.equals(this.systemVersion(), other.systemVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.timeZone(), other.timeZone()) && this.hasVipIds() == other.hasVipIds() && Objects.equals(this.vipIds(), other.vipIds()) && Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.computeModelAsString(), other.computeModelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CloudVmCluster").add("CloudVmClusterId", (Object)this.cloudVmClusterId()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CloudVmClusterArn", (Object)this.cloudVmClusterArn()).add("CloudExadataInfrastructureId", (Object)this.cloudExadataInfrastructureId()).add("ClusterName", (Object)this.clusterName()).add("CpuCoreCount", (Object)this.cpuCoreCount()).add("DataCollectionOptions", (Object)this.dataCollectionOptions()).add("DataStorageSizeInTBs", (Object)this.dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("DbServers", this.hasDbServers() ? this.dbServers() : null).add("DiskRedundancy", (Object)this.diskRedundancyAsString()).add("GiVersion", (Object)this.giVersion()).add("Hostname", (Object)this.hostname()).add("IormConfigCache", (Object)this.iormConfigCache()).add("IsLocalBackupEnabled", (Object)this.isLocalBackupEnabled()).add("IsSparseDiskgroupEnabled", (Object)this.isSparseDiskgroupEnabled()).add("LastUpdateHistoryEntryId", (Object)this.lastUpdateHistoryEntryId()).add("LicenseModel", (Object)this.licenseModelAsString()).add("ListenerPort", (Object)this.listenerPort()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("NodeCount", (Object)this.nodeCount()).add("Ocid", (Object)this.ocid()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).add("OciUrl", (Object)this.ociUrl()).add("Domain", (Object)this.domain()).add("ScanDnsName", (Object)this.scanDnsName()).add("ScanDnsRecordId", (Object)this.scanDnsRecordId()).add("ScanIpIds", this.hasScanIpIds() ? this.scanIpIds() : null).add("Shape", (Object)this.shape()).add("SshPublicKeys", (Object)(this.sshPublicKeys() == null ? null : "*** Sensitive Data Redacted ***")).add("StorageSizeInGBs", (Object)this.storageSizeInGBs()).add("SystemVersion", (Object)this.systemVersion()).add("CreatedAt", (Object)this.createdAt()).add("TimeZone", (Object)this.timeZone()).add("VipIds", this.hasVipIds() ? this.vipIds() : null).add("OdbNetworkId", (Object)this.odbNetworkId()).add("PercentProgress", (Object)this.percentProgress()).add("ComputeModel", (Object)this.computeModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudVmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudVmClusterId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "cloudVmClusterArn": {
                return Optional.ofNullable(clazz.cast(this.cloudVmClusterArn()));
            }
            case "cloudExadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureId()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "cpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCount()));
            }
            case "dataCollectionOptions": {
                return Optional.ofNullable(clazz.cast(this.dataCollectionOptions()));
            }
            case "dataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.dataStorageSizeInTBs()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "dbServers": {
                return Optional.ofNullable(clazz.cast(this.dbServers()));
            }
            case "diskRedundancy": {
                return Optional.ofNullable(clazz.cast(this.diskRedundancyAsString()));
            }
            case "giVersion": {
                return Optional.ofNullable(clazz.cast(this.giVersion()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "iormConfigCache": {
                return Optional.ofNullable(clazz.cast(this.iormConfigCache()));
            }
            case "isLocalBackupEnabled": {
                return Optional.ofNullable(clazz.cast(this.isLocalBackupEnabled()));
            }
            case "isSparseDiskgroupEnabled": {
                return Optional.ofNullable(clazz.cast(this.isSparseDiskgroupEnabled()));
            }
            case "lastUpdateHistoryEntryId": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateHistoryEntryId()));
            }
            case "licenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModelAsString()));
            }
            case "listenerPort": {
                return Optional.ofNullable(clazz.cast(this.listenerPort()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "nodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
            case "ocid": {
                return Optional.ofNullable(clazz.cast(this.ocid()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
            case "ociUrl": {
                return Optional.ofNullable(clazz.cast(this.ociUrl()));
            }
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "scanDnsName": {
                return Optional.ofNullable(clazz.cast(this.scanDnsName()));
            }
            case "scanDnsRecordId": {
                return Optional.ofNullable(clazz.cast(this.scanDnsRecordId()));
            }
            case "scanIpIds": {
                return Optional.ofNullable(clazz.cast(this.scanIpIds()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shape()));
            }
            case "sshPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeys()));
            }
            case "storageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.storageSizeInGBs()));
            }
            case "systemVersion": {
                return Optional.ofNullable(clazz.cast(this.systemVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "timeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "vipIds": {
                return Optional.ofNullable(clazz.cast(this.vipIds()));
            }
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "percentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "computeModel": {
                return Optional.ofNullable(clazz.cast(this.computeModelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudVmClusterId", CLOUD_VM_CLUSTER_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudVmClusterArn", CLOUD_VM_CLUSTER_ARN_FIELD);
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("dataCollectionOptions", DATA_COLLECTION_OPTIONS_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("diskRedundancy", DISK_REDUNDANCY_FIELD);
        map.put("giVersion", GI_VERSION_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("iormConfigCache", IORM_CONFIG_CACHE_FIELD);
        map.put("isLocalBackupEnabled", IS_LOCAL_BACKUP_ENABLED_FIELD);
        map.put("isSparseDiskgroupEnabled", IS_SPARSE_DISKGROUP_ENABLED_FIELD);
        map.put("lastUpdateHistoryEntryId", LAST_UPDATE_HISTORY_ENTRY_ID_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("listenerPort", LISTENER_PORT_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("nodeCount", NODE_COUNT_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("ociUrl", OCI_URL_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("scanDnsName", SCAN_DNS_NAME_FIELD);
        map.put("scanDnsRecordId", SCAN_DNS_RECORD_ID_FIELD);
        map.put("scanIpIds", SCAN_IP_IDS_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("sshPublicKeys", SSH_PUBLIC_KEYS_FIELD);
        map.put("storageSizeInGBs", STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("systemVersion", SYSTEM_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("vipIds", VIP_IDS_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudVmCluster, T> g) {
        return obj -> g.apply((CloudVmCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudVmClusterId;
        private String displayName;
        private String status;
        private String statusReason;
        private String cloudVmClusterArn;
        private String cloudExadataInfrastructureId;
        private String clusterName;
        private Integer cpuCoreCount;
        private DataCollectionOptions dataCollectionOptions;
        private Double dataStorageSizeInTBs;
        private Integer dbNodeStorageSizeInGBs;
        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();
        private String diskRedundancy;
        private String giVersion;
        private String hostname;
        private ExadataIormConfig iormConfigCache;
        private Boolean isLocalBackupEnabled;
        private Boolean isSparseDiskgroupEnabled;
        private String lastUpdateHistoryEntryId;
        private String licenseModel;
        private Integer listenerPort;
        private Integer memorySizeInGBs;
        private Integer nodeCount;
        private String ocid;
        private String ociResourceAnchorName;
        private String ociUrl;
        private String domain;
        private String scanDnsName;
        private String scanDnsRecordId;
        private List<String> scanIpIds = DefaultSdkAutoConstructList.getInstance();
        private String shape;
        private List<String> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();
        private Integer storageSizeInGBs;
        private String systemVersion;
        private Instant createdAt;
        private String timeZone;
        private List<String> vipIds = DefaultSdkAutoConstructList.getInstance();
        private String odbNetworkId;
        private Float percentProgress;
        private String computeModel;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudVmCluster model) {
            this.cloudVmClusterId(model.cloudVmClusterId);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.cloudVmClusterArn(model.cloudVmClusterArn);
            this.cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            this.clusterName(model.clusterName);
            this.cpuCoreCount(model.cpuCoreCount);
            this.dataCollectionOptions(model.dataCollectionOptions);
            this.dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.dbServers(model.dbServers);
            this.diskRedundancy(model.diskRedundancy);
            this.giVersion(model.giVersion);
            this.hostname(model.hostname);
            this.iormConfigCache(model.iormConfigCache);
            this.isLocalBackupEnabled(model.isLocalBackupEnabled);
            this.isSparseDiskgroupEnabled(model.isSparseDiskgroupEnabled);
            this.lastUpdateHistoryEntryId(model.lastUpdateHistoryEntryId);
            this.licenseModel(model.licenseModel);
            this.listenerPort(model.listenerPort);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.nodeCount(model.nodeCount);
            this.ocid(model.ocid);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
            this.ociUrl(model.ociUrl);
            this.domain(model.domain);
            this.scanDnsName(model.scanDnsName);
            this.scanDnsRecordId(model.scanDnsRecordId);
            this.scanIpIds(model.scanIpIds);
            this.shape(model.shape);
            this.sshPublicKeys(model.sshPublicKeys);
            this.storageSizeInGBs(model.storageSizeInGBs);
            this.systemVersion(model.systemVersion);
            this.createdAt(model.createdAt);
            this.timeZone(model.timeZone);
            this.vipIds(model.vipIds);
            this.odbNetworkId(model.odbNetworkId);
            this.percentProgress(model.percentProgress);
            this.computeModel(model.computeModel);
        }

        public final String getCloudVmClusterId() {
            return this.cloudVmClusterId;
        }

        public final void setCloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
        }

        @Override
        public final Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudVmClusterArn() {
            return this.cloudVmClusterArn;
        }

        public final void setCloudVmClusterArn(String cloudVmClusterArn) {
            this.cloudVmClusterArn = cloudVmClusterArn;
        }

        @Override
        public final Builder cloudVmClusterArn(String cloudVmClusterArn) {
            this.cloudVmClusterArn = cloudVmClusterArn;
            return this;
        }

        public final String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final DataCollectionOptions.Builder getDataCollectionOptions() {
            return this.dataCollectionOptions != null ? this.dataCollectionOptions.toBuilder() : null;
        }

        public final void setDataCollectionOptions(DataCollectionOptions.BuilderImpl dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions != null ? dataCollectionOptions.build() : null;
        }

        @Override
        public final Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return this.dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (this.dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String ... dbServers) {
            this.dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final String getDiskRedundancy() {
            return this.diskRedundancy;
        }

        public final void setDiskRedundancy(String diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
        }

        @Override
        public final Builder diskRedundancy(String diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            return this;
        }

        @Override
        public final Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy(diskRedundancy == null ? null : diskRedundancy.toString());
            return this;
        }

        public final String getGiVersion() {
            return this.giVersion;
        }

        public final void setGiVersion(String giVersion) {
            this.giVersion = giVersion;
        }

        @Override
        public final Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final ExadataIormConfig.Builder getIormConfigCache() {
            return this.iormConfigCache != null ? this.iormConfigCache.toBuilder() : null;
        }

        public final void setIormConfigCache(ExadataIormConfig.BuilderImpl iormConfigCache) {
            this.iormConfigCache = iormConfigCache != null ? iormConfigCache.build() : null;
        }

        @Override
        public final Builder iormConfigCache(ExadataIormConfig iormConfigCache) {
            this.iormConfigCache = iormConfigCache;
            return this;
        }

        public final Boolean getIsLocalBackupEnabled() {
            return this.isLocalBackupEnabled;
        }

        public final void setIsLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
        }

        @Override
        public final Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            return this;
        }

        public final Boolean getIsSparseDiskgroupEnabled() {
            return this.isSparseDiskgroupEnabled;
        }

        public final void setIsSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
        }

        @Override
        public final Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            return this;
        }

        public final String getLastUpdateHistoryEntryId() {
            return this.lastUpdateHistoryEntryId;
        }

        public final void setLastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
        }

        @Override
        public final Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final Integer getListenerPort() {
            return this.listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final String getOcid() {
            return this.ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getOciUrl() {
            return this.ociUrl;
        }

        public final void setOciUrl(String ociUrl) {
            this.ociUrl = ociUrl;
        }

        @Override
        public final Builder ociUrl(String ociUrl) {
            this.ociUrl = ociUrl;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getScanDnsName() {
            return this.scanDnsName;
        }

        public final void setScanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
        }

        @Override
        public final Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            return this;
        }

        public final String getScanDnsRecordId() {
            return this.scanDnsRecordId;
        }

        public final void setScanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
        }

        @Override
        public final Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            return this;
        }

        public final Collection<String> getScanIpIds() {
            if (this.scanIpIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scanIpIds;
        }

        public final void setScanIpIds(Collection<String> scanIpIds) {
            this.scanIpIds = StringListCopier.copy(scanIpIds);
        }

        @Override
        public final Builder scanIpIds(Collection<String> scanIpIds) {
            this.scanIpIds = StringListCopier.copy(scanIpIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanIpIds(String ... scanIpIds) {
            this.scanIpIds(Arrays.asList(scanIpIds));
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Collection<String> getSshPublicKeys() {
            if (this.sshPublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshPublicKeys;
        }

        public final void setSshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = SensitiveStringListCopier.copy(sshPublicKeys);
        }

        @Override
        public final Builder sshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = SensitiveStringListCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(String ... sshPublicKeys) {
            this.sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        public final Integer getStorageSizeInGBs() {
            return this.storageSizeInGBs;
        }

        public final void setStorageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
        }

        @Override
        public final Builder storageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
            return this;
        }

        public final String getSystemVersion() {
            return this.systemVersion;
        }

        public final void setSystemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
        }

        @Override
        public final Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Collection<String> getVipIds() {
            if (this.vipIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vipIds;
        }

        public final void setVipIds(Collection<String> vipIds) {
            this.vipIds = StringListCopier.copy(vipIds);
        }

        @Override
        public final Builder vipIds(Collection<String> vipIds) {
            this.vipIds = StringListCopier.copy(vipIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vipIds(String ... vipIds) {
            this.vipIds(Arrays.asList(vipIds));
            return this;
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final Float getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getComputeModel() {
            return this.computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public CloudVmCluster build() {
            return new CloudVmCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudVmCluster> {
        public Builder cloudVmClusterId(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder cloudVmClusterArn(String var1);

        public Builder cloudExadataInfrastructureId(String var1);

        public Builder clusterName(String var1);

        public Builder cpuCoreCount(Integer var1);

        public Builder dataCollectionOptions(DataCollectionOptions var1);

        default public Builder dataCollectionOptions(Consumer<DataCollectionOptions.Builder> dataCollectionOptions) {
            return this.dataCollectionOptions((DataCollectionOptions)((DataCollectionOptions.Builder)DataCollectionOptions.builder().applyMutation(dataCollectionOptions)).build());
        }

        public Builder dataStorageSizeInTBs(Double var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder dbServers(Collection<String> var1);

        public Builder dbServers(String ... var1);

        public Builder diskRedundancy(String var1);

        public Builder diskRedundancy(DiskRedundancy var1);

        public Builder giVersion(String var1);

        public Builder hostname(String var1);

        public Builder iormConfigCache(ExadataIormConfig var1);

        default public Builder iormConfigCache(Consumer<ExadataIormConfig.Builder> iormConfigCache) {
            return this.iormConfigCache((ExadataIormConfig)((ExadataIormConfig.Builder)ExadataIormConfig.builder().applyMutation(iormConfigCache)).build());
        }

        public Builder isLocalBackupEnabled(Boolean var1);

        public Builder isSparseDiskgroupEnabled(Boolean var1);

        public Builder lastUpdateHistoryEntryId(String var1);

        public Builder licenseModel(String var1);

        public Builder licenseModel(LicenseModel var1);

        public Builder listenerPort(Integer var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder nodeCount(Integer var1);

        public Builder ocid(String var1);

        public Builder ociResourceAnchorName(String var1);

        public Builder ociUrl(String var1);

        public Builder domain(String var1);

        public Builder scanDnsName(String var1);

        public Builder scanDnsRecordId(String var1);

        public Builder scanIpIds(Collection<String> var1);

        public Builder scanIpIds(String ... var1);

        public Builder shape(String var1);

        public Builder sshPublicKeys(Collection<String> var1);

        public Builder sshPublicKeys(String ... var1);

        public Builder storageSizeInGBs(Integer var1);

        public Builder systemVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder timeZone(String var1);

        public Builder vipIds(Collection<String> var1);

        public Builder vipIds(String ... var1);

        public Builder odbNetworkId(String var1);

        public Builder percentProgress(Float var1);

        public Builder computeModel(String var1);

        public Builder computeModel(ComputeModel var1);
    }
}

