/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.OdbNetworkListCopier;
import software.amazon.awssdk.services.odb.model.OdbNetworkSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOdbNetworksResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListOdbNetworksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOdbNetworksResponse.getter(ListOdbNetworksResponse::nextToken)).setter(ListOdbNetworksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<OdbNetworkSummary>> ODB_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("odbNetworks").getter(ListOdbNetworksResponse.getter(ListOdbNetworksResponse::odbNetworks)).setter(ListOdbNetworksResponse.setter(Builder::odbNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OdbNetworkSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ODB_NETWORKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOdbNetworksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<OdbNetworkSummary> odbNetworks;

    private ListOdbNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.odbNetworks = builder.odbNetworks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOdbNetworks() {
        return this.odbNetworks != null && !(this.odbNetworks instanceof SdkAutoConstructList);
    }

    public final List<OdbNetworkSummary> odbNetworks() {
        return this.odbNetworks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOdbNetworks() ? this.odbNetworks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOdbNetworksResponse)) {
            return false;
        }
        ListOdbNetworksResponse other = (ListOdbNetworksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOdbNetworks() == other.hasOdbNetworks() && Objects.equals(this.odbNetworks(), other.odbNetworks());
    }

    public final String toString() {
        return ToString.builder((String)"ListOdbNetworksResponse").add("NextToken", (Object)this.nextToken()).add("OdbNetworks", this.hasOdbNetworks() ? this.odbNetworks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "odbNetworks": {
                return Optional.ofNullable(clazz.cast(this.odbNetworks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("odbNetworks", ODB_NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOdbNetworksResponse, T> g) {
        return obj -> g.apply((ListOdbNetworksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OdbNetworkSummary> odbNetworks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOdbNetworksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.odbNetworks(model.odbNetworks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OdbNetworkSummary.Builder> getOdbNetworks() {
            List<OdbNetworkSummary.Builder> result = OdbNetworkListCopier.copyToBuilder(this.odbNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOdbNetworks(Collection<OdbNetworkSummary.BuilderImpl> odbNetworks) {
            this.odbNetworks = OdbNetworkListCopier.copyFromBuilder(odbNetworks);
        }

        @Override
        public final Builder odbNetworks(Collection<OdbNetworkSummary> odbNetworks) {
            this.odbNetworks = OdbNetworkListCopier.copy(odbNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbNetworks(OdbNetworkSummary ... odbNetworks) {
            this.odbNetworks(Arrays.asList(odbNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbNetworks(Consumer<OdbNetworkSummary.Builder> ... odbNetworks) {
            this.odbNetworks(Stream.of(odbNetworks).map(c -> (OdbNetworkSummary)((OdbNetworkSummary.Builder)OdbNetworkSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOdbNetworksResponse build() {
            return new ListOdbNetworksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOdbNetworksResponse> {
        public Builder nextToken(String var1);

        public Builder odbNetworks(Collection<OdbNetworkSummary> var1);

        public Builder odbNetworks(OdbNetworkSummary ... var1);

        public Builder odbNetworks(Consumer<OdbNetworkSummary.Builder> ... var1);
    }
}

