/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.CloudVmClusterListCopier;
import software.amazon.awssdk.services.odb.model.CloudVmClusterSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCloudVmClustersResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListCloudVmClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCloudVmClustersResponse.getter(ListCloudVmClustersResponse::nextToken)).setter(ListCloudVmClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CloudVmClusterSummary>> CLOUD_VM_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cloudVmClusters").getter(ListCloudVmClustersResponse.getter(ListCloudVmClustersResponse::cloudVmClusters)).setter(ListCloudVmClustersResponse.setter(Builder::cloudVmClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudVmClusterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLOUD_VM_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCloudVmClustersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CloudVmClusterSummary> cloudVmClusters;

    private ListCloudVmClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cloudVmClusters = builder.cloudVmClusters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCloudVmClusters() {
        return this.cloudVmClusters != null && !(this.cloudVmClusters instanceof SdkAutoConstructList);
    }

    public final List<CloudVmClusterSummary> cloudVmClusters() {
        return this.cloudVmClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudVmClusters() ? this.cloudVmClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudVmClustersResponse)) {
            return false;
        }
        ListCloudVmClustersResponse other = (ListCloudVmClustersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCloudVmClusters() == other.hasCloudVmClusters() && Objects.equals(this.cloudVmClusters(), other.cloudVmClusters());
    }

    public final String toString() {
        return ToString.builder((String)"ListCloudVmClustersResponse").add("NextToken", (Object)this.nextToken()).add("CloudVmClusters", this.hasCloudVmClusters() ? this.cloudVmClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "cloudVmClusters": {
                return Optional.ofNullable(clazz.cast(this.cloudVmClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("cloudVmClusters", CLOUD_VM_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudVmClustersResponse, T> g) {
        return obj -> g.apply((ListCloudVmClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CloudVmClusterSummary> cloudVmClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudVmClustersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cloudVmClusters(model.cloudVmClusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CloudVmClusterSummary.Builder> getCloudVmClusters() {
            List<CloudVmClusterSummary.Builder> result = CloudVmClusterListCopier.copyToBuilder(this.cloudVmClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudVmClusters(Collection<CloudVmClusterSummary.BuilderImpl> cloudVmClusters) {
            this.cloudVmClusters = CloudVmClusterListCopier.copyFromBuilder(cloudVmClusters);
        }

        @Override
        public final Builder cloudVmClusters(Collection<CloudVmClusterSummary> cloudVmClusters) {
            this.cloudVmClusters = CloudVmClusterListCopier.copy(cloudVmClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudVmClusters(CloudVmClusterSummary ... cloudVmClusters) {
            this.cloudVmClusters(Arrays.asList(cloudVmClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudVmClusters(Consumer<CloudVmClusterSummary.Builder> ... cloudVmClusters) {
            this.cloudVmClusters(Stream.of(cloudVmClusters).map(c -> (CloudVmClusterSummary)((CloudVmClusterSummary.Builder)CloudVmClusterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCloudVmClustersResponse build() {
            return new ListCloudVmClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCloudVmClustersResponse> {
        public Builder nextToken(String var1);

        public Builder cloudVmClusters(Collection<CloudVmClusterSummary> var1);

        public Builder cloudVmClusters(CloudVmClusterSummary ... var1);

        public Builder cloudVmClusters(Consumer<CloudVmClusterSummary.Builder> ... var1);
    }
}

