/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.OdbPeeringConnectionListCopier;
import software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOdbPeeringConnectionsResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListOdbPeeringConnectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOdbPeeringConnectionsResponse.getter(ListOdbPeeringConnectionsResponse::nextToken)).setter(ListOdbPeeringConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<OdbPeeringConnectionSummary>> ODB_PEERING_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("odbPeeringConnections").getter(ListOdbPeeringConnectionsResponse.getter(ListOdbPeeringConnectionsResponse::odbPeeringConnections)).setter(ListOdbPeeringConnectionsResponse.setter(Builder::odbPeeringConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OdbPeeringConnectionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ODB_PEERING_CONNECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOdbPeeringConnectionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<OdbPeeringConnectionSummary> odbPeeringConnections;

    private ListOdbPeeringConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.odbPeeringConnections = builder.odbPeeringConnections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOdbPeeringConnections() {
        return this.odbPeeringConnections != null && !(this.odbPeeringConnections instanceof SdkAutoConstructList);
    }

    public final List<OdbPeeringConnectionSummary> odbPeeringConnections() {
        return this.odbPeeringConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOdbPeeringConnections() ? this.odbPeeringConnections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOdbPeeringConnectionsResponse)) {
            return false;
        }
        ListOdbPeeringConnectionsResponse other = (ListOdbPeeringConnectionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOdbPeeringConnections() == other.hasOdbPeeringConnections() && Objects.equals(this.odbPeeringConnections(), other.odbPeeringConnections());
    }

    public final String toString() {
        return ToString.builder((String)"ListOdbPeeringConnectionsResponse").add("NextToken", (Object)this.nextToken()).add("OdbPeeringConnections", this.hasOdbPeeringConnections() ? this.odbPeeringConnections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "odbPeeringConnections": {
                return Optional.ofNullable(clazz.cast(this.odbPeeringConnections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("odbPeeringConnections", ODB_PEERING_CONNECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOdbPeeringConnectionsResponse, T> g) {
        return obj -> g.apply((ListOdbPeeringConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OdbPeeringConnectionSummary> odbPeeringConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOdbPeeringConnectionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.odbPeeringConnections(model.odbPeeringConnections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OdbPeeringConnectionSummary.Builder> getOdbPeeringConnections() {
            List<OdbPeeringConnectionSummary.Builder> result = OdbPeeringConnectionListCopier.copyToBuilder(this.odbPeeringConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOdbPeeringConnections(Collection<OdbPeeringConnectionSummary.BuilderImpl> odbPeeringConnections) {
            this.odbPeeringConnections = OdbPeeringConnectionListCopier.copyFromBuilder(odbPeeringConnections);
        }

        @Override
        public final Builder odbPeeringConnections(Collection<OdbPeeringConnectionSummary> odbPeeringConnections) {
            this.odbPeeringConnections = OdbPeeringConnectionListCopier.copy(odbPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbPeeringConnections(OdbPeeringConnectionSummary ... odbPeeringConnections) {
            this.odbPeeringConnections(Arrays.asList(odbPeeringConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbPeeringConnections(Consumer<OdbPeeringConnectionSummary.Builder> ... odbPeeringConnections) {
            this.odbPeeringConnections(Stream.of(odbPeeringConnections).map(c -> (OdbPeeringConnectionSummary)((OdbPeeringConnectionSummary.Builder)OdbPeeringConnectionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOdbPeeringConnectionsResponse build() {
            return new ListOdbPeeringConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOdbPeeringConnectionsResponse> {
        public Builder nextToken(String var1);

        public Builder odbPeeringConnections(Collection<OdbPeeringConnectionSummary> var1);

        public Builder odbPeeringConnections(OdbPeeringConnectionSummary ... var1);

        public Builder odbPeeringConnections(Consumer<OdbPeeringConnectionSummary.Builder> ... var1);
    }
}

