/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterSummary;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse;

public class ListCloudAutonomousVmClustersPublisher
implements SdkPublisher<ListCloudAutonomousVmClustersResponse> {
    private final OdbAsyncClient client;
    private final ListCloudAutonomousVmClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCloudAutonomousVmClustersPublisher(OdbAsyncClient client, ListCloudAutonomousVmClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCloudAutonomousVmClustersPublisher(OdbAsyncClient client, ListCloudAutonomousVmClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCloudAutonomousVmClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCloudAutonomousVmClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudAutonomousVmClusterSummary> cloudAutonomousVmClusters() {
        Function<ListCloudAutonomousVmClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudAutonomousVmClusters() != null) {
                return response.cloudAutonomousVmClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCloudAutonomousVmClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCloudAutonomousVmClustersResponseFetcher
    implements AsyncPageFetcher<ListCloudAutonomousVmClustersResponse> {
        private ListCloudAutonomousVmClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudAutonomousVmClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCloudAutonomousVmClustersResponse> nextPage(ListCloudAutonomousVmClustersResponse previousPage) {
            if (previousPage == null) {
                return ListCloudAutonomousVmClustersPublisher.this.client.listCloudAutonomousVmClusters(ListCloudAutonomousVmClustersPublisher.this.firstRequest);
            }
            return ListCloudAutonomousVmClustersPublisher.this.client.listCloudAutonomousVmClusters((ListCloudAutonomousVmClustersRequest)((Object)ListCloudAutonomousVmClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

