/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse;
import software.amazon.awssdk.services.odb.model.SystemVersionSummary;

public class ListSystemVersionsPublisher
implements SdkPublisher<ListSystemVersionsResponse> {
    private final OdbAsyncClient client;
    private final ListSystemVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSystemVersionsPublisher(OdbAsyncClient client, ListSystemVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSystemVersionsPublisher(OdbAsyncClient client, ListSystemVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSystemVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSystemVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SystemVersionSummary> systemVersions() {
        Function<ListSystemVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.systemVersions() != null) {
                return response.systemVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSystemVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSystemVersionsResponseFetcher
    implements AsyncPageFetcher<ListSystemVersionsResponse> {
        private ListSystemVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSystemVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSystemVersionsResponse> nextPage(ListSystemVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListSystemVersionsPublisher.this.client.listSystemVersions(ListSystemVersionsPublisher.this.firstRequest);
            }
            return ListSystemVersionsPublisher.this.client.listSystemVersions((ListSystemVersionsRequest)((Object)ListSystemVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

