/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCloudExadataInfrastructureUnallocatedResourcesRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, GetCloudExadataInfrastructureUnallocatedResourcesRequest> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureId").getter(GetCloudExadataInfrastructureUnallocatedResourcesRequest.getter(GetCloudExadataInfrastructureUnallocatedResourcesRequest::cloudExadataInfrastructureId)).setter(GetCloudExadataInfrastructureUnallocatedResourcesRequest.setter(Builder::cloudExadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId").build()}).build();
    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbServers").getter(GetCloudExadataInfrastructureUnallocatedResourcesRequest.getter(GetCloudExadataInfrastructureUnallocatedResourcesRequest::dbServers)).setter(GetCloudExadataInfrastructureUnallocatedResourcesRequest.setter(Builder::dbServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, DB_SERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCloudExadataInfrastructureUnallocatedResourcesRequest.memberNameToFieldInitializer();
    private final String cloudExadataInfrastructureId;
    private final List<String> dbServers;

    private GetCloudExadataInfrastructureUnallocatedResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.dbServers = builder.dbServers;
    }

    public final String cloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public final boolean hasDbServers() {
        return this.dbServers != null && !(this.dbServers instanceof SdkAutoConstructList);
    }

    public final List<String> dbServers() {
        return this.dbServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbServers() ? this.dbServers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudExadataInfrastructureUnallocatedResourcesRequest)) {
            return false;
        }
        GetCloudExadataInfrastructureUnallocatedResourcesRequest other = (GetCloudExadataInfrastructureUnallocatedResourcesRequest)((Object)obj);
        return Objects.equals(this.cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId()) && this.hasDbServers() == other.hasDbServers() && Objects.equals(this.dbServers(), other.dbServers());
    }

    public final String toString() {
        return ToString.builder((String)"GetCloudExadataInfrastructureUnallocatedResourcesRequest").add("CloudExadataInfrastructureId", (Object)this.cloudExadataInfrastructureId()).add("DbServers", this.hasDbServers() ? this.dbServers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudExadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureId()));
            }
            case "dbServers": {
                return Optional.ofNullable(clazz.cast(this.dbServers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCloudExadataInfrastructureUnallocatedResourcesRequest, T> g) {
        return obj -> g.apply((GetCloudExadataInfrastructureUnallocatedResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String cloudExadataInfrastructureId;
        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudExadataInfrastructureUnallocatedResourcesRequest model) {
            super(model);
            this.cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            this.dbServers(model.dbServers);
        }

        public final String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (this.dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String ... dbServers) {
            this.dbServers(Arrays.asList(dbServers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCloudExadataInfrastructureUnallocatedResourcesRequest build() {
            return new GetCloudExadataInfrastructureUnallocatedResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCloudExadataInfrastructureUnallocatedResourcesRequest> {
        public Builder cloudExadataInfrastructureId(String var1);

        public Builder dbServers(Collection<String> var1);

        public Builder dbServers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

