/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ManagedResourceStatus;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Access
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Access> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(S3Access.getter(S3Access::statusAsString)).setter(S3Access.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> IPV4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipv4Addresses").getter(S3Access.getter(S3Access::ipv4Addresses)).setter(S3Access.setter(Builder::ipv4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(S3Access.getter(S3Access::domainName)).setter(S3Access.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> S3_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3PolicyDocument").getter(S3Access.getter(S3Access::s3PolicyDocument)).setter(S3Access.setter(Builder::s3PolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3PolicyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, IPV4_ADDRESSES_FIELD, DOMAIN_NAME_FIELD, S3_POLICY_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Access.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<String> ipv4Addresses;
    private final String domainName;
    private final String s3PolicyDocument;

    private S3Access(BuilderImpl builder) {
        this.status = builder.status;
        this.ipv4Addresses = builder.ipv4Addresses;
        this.domainName = builder.domainName;
        this.s3PolicyDocument = builder.s3PolicyDocument;
    }

    public final ManagedResourceStatus status() {
        return ManagedResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasIpv4Addresses() {
        return this.ipv4Addresses != null && !(this.ipv4Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String s3PolicyDocument() {
        return this.s3PolicyDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Addresses() ? this.ipv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PolicyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Access)) {
            return false;
        }
        S3Access other = (S3Access)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasIpv4Addresses() == other.hasIpv4Addresses() && Objects.equals(this.ipv4Addresses(), other.ipv4Addresses()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.s3PolicyDocument(), other.s3PolicyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"S3Access").add("Status", (Object)this.statusAsString()).add("Ipv4Addresses", this.hasIpv4Addresses() ? this.ipv4Addresses() : null).add("DomainName", (Object)this.domainName()).add("S3PolicyDocument", (Object)this.s3PolicyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ipv4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv4Addresses()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "s3PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.s3PolicyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("ipv4Addresses", IPV4_ADDRESSES_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("s3PolicyDocument", S3_POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Access, T> g) {
        return obj -> g.apply((S3Access)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<String> ipv4Addresses = DefaultSdkAutoConstructList.getInstance();
        private String domainName;
        private String s3PolicyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Access model) {
            this.status(model.status);
            this.ipv4Addresses(model.ipv4Addresses);
            this.domainName(model.domainName);
            this.s3PolicyDocument(model.s3PolicyDocument);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getIpv4Addresses() {
            if (this.ipv4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv4Addresses;
        }

        public final void setIpv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = StringListCopier.copy(ipv4Addresses);
        }

        @Override
        public final Builder ipv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = StringListCopier.copy(ipv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Addresses(String ... ipv4Addresses) {
            this.ipv4Addresses(Arrays.asList(ipv4Addresses));
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getS3PolicyDocument() {
            return this.s3PolicyDocument;
        }

        public final void setS3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
        }

        @Override
        public final Builder s3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
            return this;
        }

        public S3Access build() {
            return new S3Access(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Access> {
        public Builder status(String var1);

        public Builder status(ManagedResourceStatus var1);

        public Builder ipv4Addresses(Collection<String> var1);

        public Builder ipv4Addresses(String ... var1);

        public Builder domainName(String var1);

        public Builder s3PolicyDocument(String var1);
    }
}

