/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOdbPeeringConnectionRequest extends OdbRequest implements
        ToCopyableBuilder<CreateOdbPeeringConnectionRequest.Builder, CreateOdbPeeringConnectionRequest> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(CreateOdbPeeringConnectionRequest::odbNetworkId))
            .setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<String> PEER_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("peerNetworkId").getter(getter(CreateOdbPeeringConnectionRequest::peerNetworkId))
            .setter(setter(Builder::peerNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerNetworkId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateOdbPeeringConnectionRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateOdbPeeringConnectionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateOdbPeeringConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD,
            PEER_NETWORK_ID_FIELD, DISPLAY_NAME_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String odbNetworkId;

    private final String peerNetworkId;

    private final String displayName;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateOdbPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.odbNetworkId = builder.odbNetworkId;
        this.peerNetworkId = builder.peerNetworkId;
        this.displayName = builder.displayName;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the ODB network that initiates the peering connection.
     * </p>
     * 
     * @return The unique identifier of the ODB network that initiates the peering connection.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * The unique identifier of the peer network. This can be either a VPC ID or another ODB network ID.
     * </p>
     * 
     * @return The unique identifier of the peer network. This can be either a VPC ID or another ODB network ID.
     */
    public final String peerNetworkId() {
        return peerNetworkId;
    }

    /**
     * <p>
     * The display name for the ODB peering connection.
     * </p>
     * 
     * @return The display name for the ODB peering connection.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The client token for the ODB peering connection request.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be unique for each request.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The client token for the ODB peering connection request.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be unique for each request.
     *         </p>
     *         </li>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the ODB peering connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the ODB peering connection.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(peerNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOdbPeeringConnectionRequest)) {
            return false;
        }
        CreateOdbPeeringConnectionRequest other = (CreateOdbPeeringConnectionRequest) obj;
        return Objects.equals(odbNetworkId(), other.odbNetworkId()) && Objects.equals(peerNetworkId(), other.peerNetworkId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOdbPeeringConnectionRequest").add("OdbNetworkId", odbNetworkId())
                .add("PeerNetworkId", peerNetworkId()).add("DisplayName", displayName()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "peerNetworkId":
            return Optional.ofNullable(clazz.cast(peerNetworkId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("peerNetworkId", PEER_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOdbPeeringConnectionRequest, T> g) {
        return obj -> g.apply((CreateOdbPeeringConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOdbPeeringConnectionRequest> {
        /**
         * <p>
         * The unique identifier of the ODB network that initiates the peering connection.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network that initiates the peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * The unique identifier of the peer network. This can be either a VPC ID or another ODB network ID.
         * </p>
         * 
         * @param peerNetworkId
         *        The unique identifier of the peer network. This can be either a VPC ID or another ODB network ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerNetworkId(String peerNetworkId);

        /**
         * <p>
         * The display name for the ODB peering connection.
         * </p>
         * 
         * @param displayName
         *        The display name for the ODB peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The client token for the ODB peering connection request.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be unique for each request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clientToken
         *        The client token for the ODB peering connection request.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be unique for each request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to assign to the ODB peering connection.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the ODB peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String odbNetworkId;

        private String peerNetworkId;

        private String displayName;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOdbPeeringConnectionRequest model) {
            super(model);
            odbNetworkId(model.odbNetworkId);
            peerNetworkId(model.peerNetworkId);
            displayName(model.displayName);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getPeerNetworkId() {
            return peerNetworkId;
        }

        public final void setPeerNetworkId(String peerNetworkId) {
            this.peerNetworkId = peerNetworkId;
        }

        @Override
        public final Builder peerNetworkId(String peerNetworkId) {
            this.peerNetworkId = peerNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOdbPeeringConnectionRequest build() {
            return new CreateOdbPeeringConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
