/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.services.odb.model.SystemVersionListCopier;
import software.amazon.awssdk.services.odb.model.SystemVersionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSystemVersionsResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListSystemVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSystemVersionsResponse.getter(ListSystemVersionsResponse::nextToken)).setter(ListSystemVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SystemVersionSummary>> SYSTEM_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("systemVersions").getter(ListSystemVersionsResponse.getter(ListSystemVersionsResponse::systemVersions)).setter(ListSystemVersionsResponse.setter(Builder::systemVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SYSTEM_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSystemVersionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SystemVersionSummary> systemVersions;

    private ListSystemVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.systemVersions = builder.systemVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSystemVersions() {
        return this.systemVersions != null && !(this.systemVersions instanceof SdkAutoConstructList);
    }

    public final List<SystemVersionSummary> systemVersions() {
        return this.systemVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystemVersions() ? this.systemVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSystemVersionsResponse)) {
            return false;
        }
        ListSystemVersionsResponse other = (ListSystemVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSystemVersions() == other.hasSystemVersions() && Objects.equals(this.systemVersions(), other.systemVersions());
    }

    public final String toString() {
        return ToString.builder((String)"ListSystemVersionsResponse").add("NextToken", (Object)this.nextToken()).add("SystemVersions", this.hasSystemVersions() ? this.systemVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "systemVersions": {
                return Optional.ofNullable(clazz.cast(this.systemVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("systemVersions", SYSTEM_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSystemVersionsResponse, T> g) {
        return obj -> g.apply((ListSystemVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SystemVersionSummary> systemVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSystemVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.systemVersions(model.systemVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SystemVersionSummary.Builder> getSystemVersions() {
            List<SystemVersionSummary.Builder> result = SystemVersionListCopier.copyToBuilder(this.systemVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemVersions(Collection<SystemVersionSummary.BuilderImpl> systemVersions) {
            this.systemVersions = SystemVersionListCopier.copyFromBuilder(systemVersions);
        }

        @Override
        public final Builder systemVersions(Collection<SystemVersionSummary> systemVersions) {
            this.systemVersions = SystemVersionListCopier.copy(systemVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemVersions(SystemVersionSummary ... systemVersions) {
            this.systemVersions(Arrays.asList(systemVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemVersions(Consumer<SystemVersionSummary.Builder> ... systemVersions) {
            this.systemVersions(Stream.of(systemVersions).map(c -> (SystemVersionSummary)((SystemVersionSummary.Builder)SystemVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSystemVersionsResponse build() {
            return new ListSystemVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSystemVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder systemVersions(Collection<SystemVersionSummary> var1);

        public Builder systemVersions(SystemVersionSummary ... var1);

        public Builder systemVersions(Consumer<SystemVersionSummary.Builder> ... var1);
    }
}

