/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDbNodeResponse extends OdbResponse implements
        ToCopyableBuilder<StopDbNodeResponse.Builder, StopDbNodeResponse> {
    private static final SdkField<String> DB_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbNodeId").getter(getter(StopDbNodeResponse::dbNodeId)).setter(setter(Builder::dbNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StopDbNodeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(StopDbNodeResponse::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NODE_ID_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbNodeId;

    private final String status;

    private final String statusReason;

    private StopDbNodeResponse(BuilderImpl builder) {
        super(builder);
        this.dbNodeId = builder.dbNodeId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The unique identifier of the DB node that was stopped.
     * </p>
     * 
     * @return The unique identifier of the DB node that was stopped.
     */
    public final String dbNodeId() {
        return dbNodeId;
    }

    /**
     * <p>
     * The current status of the DB node after the stop operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DbNodeResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the DB node after the stop operation.
     * @see DbNodeResourceStatus
     */
    public final DbNodeResourceStatus status() {
        return DbNodeResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the DB node after the stop operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DbNodeResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the DB node after the stop operation.
     * @see DbNodeResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the DB node after the stop operation.
     * </p>
     * 
     * @return Additional information about the status of the DB node after the stop operation.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDbNodeResponse)) {
            return false;
        }
        StopDbNodeResponse other = (StopDbNodeResponse) obj;
        return Objects.equals(dbNodeId(), other.dbNodeId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDbNodeResponse").add("DbNodeId", dbNodeId()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbNodeId":
            return Optional.ofNullable(clazz.cast(dbNodeId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbNodeId", DB_NODE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopDbNodeResponse, T> g) {
        return obj -> g.apply((StopDbNodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopDbNodeResponse> {
        /**
         * <p>
         * The unique identifier of the DB node that was stopped.
         * </p>
         * 
         * @param dbNodeId
         *        The unique identifier of the DB node that was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeId(String dbNodeId);

        /**
         * <p>
         * The current status of the DB node after the stop operation.
         * </p>
         * 
         * @param status
         *        The current status of the DB node after the stop operation.
         * @see DbNodeResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbNodeResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the DB node after the stop operation.
         * </p>
         * 
         * @param status
         *        The current status of the DB node after the stop operation.
         * @see DbNodeResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbNodeResourceStatus
         */
        Builder status(DbNodeResourceStatus status);

        /**
         * <p>
         * Additional information about the status of the DB node after the stop operation.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the status of the DB node after the stop operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String dbNodeId;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDbNodeResponse model) {
            super(model);
            dbNodeId(model.dbNodeId);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getDbNodeId() {
            return dbNodeId;
        }

        public final void setDbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
        }

        @Override
        public final Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DbNodeResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public StopDbNodeResponse build() {
            return new StopDbNodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
