/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an ODB network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OdbNetwork implements SdkPojo, Serializable, ToCopyableBuilder<OdbNetwork.Builder, OdbNetwork> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(OdbNetwork::odbNetworkId)).setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(OdbNetwork::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(OdbNetwork::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(OdbNetwork::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> ODB_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkArn").getter(getter(OdbNetwork::odbNetworkArn)).setter(setter(Builder::odbNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(OdbNetwork::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(OdbNetwork::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> CLIENT_SUBNET_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSubnetCidr").getter(getter(OdbNetwork::clientSubnetCidr))
            .setter(setter(Builder::clientSubnetCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnetCidr").build()).build();

    private static final SdkField<String> BACKUP_SUBNET_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backupSubnetCidr").getter(getter(OdbNetwork::backupSubnetCidr))
            .setter(setter(Builder::backupSubnetCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupSubnetCidr").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(OdbNetwork::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> DEFAULT_DNS_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultDnsPrefix").getter(getter(OdbNetwork::defaultDnsPrefix))
            .setter(setter(Builder::defaultDnsPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDnsPrefix").build()).build();

    private static final SdkField<List<String>> PEERED_CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("peeredCidrs")
            .getter(getter(OdbNetwork::peeredCidrs))
            .setter(setter(Builder::peeredCidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OCI_NETWORK_ANCHOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociNetworkAnchorId").getter(getter(OdbNetwork::ociNetworkAnchorId))
            .setter(setter(Builder::ociNetworkAnchorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociNetworkAnchorId").build())
            .build();

    private static final SdkField<String> OCI_NETWORK_ANCHOR_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociNetworkAnchorUrl").getter(getter(OdbNetwork::ociNetworkAnchorUrl))
            .setter(setter(Builder::ociNetworkAnchorUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociNetworkAnchorUrl").build())
            .build();

    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociResourceAnchorName").getter(getter(OdbNetwork::ociResourceAnchorName))
            .setter(setter(Builder::ociResourceAnchorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build())
            .build();

    private static final SdkField<String> OCI_VCN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociVcnId").getter(getter(OdbNetwork::ociVcnId)).setter(setter(Builder::ociVcnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociVcnId").build()).build();

    private static final SdkField<String> OCI_VCN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociVcnUrl").getter(getter(OdbNetwork::ociVcnUrl)).setter(setter(Builder::ociVcnUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociVcnUrl").build()).build();

    private static final SdkField<List<OciDnsForwardingConfig>> OCI_DNS_FORWARDING_CONFIGS_FIELD = SdkField
            .<List<OciDnsForwardingConfig>> builder(MarshallingType.LIST)
            .memberName("ociDnsForwardingConfigs")
            .getter(getter(OdbNetwork::ociDnsForwardingConfigs))
            .setter(setter(Builder::ociDnsForwardingConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociDnsForwardingConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OciDnsForwardingConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(OciDnsForwardingConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(OdbNetwork::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("percentProgress").getter(getter(OdbNetwork::percentProgress)).setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()).build();

    private static final SdkField<ManagedServices> MANAGED_SERVICES_FIELD = SdkField
            .<ManagedServices> builder(MarshallingType.SDK_POJO).memberName("managedServices")
            .getter(getter(OdbNetwork::managedServices)).setter(setter(Builder::managedServices))
            .constructor(ManagedServices::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedServices").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ODB_NETWORK_ARN_FIELD, AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, CLIENT_SUBNET_CIDR_FIELD, BACKUP_SUBNET_CIDR_FIELD, CUSTOM_DOMAIN_NAME_FIELD,
            DEFAULT_DNS_PREFIX_FIELD, PEERED_CIDRS_FIELD, OCI_NETWORK_ANCHOR_ID_FIELD, OCI_NETWORK_ANCHOR_URL_FIELD,
            OCI_RESOURCE_ANCHOR_NAME_FIELD, OCI_VCN_ID_FIELD, OCI_VCN_URL_FIELD, OCI_DNS_FORWARDING_CONFIGS_FIELD,
            CREATED_AT_FIELD, PERCENT_PROGRESS_FIELD, MANAGED_SERVICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String odbNetworkId;

    private final String displayName;

    private final String status;

    private final String statusReason;

    private final String odbNetworkArn;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String clientSubnetCidr;

    private final String backupSubnetCidr;

    private final String customDomainName;

    private final String defaultDnsPrefix;

    private final List<String> peeredCidrs;

    private final String ociNetworkAnchorId;

    private final String ociNetworkAnchorUrl;

    private final String ociResourceAnchorName;

    private final String ociVcnId;

    private final String ociVcnUrl;

    private final List<OciDnsForwardingConfig> ociDnsForwardingConfigs;

    private final Instant createdAt;

    private final Float percentProgress;

    private final ManagedServices managedServices;

    private OdbNetwork(BuilderImpl builder) {
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.odbNetworkArn = builder.odbNetworkArn;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.clientSubnetCidr = builder.clientSubnetCidr;
        this.backupSubnetCidr = builder.backupSubnetCidr;
        this.customDomainName = builder.customDomainName;
        this.defaultDnsPrefix = builder.defaultDnsPrefix;
        this.peeredCidrs = builder.peeredCidrs;
        this.ociNetworkAnchorId = builder.ociNetworkAnchorId;
        this.ociNetworkAnchorUrl = builder.ociNetworkAnchorUrl;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.ociVcnId = builder.ociVcnId;
        this.ociVcnUrl = builder.ociVcnUrl;
        this.ociDnsForwardingConfigs = builder.ociDnsForwardingConfigs;
        this.createdAt = builder.createdAt;
        this.percentProgress = builder.percentProgress;
        this.managedServices = builder.managedServices;
    }

    /**
     * <p>
     * The unique identifier of the ODB network.
     * </p>
     * 
     * @return The unique identifier of the ODB network.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * The user-friendly name of the ODB network.
     * </p>
     * 
     * @return The user-friendly name of the ODB network.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The current status of the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the ODB network.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the ODB network.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the current status of the ODB network.
     * </p>
     * 
     * @return Additional information about the current status of the ODB network.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ODB network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ODB network.
     */
    public final String odbNetworkArn() {
        return odbNetworkArn;
    }

    /**
     * <p>
     * The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
     * </p>
     * 
     * @return The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AZ ID of the AZ where the ODB network is located.
     * </p>
     * 
     * @return The AZ ID of the AZ where the ODB network is located.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The CIDR range of the client subnet in the ODB network.
     * </p>
     * 
     * @return The CIDR range of the client subnet in the ODB network.
     */
    public final String clientSubnetCidr() {
        return clientSubnetCidr;
    }

    /**
     * <p>
     * The CIDR range of the backup subnet in the ODB network.
     * </p>
     * 
     * @return The CIDR range of the backup subnet in the ODB network.
     */
    public final String backupSubnetCidr() {
        return backupSubnetCidr;
    }

    /**
     * <p>
     * The domain name for the resources in the ODB network.
     * </p>
     * 
     * @return The domain name for the resources in the ODB network.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
     * </p>
     * 
     * @return The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
     */
    public final String defaultDnsPrefix() {
        return defaultDnsPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the PeeredCidrs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPeeredCidrs() {
        return peeredCidrs != null && !(peeredCidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of CIDR ranges from the peered VPC that are allowed access to the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeeredCidrs} method.
     * </p>
     * 
     * @return The list of CIDR ranges from the peered VPC that are allowed access to the ODB network.
     */
    public final List<String> peeredCidrs() {
        return peeredCidrs;
    }

    /**
     * <p>
     * The unique identifier of the OCI network anchor for the ODB network.
     * </p>
     * 
     * @return The unique identifier of the OCI network anchor for the ODB network.
     */
    public final String ociNetworkAnchorId() {
        return ociNetworkAnchorId;
    }

    /**
     * <p>
     * The URL of the OCI network anchor for the ODB network.
     * </p>
     * 
     * @return The URL of the OCI network anchor for the ODB network.
     */
    public final String ociNetworkAnchorUrl() {
        return ociNetworkAnchorUrl;
    }

    /**
     * <p>
     * The name of the OCI resource anchor that's associated with the ODB network.
     * </p>
     * 
     * @return The name of the OCI resource anchor that's associated with the ODB network.
     */
    public final String ociResourceAnchorName() {
        return ociResourceAnchorName;
    }

    /**
     * <p>
     * The Oracle Cloud ID (OCID) for the Virtual Cloud Network (VCN) that's associated with the ODB network.
     * </p>
     * 
     * @return The Oracle Cloud ID (OCID) for the Virtual Cloud Network (VCN) that's associated with the ODB network.
     */
    public final String ociVcnId() {
        return ociVcnId;
    }

    /**
     * <p>
     * The URL for the VCN that's associated with the ODB network.
     * </p>
     * 
     * @return The URL for the VCN that's associated with the ODB network.
     */
    public final String ociVcnUrl() {
        return ociVcnUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the OciDnsForwardingConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOciDnsForwardingConfigs() {
        return ociDnsForwardingConfigs != null && !(ociDnsForwardingConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOciDnsForwardingConfigs} method.
     * </p>
     * 
     * @return The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
     */
    public final List<OciDnsForwardingConfig> ociDnsForwardingConfigs() {
        return ociDnsForwardingConfigs;
    }

    /**
     * <p>
     * The date and time when the ODB network was created.
     * </p>
     * 
     * @return The date and time when the ODB network was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The amount of progress made on the current operation on the ODB network, expressed as a percentage.
     * </p>
     * 
     * @return The amount of progress made on the current operation on the ODB network, expressed as a percentage.
     */
    public final Float percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The managed services configuration for the ODB network.
     * </p>
     * 
     * @return The managed services configuration for the ODB network.
     */
    public final ManagedServices managedServices() {
        return managedServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(backupSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDnsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasPeeredCidrs() ? peeredCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ociNetworkAnchorId());
        hashCode = 31 * hashCode + Objects.hashCode(ociNetworkAnchorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(ociVcnId());
        hashCode = 31 * hashCode + Objects.hashCode(ociVcnUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasOciDnsForwardingConfigs() ? ociDnsForwardingConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(managedServices());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OdbNetwork)) {
            return false;
        }
        OdbNetwork other = (OdbNetwork) obj;
        return Objects.equals(odbNetworkId(), other.odbNetworkId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(odbNetworkArn(), other.odbNetworkArn())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(clientSubnetCidr(), other.clientSubnetCidr())
                && Objects.equals(backupSubnetCidr(), other.backupSubnetCidr())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(defaultDnsPrefix(), other.defaultDnsPrefix()) && hasPeeredCidrs() == other.hasPeeredCidrs()
                && Objects.equals(peeredCidrs(), other.peeredCidrs())
                && Objects.equals(ociNetworkAnchorId(), other.ociNetworkAnchorId())
                && Objects.equals(ociNetworkAnchorUrl(), other.ociNetworkAnchorUrl())
                && Objects.equals(ociResourceAnchorName(), other.ociResourceAnchorName())
                && Objects.equals(ociVcnId(), other.ociVcnId()) && Objects.equals(ociVcnUrl(), other.ociVcnUrl())
                && hasOciDnsForwardingConfigs() == other.hasOciDnsForwardingConfigs()
                && Objects.equals(ociDnsForwardingConfigs(), other.ociDnsForwardingConfigs())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(managedServices(), other.managedServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OdbNetwork").add("OdbNetworkId", odbNetworkId()).add("DisplayName", displayName())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("OdbNetworkArn", odbNetworkArn())
                .add("AvailabilityZone", availabilityZone()).add("AvailabilityZoneId", availabilityZoneId())
                .add("ClientSubnetCidr", clientSubnetCidr()).add("BackupSubnetCidr", backupSubnetCidr())
                .add("CustomDomainName", customDomainName()).add("DefaultDnsPrefix", defaultDnsPrefix())
                .add("PeeredCidrs", hasPeeredCidrs() ? peeredCidrs() : null).add("OciNetworkAnchorId", ociNetworkAnchorId())
                .add("OciNetworkAnchorUrl", ociNetworkAnchorUrl()).add("OciResourceAnchorName", ociResourceAnchorName())
                .add("OciVcnId", ociVcnId()).add("OciVcnUrl", ociVcnUrl())
                .add("OciDnsForwardingConfigs", hasOciDnsForwardingConfigs() ? ociDnsForwardingConfigs() : null)
                .add("CreatedAt", createdAt()).add("PercentProgress", percentProgress())
                .add("ManagedServices", managedServices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "odbNetworkArn":
            return Optional.ofNullable(clazz.cast(odbNetworkArn()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "clientSubnetCidr":
            return Optional.ofNullable(clazz.cast(clientSubnetCidr()));
        case "backupSubnetCidr":
            return Optional.ofNullable(clazz.cast(backupSubnetCidr()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "defaultDnsPrefix":
            return Optional.ofNullable(clazz.cast(defaultDnsPrefix()));
        case "peeredCidrs":
            return Optional.ofNullable(clazz.cast(peeredCidrs()));
        case "ociNetworkAnchorId":
            return Optional.ofNullable(clazz.cast(ociNetworkAnchorId()));
        case "ociNetworkAnchorUrl":
            return Optional.ofNullable(clazz.cast(ociNetworkAnchorUrl()));
        case "ociResourceAnchorName":
            return Optional.ofNullable(clazz.cast(ociResourceAnchorName()));
        case "ociVcnId":
            return Optional.ofNullable(clazz.cast(ociVcnId()));
        case "ociVcnUrl":
            return Optional.ofNullable(clazz.cast(ociVcnUrl()));
        case "ociDnsForwardingConfigs":
            return Optional.ofNullable(clazz.cast(ociDnsForwardingConfigs()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "percentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "managedServices":
            return Optional.ofNullable(clazz.cast(managedServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("odbNetworkArn", ODB_NETWORK_ARN_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("clientSubnetCidr", CLIENT_SUBNET_CIDR_FIELD);
        map.put("backupSubnetCidr", BACKUP_SUBNET_CIDR_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("defaultDnsPrefix", DEFAULT_DNS_PREFIX_FIELD);
        map.put("peeredCidrs", PEERED_CIDRS_FIELD);
        map.put("ociNetworkAnchorId", OCI_NETWORK_ANCHOR_ID_FIELD);
        map.put("ociNetworkAnchorUrl", OCI_NETWORK_ANCHOR_URL_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("ociVcnId", OCI_VCN_ID_FIELD);
        map.put("ociVcnUrl", OCI_VCN_URL_FIELD);
        map.put("ociDnsForwardingConfigs", OCI_DNS_FORWARDING_CONFIGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("managedServices", MANAGED_SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OdbNetwork, T> g) {
        return obj -> g.apply((OdbNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OdbNetwork> {
        /**
         * <p>
         * The unique identifier of the ODB network.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * The user-friendly name of the ODB network.
         * </p>
         * 
         * @param displayName
         *        The user-friendly name of the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The current status of the ODB network.
         * </p>
         * 
         * @param status
         *        The current status of the ODB network.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the ODB network.
         * </p>
         * 
         * @param status
         *        The current status of the ODB network.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Additional information about the current status of the ODB network.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the current status of the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ODB network.
         * </p>
         * 
         * @param odbNetworkArn
         *        The Amazon Resource Name (ARN) of the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkArn(String odbNetworkArn);

        /**
         * <p>
         * The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
         * </p>
         * 
         * @param availabilityZone
         *        The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AZ ID of the AZ where the ODB network is located.
         * </p>
         * 
         * @param availabilityZoneId
         *        The AZ ID of the AZ where the ODB network is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The CIDR range of the client subnet in the ODB network.
         * </p>
         * 
         * @param clientSubnetCidr
         *        The CIDR range of the client subnet in the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnetCidr(String clientSubnetCidr);

        /**
         * <p>
         * The CIDR range of the backup subnet in the ODB network.
         * </p>
         * 
         * @param backupSubnetCidr
         *        The CIDR range of the backup subnet in the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSubnetCidr(String backupSubnetCidr);

        /**
         * <p>
         * The domain name for the resources in the ODB network.
         * </p>
         * 
         * @param customDomainName
         *        The domain name for the resources in the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
         * </p>
         * 
         * @param defaultDnsPrefix
         *        The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDnsPrefix(String defaultDnsPrefix);

        /**
         * <p>
         * The list of CIDR ranges from the peered VPC that are allowed access to the ODB network.
         * </p>
         * 
         * @param peeredCidrs
         *        The list of CIDR ranges from the peered VPC that are allowed access to the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeredCidrs(Collection<String> peeredCidrs);

        /**
         * <p>
         * The list of CIDR ranges from the peered VPC that are allowed access to the ODB network.
         * </p>
         * 
         * @param peeredCidrs
         *        The list of CIDR ranges from the peered VPC that are allowed access to the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeredCidrs(String... peeredCidrs);

        /**
         * <p>
         * The unique identifier of the OCI network anchor for the ODB network.
         * </p>
         * 
         * @param ociNetworkAnchorId
         *        The unique identifier of the OCI network anchor for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociNetworkAnchorId(String ociNetworkAnchorId);

        /**
         * <p>
         * The URL of the OCI network anchor for the ODB network.
         * </p>
         * 
         * @param ociNetworkAnchorUrl
         *        The URL of the OCI network anchor for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociNetworkAnchorUrl(String ociNetworkAnchorUrl);

        /**
         * <p>
         * The name of the OCI resource anchor that's associated with the ODB network.
         * </p>
         * 
         * @param ociResourceAnchorName
         *        The name of the OCI resource anchor that's associated with the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociResourceAnchorName(String ociResourceAnchorName);

        /**
         * <p>
         * The Oracle Cloud ID (OCID) for the Virtual Cloud Network (VCN) that's associated with the ODB network.
         * </p>
         * 
         * @param ociVcnId
         *        The Oracle Cloud ID (OCID) for the Virtual Cloud Network (VCN) that's associated with the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociVcnId(String ociVcnId);

        /**
         * <p>
         * The URL for the VCN that's associated with the ODB network.
         * </p>
         * 
         * @param ociVcnUrl
         *        The URL for the VCN that's associated with the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociVcnUrl(String ociVcnUrl);

        /**
         * <p>
         * The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
         * </p>
         * 
         * @param ociDnsForwardingConfigs
         *        The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociDnsForwardingConfigs(Collection<OciDnsForwardingConfig> ociDnsForwardingConfigs);

        /**
         * <p>
         * The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
         * </p>
         * 
         * @param ociDnsForwardingConfigs
         *        The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociDnsForwardingConfigs(OciDnsForwardingConfig... ociDnsForwardingConfigs);

        /**
         * <p>
         * The DNS resolver endpoint in OCI for forwarding DNS queries for the ociPrivateZone domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.OciDnsForwardingConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.odb.model.OciDnsForwardingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.OciDnsForwardingConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #ociDnsForwardingConfigs(List<OciDnsForwardingConfig>)}.
         * 
         * @param ociDnsForwardingConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.OciDnsForwardingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ociDnsForwardingConfigs(java.util.Collection<OciDnsForwardingConfig>)
         */
        Builder ociDnsForwardingConfigs(Consumer<OciDnsForwardingConfig.Builder>... ociDnsForwardingConfigs);

        /**
         * <p>
         * The date and time when the ODB network was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the ODB network was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The amount of progress made on the current operation on the ODB network, expressed as a percentage.
         * </p>
         * 
         * @param percentProgress
         *        The amount of progress made on the current operation on the ODB network, expressed as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Float percentProgress);

        /**
         * <p>
         * The managed services configuration for the ODB network.
         * </p>
         * 
         * @param managedServices
         *        The managed services configuration for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedServices(ManagedServices managedServices);

        /**
         * <p>
         * The managed services configuration for the ODB network.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedServices.Builder} avoiding the
         * need to create one manually via {@link ManagedServices#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedServices.Builder#build()} is called immediately and its
         * result is passed to {@link #managedServices(ManagedServices)}.
         * 
         * @param managedServices
         *        a consumer that will call methods on {@link ManagedServices.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedServices(ManagedServices)
         */
        default Builder managedServices(Consumer<ManagedServices.Builder> managedServices) {
            return managedServices(ManagedServices.builder().applyMutation(managedServices).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String odbNetworkId;

        private String displayName;

        private String status;

        private String statusReason;

        private String odbNetworkArn;

        private String availabilityZone;

        private String availabilityZoneId;

        private String clientSubnetCidr;

        private String backupSubnetCidr;

        private String customDomainName;

        private String defaultDnsPrefix;

        private List<String> peeredCidrs = DefaultSdkAutoConstructList.getInstance();

        private String ociNetworkAnchorId;

        private String ociNetworkAnchorUrl;

        private String ociResourceAnchorName;

        private String ociVcnId;

        private String ociVcnUrl;

        private List<OciDnsForwardingConfig> ociDnsForwardingConfigs = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Float percentProgress;

        private ManagedServices managedServices;

        private BuilderImpl() {
        }

        private BuilderImpl(OdbNetwork model) {
            odbNetworkId(model.odbNetworkId);
            displayName(model.displayName);
            status(model.status);
            statusReason(model.statusReason);
            odbNetworkArn(model.odbNetworkArn);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            clientSubnetCidr(model.clientSubnetCidr);
            backupSubnetCidr(model.backupSubnetCidr);
            customDomainName(model.customDomainName);
            defaultDnsPrefix(model.defaultDnsPrefix);
            peeredCidrs(model.peeredCidrs);
            ociNetworkAnchorId(model.ociNetworkAnchorId);
            ociNetworkAnchorUrl(model.ociNetworkAnchorUrl);
            ociResourceAnchorName(model.ociResourceAnchorName);
            ociVcnId(model.ociVcnId);
            ociVcnUrl(model.ociVcnUrl);
            ociDnsForwardingConfigs(model.ociDnsForwardingConfigs);
            createdAt(model.createdAt);
            percentProgress(model.percentProgress);
            managedServices(model.managedServices);
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOdbNetworkArn() {
            return odbNetworkArn;
        }

        public final void setOdbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
        }

        @Override
        public final Builder odbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getClientSubnetCidr() {
            return clientSubnetCidr;
        }

        public final void setClientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
        }

        @Override
        public final Builder clientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
            return this;
        }

        public final String getBackupSubnetCidr() {
            return backupSubnetCidr;
        }

        public final void setBackupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
        }

        @Override
        public final Builder backupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDefaultDnsPrefix() {
            return defaultDnsPrefix;
        }

        public final void setDefaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
        }

        @Override
        public final Builder defaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
            return this;
        }

        public final Collection<String> getPeeredCidrs() {
            if (peeredCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return peeredCidrs;
        }

        public final void setPeeredCidrs(Collection<String> peeredCidrs) {
            this.peeredCidrs = StringListCopier.copy(peeredCidrs);
        }

        @Override
        public final Builder peeredCidrs(Collection<String> peeredCidrs) {
            this.peeredCidrs = StringListCopier.copy(peeredCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrs(String... peeredCidrs) {
            peeredCidrs(Arrays.asList(peeredCidrs));
            return this;
        }

        public final String getOciNetworkAnchorId() {
            return ociNetworkAnchorId;
        }

        public final void setOciNetworkAnchorId(String ociNetworkAnchorId) {
            this.ociNetworkAnchorId = ociNetworkAnchorId;
        }

        @Override
        public final Builder ociNetworkAnchorId(String ociNetworkAnchorId) {
            this.ociNetworkAnchorId = ociNetworkAnchorId;
            return this;
        }

        public final String getOciNetworkAnchorUrl() {
            return ociNetworkAnchorUrl;
        }

        public final void setOciNetworkAnchorUrl(String ociNetworkAnchorUrl) {
            this.ociNetworkAnchorUrl = ociNetworkAnchorUrl;
        }

        @Override
        public final Builder ociNetworkAnchorUrl(String ociNetworkAnchorUrl) {
            this.ociNetworkAnchorUrl = ociNetworkAnchorUrl;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getOciVcnId() {
            return ociVcnId;
        }

        public final void setOciVcnId(String ociVcnId) {
            this.ociVcnId = ociVcnId;
        }

        @Override
        public final Builder ociVcnId(String ociVcnId) {
            this.ociVcnId = ociVcnId;
            return this;
        }

        public final String getOciVcnUrl() {
            return ociVcnUrl;
        }

        public final void setOciVcnUrl(String ociVcnUrl) {
            this.ociVcnUrl = ociVcnUrl;
        }

        @Override
        public final Builder ociVcnUrl(String ociVcnUrl) {
            this.ociVcnUrl = ociVcnUrl;
            return this;
        }

        public final List<OciDnsForwardingConfig.Builder> getOciDnsForwardingConfigs() {
            List<OciDnsForwardingConfig.Builder> result = OciDnsForwardingConfigListCopier
                    .copyToBuilder(this.ociDnsForwardingConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOciDnsForwardingConfigs(Collection<OciDnsForwardingConfig.BuilderImpl> ociDnsForwardingConfigs) {
            this.ociDnsForwardingConfigs = OciDnsForwardingConfigListCopier.copyFromBuilder(ociDnsForwardingConfigs);
        }

        @Override
        public final Builder ociDnsForwardingConfigs(Collection<OciDnsForwardingConfig> ociDnsForwardingConfigs) {
            this.ociDnsForwardingConfigs = OciDnsForwardingConfigListCopier.copy(ociDnsForwardingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ociDnsForwardingConfigs(OciDnsForwardingConfig... ociDnsForwardingConfigs) {
            ociDnsForwardingConfigs(Arrays.asList(ociDnsForwardingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ociDnsForwardingConfigs(Consumer<OciDnsForwardingConfig.Builder>... ociDnsForwardingConfigs) {
            ociDnsForwardingConfigs(Stream.of(ociDnsForwardingConfigs)
                    .map(c -> OciDnsForwardingConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Float getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final ManagedServices.Builder getManagedServices() {
            return managedServices != null ? managedServices.toBuilder() : null;
        }

        public final void setManagedServices(ManagedServices.BuilderImpl managedServices) {
            this.managedServices = managedServices != null ? managedServices.build() : null;
        }

        @Override
        public final Builder managedServices(ManagedServices managedServices) {
            this.managedServices = managedServices;
            return this;
        }

        @Override
        public OdbNetwork build() {
            return new OdbNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
