/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutonomousVirtualMachinesResponse extends OdbResponse implements
        ToCopyableBuilder<ListAutonomousVirtualMachinesResponse.Builder, ListAutonomousVirtualMachinesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAutonomousVirtualMachinesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AutonomousVirtualMachineSummary>> AUTONOMOUS_VIRTUAL_MACHINES_FIELD = SdkField
            .<List<AutonomousVirtualMachineSummary>> builder(MarshallingType.LIST)
            .memberName("autonomousVirtualMachines")
            .getter(getter(ListAutonomousVirtualMachinesResponse::autonomousVirtualMachines))
            .setter(setter(Builder::autonomousVirtualMachines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousVirtualMachines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutonomousVirtualMachineSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutonomousVirtualMachineSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AUTONOMOUS_VIRTUAL_MACHINES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<AutonomousVirtualMachineSummary> autonomousVirtualMachines;

    private ListAutonomousVirtualMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.autonomousVirtualMachines = builder.autonomousVirtualMachines;
    }

    /**
     * <p>
     * The pagination token from which to continue listing.
     * </p>
     * 
     * @return The pagination token from which to continue listing.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutonomousVirtualMachines property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutonomousVirtualMachines() {
        return autonomousVirtualMachines != null && !(autonomousVirtualMachines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Autonomous VMs in the specified Autonomous VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutonomousVirtualMachines} method.
     * </p>
     * 
     * @return The list of Autonomous VMs in the specified Autonomous VM cluster.
     */
    public final List<AutonomousVirtualMachineSummary> autonomousVirtualMachines() {
        return autonomousVirtualMachines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutonomousVirtualMachines() ? autonomousVirtualMachines() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutonomousVirtualMachinesResponse)) {
            return false;
        }
        ListAutonomousVirtualMachinesResponse other = (ListAutonomousVirtualMachinesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasAutonomousVirtualMachines() == other.hasAutonomousVirtualMachines()
                && Objects.equals(autonomousVirtualMachines(), other.autonomousVirtualMachines());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAutonomousVirtualMachinesResponse").add("NextToken", nextToken())
                .add("AutonomousVirtualMachines", hasAutonomousVirtualMachines() ? autonomousVirtualMachines() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "autonomousVirtualMachines":
            return Optional.ofNullable(clazz.cast(autonomousVirtualMachines()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("autonomousVirtualMachines", AUTONOMOUS_VIRTUAL_MACHINES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutonomousVirtualMachinesResponse, T> g) {
        return obj -> g.apply((ListAutonomousVirtualMachinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAutonomousVirtualMachinesResponse> {
        /**
         * <p>
         * The pagination token from which to continue listing.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from which to continue listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of Autonomous VMs in the specified Autonomous VM cluster.
         * </p>
         * 
         * @param autonomousVirtualMachines
         *        The list of Autonomous VMs in the specified Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousVirtualMachines(Collection<AutonomousVirtualMachineSummary> autonomousVirtualMachines);

        /**
         * <p>
         * The list of Autonomous VMs in the specified Autonomous VM cluster.
         * </p>
         * 
         * @param autonomousVirtualMachines
         *        The list of Autonomous VMs in the specified Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousVirtualMachines(AutonomousVirtualMachineSummary... autonomousVirtualMachines);

        /**
         * <p>
         * The list of Autonomous VMs in the specified Autonomous VM cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.AutonomousVirtualMachineSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.odb.model.AutonomousVirtualMachineSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.AutonomousVirtualMachineSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #autonomousVirtualMachines(List<AutonomousVirtualMachineSummary>)}.
         * 
         * @param autonomousVirtualMachines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.AutonomousVirtualMachineSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autonomousVirtualMachines(java.util.Collection<AutonomousVirtualMachineSummary>)
         */
        Builder autonomousVirtualMachines(Consumer<AutonomousVirtualMachineSummary.Builder>... autonomousVirtualMachines);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AutonomousVirtualMachineSummary> autonomousVirtualMachines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutonomousVirtualMachinesResponse model) {
            super(model);
            nextToken(model.nextToken);
            autonomousVirtualMachines(model.autonomousVirtualMachines);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AutonomousVirtualMachineSummary.Builder> getAutonomousVirtualMachines() {
            List<AutonomousVirtualMachineSummary.Builder> result = AutonomousVirtualMachineListCopier
                    .copyToBuilder(this.autonomousVirtualMachines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutonomousVirtualMachines(
                Collection<AutonomousVirtualMachineSummary.BuilderImpl> autonomousVirtualMachines) {
            this.autonomousVirtualMachines = AutonomousVirtualMachineListCopier.copyFromBuilder(autonomousVirtualMachines);
        }

        @Override
        public final Builder autonomousVirtualMachines(Collection<AutonomousVirtualMachineSummary> autonomousVirtualMachines) {
            this.autonomousVirtualMachines = AutonomousVirtualMachineListCopier.copy(autonomousVirtualMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autonomousVirtualMachines(AutonomousVirtualMachineSummary... autonomousVirtualMachines) {
            autonomousVirtualMachines(Arrays.asList(autonomousVirtualMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autonomousVirtualMachines(
                Consumer<AutonomousVirtualMachineSummary.Builder>... autonomousVirtualMachines) {
            autonomousVirtualMachines(Stream.of(autonomousVirtualMachines)
                    .map(c -> AutonomousVirtualMachineSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAutonomousVirtualMachinesResponse build() {
            return new ListAutonomousVirtualMachinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
