/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOdbNetworkResponse extends OdbResponse implements
        ToCopyableBuilder<GetOdbNetworkResponse.Builder, GetOdbNetworkResponse> {
    private static final SdkField<OdbNetwork> ODB_NETWORK_FIELD = SdkField.<OdbNetwork> builder(MarshallingType.SDK_POJO)
            .memberName("odbNetwork").getter(getter(GetOdbNetworkResponse::odbNetwork)).setter(setter(Builder::odbNetwork))
            .constructor(OdbNetwork::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetwork").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OdbNetwork odbNetwork;

    private GetOdbNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.odbNetwork = builder.odbNetwork;
    }

    /**
     * <p>
     * The ODB network.
     * </p>
     * 
     * @return The ODB network.
     */
    public final OdbNetwork odbNetwork() {
        return odbNetwork;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(odbNetwork());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOdbNetworkResponse)) {
            return false;
        }
        GetOdbNetworkResponse other = (GetOdbNetworkResponse) obj;
        return Objects.equals(odbNetwork(), other.odbNetwork());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOdbNetworkResponse").add("OdbNetwork", odbNetwork()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "odbNetwork":
            return Optional.ofNullable(clazz.cast(odbNetwork()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("odbNetwork", ODB_NETWORK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOdbNetworkResponse, T> g) {
        return obj -> g.apply((GetOdbNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOdbNetworkResponse> {
        /**
         * <p>
         * The ODB network.
         * </p>
         * 
         * @param odbNetwork
         *        The ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetwork(OdbNetwork odbNetwork);

        /**
         * <p>
         * The ODB network.
         * </p>
         * This is a convenience method that creates an instance of the {@link OdbNetwork.Builder} avoiding the need to
         * create one manually via {@link OdbNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OdbNetwork.Builder#build()} is called immediately and its result
         * is passed to {@link #odbNetwork(OdbNetwork)}.
         * 
         * @param odbNetwork
         *        a consumer that will call methods on {@link OdbNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #odbNetwork(OdbNetwork)
         */
        default Builder odbNetwork(Consumer<OdbNetwork.Builder> odbNetwork) {
            return odbNetwork(OdbNetwork.builder().applyMutation(odbNetwork).build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private OdbNetwork odbNetwork;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOdbNetworkResponse model) {
            super(model);
            odbNetwork(model.odbNetwork);
        }

        public final OdbNetwork.Builder getOdbNetwork() {
            return odbNetwork != null ? odbNetwork.toBuilder() : null;
        }

        public final void setOdbNetwork(OdbNetwork.BuilderImpl odbNetwork) {
            this.odbNetwork = odbNetwork != null ? odbNetwork.build() : null;
        }

        @Override
        public final Builder odbNetwork(OdbNetwork odbNetwork) {
            this.odbNetwork = odbNetwork;
            return this;
        }

        @Override
        public GetOdbNetworkResponse build() {
            return new GetOdbNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
