/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOdbPeeringConnectionsResponse extends OdbResponse implements
        ToCopyableBuilder<ListOdbPeeringConnectionsResponse.Builder, ListOdbPeeringConnectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListOdbPeeringConnectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<OdbPeeringConnectionSummary>> ODB_PEERING_CONNECTIONS_FIELD = SdkField
            .<List<OdbPeeringConnectionSummary>> builder(MarshallingType.LIST)
            .memberName("odbPeeringConnections")
            .getter(getter(ListOdbPeeringConnectionsResponse::odbPeeringConnections))
            .setter(setter(Builder::odbPeeringConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OdbPeeringConnectionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OdbPeeringConnectionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ODB_PEERING_CONNECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<OdbPeeringConnectionSummary> odbPeeringConnections;

    private ListOdbPeeringConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.odbPeeringConnections = builder.odbPeeringConnections;
    }

    /**
     * <p>
     * The pagination token for the next page of ODB peering connections.
     * </p>
     * 
     * @return The pagination token for the next page of ODB peering connections.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OdbPeeringConnections property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOdbPeeringConnections() {
        return odbPeeringConnections != null && !(odbPeeringConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ODB peering connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOdbPeeringConnections} method.
     * </p>
     * 
     * @return The list of ODB peering connections.
     */
    public final List<OdbPeeringConnectionSummary> odbPeeringConnections() {
        return odbPeeringConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOdbPeeringConnections() ? odbPeeringConnections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOdbPeeringConnectionsResponse)) {
            return false;
        }
        ListOdbPeeringConnectionsResponse other = (ListOdbPeeringConnectionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasOdbPeeringConnections() == other.hasOdbPeeringConnections()
                && Objects.equals(odbPeeringConnections(), other.odbPeeringConnections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOdbPeeringConnectionsResponse").add("NextToken", nextToken())
                .add("OdbPeeringConnections", hasOdbPeeringConnections() ? odbPeeringConnections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "odbPeeringConnections":
            return Optional.ofNullable(clazz.cast(odbPeeringConnections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("odbPeeringConnections", ODB_PEERING_CONNECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOdbPeeringConnectionsResponse, T> g) {
        return obj -> g.apply((ListOdbPeeringConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOdbPeeringConnectionsResponse> {
        /**
         * <p>
         * The pagination token for the next page of ODB peering connections.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of ODB peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of ODB peering connections.
         * </p>
         * 
         * @param odbPeeringConnections
         *        The list of ODB peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbPeeringConnections(Collection<OdbPeeringConnectionSummary> odbPeeringConnections);

        /**
         * <p>
         * The list of ODB peering connections.
         * </p>
         * 
         * @param odbPeeringConnections
         *        The list of ODB peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbPeeringConnections(OdbPeeringConnectionSummary... odbPeeringConnections);

        /**
         * <p>
         * The list of ODB peering connections.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #odbPeeringConnections(List<OdbPeeringConnectionSummary>)}.
         * 
         * @param odbPeeringConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #odbPeeringConnections(java.util.Collection<OdbPeeringConnectionSummary>)
         */
        Builder odbPeeringConnections(Consumer<OdbPeeringConnectionSummary.Builder>... odbPeeringConnections);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OdbPeeringConnectionSummary> odbPeeringConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOdbPeeringConnectionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            odbPeeringConnections(model.odbPeeringConnections);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OdbPeeringConnectionSummary.Builder> getOdbPeeringConnections() {
            List<OdbPeeringConnectionSummary.Builder> result = OdbPeeringConnectionListCopier
                    .copyToBuilder(this.odbPeeringConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOdbPeeringConnections(Collection<OdbPeeringConnectionSummary.BuilderImpl> odbPeeringConnections) {
            this.odbPeeringConnections = OdbPeeringConnectionListCopier.copyFromBuilder(odbPeeringConnections);
        }

        @Override
        public final Builder odbPeeringConnections(Collection<OdbPeeringConnectionSummary> odbPeeringConnections) {
            this.odbPeeringConnections = OdbPeeringConnectionListCopier.copy(odbPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbPeeringConnections(OdbPeeringConnectionSummary... odbPeeringConnections) {
            odbPeeringConnections(Arrays.asList(odbPeeringConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbPeeringConnections(Consumer<OdbPeeringConnectionSummary.Builder>... odbPeeringConnections) {
            odbPeeringConnections(Stream.of(odbPeeringConnections)
                    .map(c -> OdbPeeringConnectionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOdbPeeringConnectionsResponse build() {
            return new ListOdbPeeringConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
