/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGiVersionsResponse extends OdbResponse implements
        ToCopyableBuilder<ListGiVersionsResponse.Builder, ListGiVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGiVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<GiVersionSummary>> GI_VERSIONS_FIELD = SdkField
            .<List<GiVersionSummary>> builder(MarshallingType.LIST)
            .memberName("giVersions")
            .getter(getter(ListGiVersionsResponse::giVersions))
            .setter(setter(Builder::giVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GiVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GiVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            GI_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<GiVersionSummary> giVersions;

    private ListGiVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.giVersions = builder.giVersions;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GiVersions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGiVersions() {
        return giVersions != null && !(giVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of GI versions and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGiVersions} method.
     * </p>
     * 
     * @return The list of GI versions and their properties.
     */
    public final List<GiVersionSummary> giVersions() {
        return giVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasGiVersions() ? giVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGiVersionsResponse)) {
            return false;
        }
        ListGiVersionsResponse other = (ListGiVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasGiVersions() == other.hasGiVersions()
                && Objects.equals(giVersions(), other.giVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGiVersionsResponse").add("NextToken", nextToken())
                .add("GiVersions", hasGiVersions() ? giVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "giVersions":
            return Optional.ofNullable(clazz.cast(giVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("giVersions", GI_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGiVersionsResponse, T> g) {
        return obj -> g.apply((ListGiVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGiVersionsResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of GI versions and their properties.
         * </p>
         * 
         * @param giVersions
         *        The list of GI versions and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder giVersions(Collection<GiVersionSummary> giVersions);

        /**
         * <p>
         * The list of GI versions and their properties.
         * </p>
         * 
         * @param giVersions
         *        The list of GI versions and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder giVersions(GiVersionSummary... giVersions);

        /**
         * <p>
         * The list of GI versions and their properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.GiVersionSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.odb.model.GiVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.GiVersionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #giVersions(List<GiVersionSummary>)}.
         * 
         * @param giVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.GiVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #giVersions(java.util.Collection<GiVersionSummary>)
         */
        Builder giVersions(Consumer<GiVersionSummary.Builder>... giVersions);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<GiVersionSummary> giVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGiVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            giVersions(model.giVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<GiVersionSummary.Builder> getGiVersions() {
            List<GiVersionSummary.Builder> result = GiVersionListCopier.copyToBuilder(this.giVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGiVersions(Collection<GiVersionSummary.BuilderImpl> giVersions) {
            this.giVersions = GiVersionListCopier.copyFromBuilder(giVersions);
        }

        @Override
        public final Builder giVersions(Collection<GiVersionSummary> giVersions) {
            this.giVersions = GiVersionListCopier.copy(giVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder giVersions(GiVersionSummary... giVersions) {
            giVersions(Arrays.asList(giVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder giVersions(Consumer<GiVersionSummary.Builder>... giVersions) {
            giVersions(Stream.of(giVersions).map(c -> GiVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGiVersionsResponse build() {
            return new ListGiVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
