/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCloudExadataInfrastructuresResponse extends OdbResponse implements
        ToCopyableBuilder<ListCloudExadataInfrastructuresResponse.Builder, ListCloudExadataInfrastructuresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCloudExadataInfrastructuresResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CloudExadataInfrastructureSummary>> CLOUD_EXADATA_INFRASTRUCTURES_FIELD = SdkField
            .<List<CloudExadataInfrastructureSummary>> builder(MarshallingType.LIST)
            .memberName("cloudExadataInfrastructures")
            .getter(getter(ListCloudExadataInfrastructuresResponse::cloudExadataInfrastructures))
            .setter(setter(Builder::cloudExadataInfrastructures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructures")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudExadataInfrastructureSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudExadataInfrastructureSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CLOUD_EXADATA_INFRASTRUCTURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CloudExadataInfrastructureSummary> cloudExadataInfrastructures;

    private ListCloudExadataInfrastructuresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cloudExadataInfrastructures = builder.cloudExadataInfrastructures;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudExadataInfrastructures property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudExadataInfrastructures() {
        return cloudExadataInfrastructures != null && !(cloudExadataInfrastructures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Exadata infrastructures along with their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudExadataInfrastructures} method.
     * </p>
     * 
     * @return The list of Exadata infrastructures along with their properties.
     */
    public final List<CloudExadataInfrastructureSummary> cloudExadataInfrastructures() {
        return cloudExadataInfrastructures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudExadataInfrastructures() ? cloudExadataInfrastructures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudExadataInfrastructuresResponse)) {
            return false;
        }
        ListCloudExadataInfrastructuresResponse other = (ListCloudExadataInfrastructuresResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasCloudExadataInfrastructures() == other.hasCloudExadataInfrastructures()
                && Objects.equals(cloudExadataInfrastructures(), other.cloudExadataInfrastructures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCloudExadataInfrastructuresResponse").add("NextToken", nextToken())
                .add("CloudExadataInfrastructures", hasCloudExadataInfrastructures() ? cloudExadataInfrastructures() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "cloudExadataInfrastructures":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("cloudExadataInfrastructures", CLOUD_EXADATA_INFRASTRUCTURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudExadataInfrastructuresResponse, T> g) {
        return obj -> g.apply((ListCloudExadataInfrastructuresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCloudExadataInfrastructuresResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of Exadata infrastructures along with their properties.
         * </p>
         * 
         * @param cloudExadataInfrastructures
         *        The list of Exadata infrastructures along with their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructures(Collection<CloudExadataInfrastructureSummary> cloudExadataInfrastructures);

        /**
         * <p>
         * The list of Exadata infrastructures along with their properties.
         * </p>
         * 
         * @param cloudExadataInfrastructures
         *        The list of Exadata infrastructures along with their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructures(CloudExadataInfrastructureSummary... cloudExadataInfrastructures);

        /**
         * <p>
         * The list of Exadata infrastructures along with their properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #cloudExadataInfrastructures(List<CloudExadataInfrastructureSummary>)}.
         * 
         * @param cloudExadataInfrastructures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudExadataInfrastructures(java.util.Collection<CloudExadataInfrastructureSummary>)
         */
        Builder cloudExadataInfrastructures(Consumer<CloudExadataInfrastructureSummary.Builder>... cloudExadataInfrastructures);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CloudExadataInfrastructureSummary> cloudExadataInfrastructures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudExadataInfrastructuresResponse model) {
            super(model);
            nextToken(model.nextToken);
            cloudExadataInfrastructures(model.cloudExadataInfrastructures);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CloudExadataInfrastructureSummary.Builder> getCloudExadataInfrastructures() {
            List<CloudExadataInfrastructureSummary.Builder> result = CloudExadataInfrastructureListCopier
                    .copyToBuilder(this.cloudExadataInfrastructures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudExadataInfrastructures(
                Collection<CloudExadataInfrastructureSummary.BuilderImpl> cloudExadataInfrastructures) {
            this.cloudExadataInfrastructures = CloudExadataInfrastructureListCopier.copyFromBuilder(cloudExadataInfrastructures);
        }

        @Override
        public final Builder cloudExadataInfrastructures(Collection<CloudExadataInfrastructureSummary> cloudExadataInfrastructures) {
            this.cloudExadataInfrastructures = CloudExadataInfrastructureListCopier.copy(cloudExadataInfrastructures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudExadataInfrastructures(CloudExadataInfrastructureSummary... cloudExadataInfrastructures) {
            cloudExadataInfrastructures(Arrays.asList(cloudExadataInfrastructures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudExadataInfrastructures(
                Consumer<CloudExadataInfrastructureSummary.Builder>... cloudExadataInfrastructures) {
            cloudExadataInfrastructures(Stream.of(cloudExadataInfrastructures)
                    .map(c -> CloudExadataInfrastructureSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCloudExadataInfrastructuresResponse build() {
            return new ListCloudExadataInfrastructuresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
