/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a hardware system model (shape) that's available for an Exadata infrastructure. The shape
 * determines resources, such as CPU cores, memory, and storage, to allocate to the Exadata infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DbSystemShapeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DbSystemShapeSummary.Builder, DbSystemShapeSummary> {
    private static final SdkField<Integer> AVAILABLE_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableCoreCount").getter(getter(DbSystemShapeSummary::availableCoreCount))
            .setter(setter(Builder::availableCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableCoreCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_CORE_COUNT_PER_NODE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("availableCoreCountPerNode")
            .getter(getter(DbSystemShapeSummary::availableCoreCountPerNode)).setter(setter(Builder::availableCoreCountPerNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableCoreCountPerNode").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_DATA_STORAGE_IN_T_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("availableDataStorageInTBs")
            .getter(getter(DbSystemShapeSummary::availableDataStorageInTBs)).setter(setter(Builder::availableDataStorageInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDataStorageInTBs").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_DATA_STORAGE_PER_SERVER_IN_T_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableDataStoragePerServerInTBs")
            .getter(getter(DbSystemShapeSummary::availableDataStoragePerServerInTBs))
            .setter(setter(Builder::availableDataStoragePerServerInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDataStoragePerServerInTBs")
                    .build()).build();

    private static final SdkField<Integer> AVAILABLE_DB_NODE_PER_NODE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableDbNodePerNodeInGBs")
            .getter(getter(DbSystemShapeSummary::availableDbNodePerNodeInGBs))
            .setter(setter(Builder::availableDbNodePerNodeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDbNodePerNodeInGBs")
                    .build()).build();

    private static final SdkField<Integer> AVAILABLE_DB_NODE_STORAGE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableDbNodeStorageInGBs")
            .getter(getter(DbSystemShapeSummary::availableDbNodeStorageInGBs))
            .setter(setter(Builder::availableDbNodeStorageInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDbNodeStorageInGBs")
                    .build()).build();

    private static final SdkField<Integer> AVAILABLE_MEMORY_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableMemoryInGBs").getter(getter(DbSystemShapeSummary::availableMemoryInGBs))
            .setter(setter(Builder::availableMemoryInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableMemoryInGBs").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_MEMORY_PER_NODE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableMemoryPerNodeInGBs")
            .getter(getter(DbSystemShapeSummary::availableMemoryPerNodeInGBs))
            .setter(setter(Builder::availableMemoryPerNodeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableMemoryPerNodeInGBs")
                    .build()).build();

    private static final SdkField<Integer> CORE_COUNT_INCREMENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("coreCountIncrement").getter(getter(DbSystemShapeSummary::coreCountIncrement))
            .setter(setter(Builder::coreCountIncrement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreCountIncrement").build())
            .build();

    private static final SdkField<Integer> MAX_STORAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxStorageCount").getter(getter(DbSystemShapeSummary::maxStorageCount))
            .setter(setter(Builder::maxStorageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxStorageCount").build()).build();

    private static final SdkField<Integer> MAXIMUM_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumNodeCount").getter(getter(DbSystemShapeSummary::maximumNodeCount))
            .setter(setter(Builder::maximumNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumNodeCount").build()).build();

    private static final SdkField<Integer> MIN_CORE_COUNT_PER_NODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minCoreCountPerNode").getter(getter(DbSystemShapeSummary::minCoreCountPerNode))
            .setter(setter(Builder::minCoreCountPerNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minCoreCountPerNode").build())
            .build();

    private static final SdkField<Integer> MIN_DATA_STORAGE_IN_T_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minDataStorageInTBs").getter(getter(DbSystemShapeSummary::minDataStorageInTBs))
            .setter(setter(Builder::minDataStorageInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minDataStorageInTBs").build())
            .build();

    private static final SdkField<Integer> MIN_DB_NODE_STORAGE_PER_NODE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("minDbNodeStoragePerNodeInGBs")
            .getter(getter(DbSystemShapeSummary::minDbNodeStoragePerNodeInGBs))
            .setter(setter(Builder::minDbNodeStoragePerNodeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minDbNodeStoragePerNodeInGBs")
                    .build()).build();

    private static final SdkField<Integer> MIN_MEMORY_PER_NODE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("minMemoryPerNodeInGBs")
            .getter(getter(DbSystemShapeSummary::minMemoryPerNodeInGBs)).setter(setter(Builder::minMemoryPerNodeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMemoryPerNodeInGBs").build())
            .build();

    private static final SdkField<Integer> MIN_STORAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minStorageCount").getter(getter(DbSystemShapeSummary::minStorageCount))
            .setter(setter(Builder::minStorageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minStorageCount").build()).build();

    private static final SdkField<Integer> MINIMUM_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumCoreCount").getter(getter(DbSystemShapeSummary::minimumCoreCount))
            .setter(setter(Builder::minimumCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCoreCount").build()).build();

    private static final SdkField<Integer> MINIMUM_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumNodeCount").getter(getter(DbSystemShapeSummary::minimumNodeCount))
            .setter(setter(Builder::minimumNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumNodeCount").build()).build();

    private static final SdkField<Integer> RUNTIME_MINIMUM_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("runtimeMinimumCoreCount").getter(getter(DbSystemShapeSummary::runtimeMinimumCoreCount))
            .setter(setter(Builder::runtimeMinimumCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeMinimumCoreCount").build())
            .build();

    private static final SdkField<String> SHAPE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shapeFamily").getter(getter(DbSystemShapeSummary::shapeFamily)).setter(setter(Builder::shapeFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shapeFamily").build()).build();

    private static final SdkField<String> SHAPE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shapeType").getter(getter(DbSystemShapeSummary::shapeTypeAsString)).setter(setter(Builder::shapeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shapeType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DbSystemShapeSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeModel").getter(getter(DbSystemShapeSummary::computeModelAsString))
            .setter(setter(Builder::computeModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()).build();

    private static final SdkField<Boolean> ARE_SERVER_TYPES_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("areServerTypesSupported").getter(getter(DbSystemShapeSummary::areServerTypesSupported))
            .setter(setter(Builder::areServerTypesSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areServerTypesSupported").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_CORE_COUNT_FIELD,
            AVAILABLE_CORE_COUNT_PER_NODE_FIELD, AVAILABLE_DATA_STORAGE_IN_T_BS_FIELD,
            AVAILABLE_DATA_STORAGE_PER_SERVER_IN_T_BS_FIELD, AVAILABLE_DB_NODE_PER_NODE_IN_G_BS_FIELD,
            AVAILABLE_DB_NODE_STORAGE_IN_G_BS_FIELD, AVAILABLE_MEMORY_IN_G_BS_FIELD, AVAILABLE_MEMORY_PER_NODE_IN_G_BS_FIELD,
            CORE_COUNT_INCREMENT_FIELD, MAX_STORAGE_COUNT_FIELD, MAXIMUM_NODE_COUNT_FIELD, MIN_CORE_COUNT_PER_NODE_FIELD,
            MIN_DATA_STORAGE_IN_T_BS_FIELD, MIN_DB_NODE_STORAGE_PER_NODE_IN_G_BS_FIELD, MIN_MEMORY_PER_NODE_IN_G_BS_FIELD,
            MIN_STORAGE_COUNT_FIELD, MINIMUM_CORE_COUNT_FIELD, MINIMUM_NODE_COUNT_FIELD, RUNTIME_MINIMUM_CORE_COUNT_FIELD,
            SHAPE_FAMILY_FIELD, SHAPE_TYPE_FIELD, NAME_FIELD, COMPUTE_MODEL_FIELD, ARE_SERVER_TYPES_SUPPORTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer availableCoreCount;

    private final Integer availableCoreCountPerNode;

    private final Integer availableDataStorageInTBs;

    private final Integer availableDataStoragePerServerInTBs;

    private final Integer availableDbNodePerNodeInGBs;

    private final Integer availableDbNodeStorageInGBs;

    private final Integer availableMemoryInGBs;

    private final Integer availableMemoryPerNodeInGBs;

    private final Integer coreCountIncrement;

    private final Integer maxStorageCount;

    private final Integer maximumNodeCount;

    private final Integer minCoreCountPerNode;

    private final Integer minDataStorageInTBs;

    private final Integer minDbNodeStoragePerNodeInGBs;

    private final Integer minMemoryPerNodeInGBs;

    private final Integer minStorageCount;

    private final Integer minimumCoreCount;

    private final Integer minimumNodeCount;

    private final Integer runtimeMinimumCoreCount;

    private final String shapeFamily;

    private final String shapeType;

    private final String name;

    private final String computeModel;

    private final Boolean areServerTypesSupported;

    private DbSystemShapeSummary(BuilderImpl builder) {
        this.availableCoreCount = builder.availableCoreCount;
        this.availableCoreCountPerNode = builder.availableCoreCountPerNode;
        this.availableDataStorageInTBs = builder.availableDataStorageInTBs;
        this.availableDataStoragePerServerInTBs = builder.availableDataStoragePerServerInTBs;
        this.availableDbNodePerNodeInGBs = builder.availableDbNodePerNodeInGBs;
        this.availableDbNodeStorageInGBs = builder.availableDbNodeStorageInGBs;
        this.availableMemoryInGBs = builder.availableMemoryInGBs;
        this.availableMemoryPerNodeInGBs = builder.availableMemoryPerNodeInGBs;
        this.coreCountIncrement = builder.coreCountIncrement;
        this.maxStorageCount = builder.maxStorageCount;
        this.maximumNodeCount = builder.maximumNodeCount;
        this.minCoreCountPerNode = builder.minCoreCountPerNode;
        this.minDataStorageInTBs = builder.minDataStorageInTBs;
        this.minDbNodeStoragePerNodeInGBs = builder.minDbNodeStoragePerNodeInGBs;
        this.minMemoryPerNodeInGBs = builder.minMemoryPerNodeInGBs;
        this.minStorageCount = builder.minStorageCount;
        this.minimumCoreCount = builder.minimumCoreCount;
        this.minimumNodeCount = builder.minimumNodeCount;
        this.runtimeMinimumCoreCount = builder.runtimeMinimumCoreCount;
        this.shapeFamily = builder.shapeFamily;
        this.shapeType = builder.shapeType;
        this.name = builder.name;
        this.computeModel = builder.computeModel;
        this.areServerTypesSupported = builder.areServerTypesSupported;
    }

    /**
     * <p>
     * The maximum number of CPU cores that can be enabled for the shape.
     * </p>
     * 
     * @return The maximum number of CPU cores that can be enabled for the shape.
     */
    public final Integer availableCoreCount() {
        return availableCoreCount;
    }

    /**
     * <p>
     * The maximum number of CPU cores per DB node that can be enabled for the shape.
     * </p>
     * 
     * @return The maximum number of CPU cores per DB node that can be enabled for the shape.
     */
    public final Integer availableCoreCountPerNode() {
        return availableCoreCountPerNode;
    }

    /**
     * <p>
     * The maximum amount of data storage, in terabytes (TB), that can be enabled for the shape.
     * </p>
     * 
     * @return The maximum amount of data storage, in terabytes (TB), that can be enabled for the shape.
     */
    public final Integer availableDataStorageInTBs() {
        return availableDataStorageInTBs;
    }

    /**
     * <p>
     * The maximum amount of data storage, in terabytes (TB), that's available per storage server for the shape.
     * </p>
     * 
     * @return The maximum amount of data storage, in terabytes (TB), that's available per storage server for the shape.
     */
    public final Integer availableDataStoragePerServerInTBs() {
        return availableDataStoragePerServerInTBs;
    }

    /**
     * <p>
     * The maximum amount of DB node storage, in gigabytes (GB), that's available per DB node for the shape.
     * </p>
     * 
     * @return The maximum amount of DB node storage, in gigabytes (GB), that's available per DB node for the shape.
     */
    public final Integer availableDbNodePerNodeInGBs() {
        return availableDbNodePerNodeInGBs;
    }

    /**
     * <p>
     * The maximum amount of DB node storage, in gigabytes (GB), that can be enabled for the shape.
     * </p>
     * 
     * @return The maximum amount of DB node storage, in gigabytes (GB), that can be enabled for the shape.
     */
    public final Integer availableDbNodeStorageInGBs() {
        return availableDbNodeStorageInGBs;
    }

    /**
     * <p>
     * The maximum amount of memory, in gigabytes (GB), that can be enabled for the shape.
     * </p>
     * 
     * @return The maximum amount of memory, in gigabytes (GB), that can be enabled for the shape.
     */
    public final Integer availableMemoryInGBs() {
        return availableMemoryInGBs;
    }

    /**
     * <p>
     * The maximum amount of memory, in gigabytes (GB), that's available per DB node for the shape.
     * </p>
     * 
     * @return The maximum amount of memory, in gigabytes (GB), that's available per DB node for the shape.
     */
    public final Integer availableMemoryPerNodeInGBs() {
        return availableMemoryPerNodeInGBs;
    }

    /**
     * <p>
     * The discrete number by which the CPU core count for the shape can be increased or decreased.
     * </p>
     * 
     * @return The discrete number by which the CPU core count for the shape can be increased or decreased.
     */
    public final Integer coreCountIncrement() {
        return coreCountIncrement;
    }

    /**
     * <p>
     * The maximum number of Exadata storage servers that's available for the shape.
     * </p>
     * 
     * @return The maximum number of Exadata storage servers that's available for the shape.
     */
    public final Integer maxStorageCount() {
        return maxStorageCount;
    }

    /**
     * <p>
     * The maximum number of compute servers that is available for the shape.
     * </p>
     * 
     * @return The maximum number of compute servers that is available for the shape.
     */
    public final Integer maximumNodeCount() {
        return maximumNodeCount;
    }

    /**
     * <p>
     * The minimum number of CPU cores that can be enabled per node for the shape.
     * </p>
     * 
     * @return The minimum number of CPU cores that can be enabled per node for the shape.
     */
    public final Integer minCoreCountPerNode() {
        return minCoreCountPerNode;
    }

    /**
     * <p>
     * The minimum amount of data storage, in terabytes (TB), that must be allocated for the shape.
     * </p>
     * 
     * @return The minimum amount of data storage, in terabytes (TB), that must be allocated for the shape.
     */
    public final Integer minDataStorageInTBs() {
        return minDataStorageInTBs;
    }

    /**
     * <p>
     * The minimum amount of DB node storage, in gigabytes (GB), that must be allocated per DB node for the shape.
     * </p>
     * 
     * @return The minimum amount of DB node storage, in gigabytes (GB), that must be allocated per DB node for the
     *         shape.
     */
    public final Integer minDbNodeStoragePerNodeInGBs() {
        return minDbNodeStoragePerNodeInGBs;
    }

    /**
     * <p>
     * The minimum amount of memory, in gigabytes (GB), that must be allocated per DB node for the shape.
     * </p>
     * 
     * @return The minimum amount of memory, in gigabytes (GB), that must be allocated per DB node for the shape.
     */
    public final Integer minMemoryPerNodeInGBs() {
        return minMemoryPerNodeInGBs;
    }

    /**
     * <p>
     * The minimum number of Exadata storage servers that are available for the shape.
     * </p>
     * 
     * @return The minimum number of Exadata storage servers that are available for the shape.
     */
    public final Integer minStorageCount() {
        return minStorageCount;
    }

    /**
     * <p>
     * The minimum number of CPU cores that can be enabled for the shape.
     * </p>
     * 
     * @return The minimum number of CPU cores that can be enabled for the shape.
     */
    public final Integer minimumCoreCount() {
        return minimumCoreCount;
    }

    /**
     * <p>
     * The minimum number of compute servers that are available for the shape.
     * </p>
     * 
     * @return The minimum number of compute servers that are available for the shape.
     */
    public final Integer minimumNodeCount() {
        return minimumNodeCount;
    }

    /**
     * <p>
     * The runtime minimum number of CPU cores that can be enabled for the shape.
     * </p>
     * 
     * @return The runtime minimum number of CPU cores that can be enabled for the shape.
     */
    public final Integer runtimeMinimumCoreCount() {
        return runtimeMinimumCoreCount;
    }

    /**
     * <p>
     * The family of the shape.
     * </p>
     * 
     * @return The family of the shape.
     */
    public final String shapeFamily() {
        return shapeFamily;
    }

    /**
     * <p>
     * The shape type. This property is determined by the CPU hardware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shapeType} will
     * return {@link ShapeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeTypeAsString}.
     * </p>
     * 
     * @return The shape type. This property is determined by the CPU hardware.
     * @see ShapeType
     */
    public final ShapeType shapeType() {
        return ShapeType.fromValue(shapeType);
    }

    /**
     * <p>
     * The shape type. This property is determined by the CPU hardware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shapeType} will
     * return {@link ShapeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeTypeAsString}.
     * </p>
     * 
     * @return The shape type. This property is determined by the CPU hardware.
     * @see ShapeType
     */
    public final String shapeTypeAsString() {
        return shapeType;
    }

    /**
     * <p>
     * The name of the shape.
     * </p>
     * 
     * @return The name of the shape.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
     * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute
     * and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical
     * core of a processor with hyper-threading enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
     *         abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
     *         from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
     *         OCPUs are based on the physical core of a processor with hyper-threading enabled.
     * @see ComputeModel
     */
    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(computeModel);
    }

    /**
     * <p>
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
     * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute
     * and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical
     * core of a processor with hyper-threading enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
     *         abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
     *         from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
     *         OCPUs are based on the physical core of a processor with hyper-threading enabled.
     * @see ComputeModel
     */
    public final String computeModelAsString() {
        return computeModel;
    }

    /**
     * <p>
     * Indicates whether the hardware system model supports configurable database and server storage types.
     * </p>
     * 
     * @return Indicates whether the hardware system model supports configurable database and server storage types.
     */
    public final Boolean areServerTypesSupported() {
        return areServerTypesSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availableCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(availableDataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableDataStoragePerServerInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableDbNodePerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableDbNodeStorageInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableMemoryInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableMemoryPerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(coreCountIncrement());
        hashCode = 31 * hashCode + Objects.hashCode(maxStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(minCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(minDataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(minDbNodeStoragePerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(minMemoryPerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(minStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(minimumCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeMinimumCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(shapeFamily());
        hashCode = 31 * hashCode + Objects.hashCode(shapeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(computeModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(areServerTypesSupported());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbSystemShapeSummary)) {
            return false;
        }
        DbSystemShapeSummary other = (DbSystemShapeSummary) obj;
        return Objects.equals(availableCoreCount(), other.availableCoreCount())
                && Objects.equals(availableCoreCountPerNode(), other.availableCoreCountPerNode())
                && Objects.equals(availableDataStorageInTBs(), other.availableDataStorageInTBs())
                && Objects.equals(availableDataStoragePerServerInTBs(), other.availableDataStoragePerServerInTBs())
                && Objects.equals(availableDbNodePerNodeInGBs(), other.availableDbNodePerNodeInGBs())
                && Objects.equals(availableDbNodeStorageInGBs(), other.availableDbNodeStorageInGBs())
                && Objects.equals(availableMemoryInGBs(), other.availableMemoryInGBs())
                && Objects.equals(availableMemoryPerNodeInGBs(), other.availableMemoryPerNodeInGBs())
                && Objects.equals(coreCountIncrement(), other.coreCountIncrement())
                && Objects.equals(maxStorageCount(), other.maxStorageCount())
                && Objects.equals(maximumNodeCount(), other.maximumNodeCount())
                && Objects.equals(minCoreCountPerNode(), other.minCoreCountPerNode())
                && Objects.equals(minDataStorageInTBs(), other.minDataStorageInTBs())
                && Objects.equals(minDbNodeStoragePerNodeInGBs(), other.minDbNodeStoragePerNodeInGBs())
                && Objects.equals(minMemoryPerNodeInGBs(), other.minMemoryPerNodeInGBs())
                && Objects.equals(minStorageCount(), other.minStorageCount())
                && Objects.equals(minimumCoreCount(), other.minimumCoreCount())
                && Objects.equals(minimumNodeCount(), other.minimumNodeCount())
                && Objects.equals(runtimeMinimumCoreCount(), other.runtimeMinimumCoreCount())
                && Objects.equals(shapeFamily(), other.shapeFamily())
                && Objects.equals(shapeTypeAsString(), other.shapeTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(computeModelAsString(), other.computeModelAsString())
                && Objects.equals(areServerTypesSupported(), other.areServerTypesSupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DbSystemShapeSummary").add("AvailableCoreCount", availableCoreCount())
                .add("AvailableCoreCountPerNode", availableCoreCountPerNode())
                .add("AvailableDataStorageInTBs", availableDataStorageInTBs())
                .add("AvailableDataStoragePerServerInTBs", availableDataStoragePerServerInTBs())
                .add("AvailableDbNodePerNodeInGBs", availableDbNodePerNodeInGBs())
                .add("AvailableDbNodeStorageInGBs", availableDbNodeStorageInGBs())
                .add("AvailableMemoryInGBs", availableMemoryInGBs())
                .add("AvailableMemoryPerNodeInGBs", availableMemoryPerNodeInGBs())
                .add("CoreCountIncrement", coreCountIncrement()).add("MaxStorageCount", maxStorageCount())
                .add("MaximumNodeCount", maximumNodeCount()).add("MinCoreCountPerNode", minCoreCountPerNode())
                .add("MinDataStorageInTBs", minDataStorageInTBs())
                .add("MinDbNodeStoragePerNodeInGBs", minDbNodeStoragePerNodeInGBs())
                .add("MinMemoryPerNodeInGBs", minMemoryPerNodeInGBs()).add("MinStorageCount", minStorageCount())
                .add("MinimumCoreCount", minimumCoreCount()).add("MinimumNodeCount", minimumNodeCount())
                .add("RuntimeMinimumCoreCount", runtimeMinimumCoreCount()).add("ShapeFamily", shapeFamily())
                .add("ShapeType", shapeTypeAsString()).add("Name", name()).add("ComputeModel", computeModelAsString())
                .add("AreServerTypesSupported", areServerTypesSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availableCoreCount":
            return Optional.ofNullable(clazz.cast(availableCoreCount()));
        case "availableCoreCountPerNode":
            return Optional.ofNullable(clazz.cast(availableCoreCountPerNode()));
        case "availableDataStorageInTBs":
            return Optional.ofNullable(clazz.cast(availableDataStorageInTBs()));
        case "availableDataStoragePerServerInTBs":
            return Optional.ofNullable(clazz.cast(availableDataStoragePerServerInTBs()));
        case "availableDbNodePerNodeInGBs":
            return Optional.ofNullable(clazz.cast(availableDbNodePerNodeInGBs()));
        case "availableDbNodeStorageInGBs":
            return Optional.ofNullable(clazz.cast(availableDbNodeStorageInGBs()));
        case "availableMemoryInGBs":
            return Optional.ofNullable(clazz.cast(availableMemoryInGBs()));
        case "availableMemoryPerNodeInGBs":
            return Optional.ofNullable(clazz.cast(availableMemoryPerNodeInGBs()));
        case "coreCountIncrement":
            return Optional.ofNullable(clazz.cast(coreCountIncrement()));
        case "maxStorageCount":
            return Optional.ofNullable(clazz.cast(maxStorageCount()));
        case "maximumNodeCount":
            return Optional.ofNullable(clazz.cast(maximumNodeCount()));
        case "minCoreCountPerNode":
            return Optional.ofNullable(clazz.cast(minCoreCountPerNode()));
        case "minDataStorageInTBs":
            return Optional.ofNullable(clazz.cast(minDataStorageInTBs()));
        case "minDbNodeStoragePerNodeInGBs":
            return Optional.ofNullable(clazz.cast(minDbNodeStoragePerNodeInGBs()));
        case "minMemoryPerNodeInGBs":
            return Optional.ofNullable(clazz.cast(minMemoryPerNodeInGBs()));
        case "minStorageCount":
            return Optional.ofNullable(clazz.cast(minStorageCount()));
        case "minimumCoreCount":
            return Optional.ofNullable(clazz.cast(minimumCoreCount()));
        case "minimumNodeCount":
            return Optional.ofNullable(clazz.cast(minimumNodeCount()));
        case "runtimeMinimumCoreCount":
            return Optional.ofNullable(clazz.cast(runtimeMinimumCoreCount()));
        case "shapeFamily":
            return Optional.ofNullable(clazz.cast(shapeFamily()));
        case "shapeType":
            return Optional.ofNullable(clazz.cast(shapeTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "computeModel":
            return Optional.ofNullable(clazz.cast(computeModelAsString()));
        case "areServerTypesSupported":
            return Optional.ofNullable(clazz.cast(areServerTypesSupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availableCoreCount", AVAILABLE_CORE_COUNT_FIELD);
        map.put("availableCoreCountPerNode", AVAILABLE_CORE_COUNT_PER_NODE_FIELD);
        map.put("availableDataStorageInTBs", AVAILABLE_DATA_STORAGE_IN_T_BS_FIELD);
        map.put("availableDataStoragePerServerInTBs", AVAILABLE_DATA_STORAGE_PER_SERVER_IN_T_BS_FIELD);
        map.put("availableDbNodePerNodeInGBs", AVAILABLE_DB_NODE_PER_NODE_IN_G_BS_FIELD);
        map.put("availableDbNodeStorageInGBs", AVAILABLE_DB_NODE_STORAGE_IN_G_BS_FIELD);
        map.put("availableMemoryInGBs", AVAILABLE_MEMORY_IN_G_BS_FIELD);
        map.put("availableMemoryPerNodeInGBs", AVAILABLE_MEMORY_PER_NODE_IN_G_BS_FIELD);
        map.put("coreCountIncrement", CORE_COUNT_INCREMENT_FIELD);
        map.put("maxStorageCount", MAX_STORAGE_COUNT_FIELD);
        map.put("maximumNodeCount", MAXIMUM_NODE_COUNT_FIELD);
        map.put("minCoreCountPerNode", MIN_CORE_COUNT_PER_NODE_FIELD);
        map.put("minDataStorageInTBs", MIN_DATA_STORAGE_IN_T_BS_FIELD);
        map.put("minDbNodeStoragePerNodeInGBs", MIN_DB_NODE_STORAGE_PER_NODE_IN_G_BS_FIELD);
        map.put("minMemoryPerNodeInGBs", MIN_MEMORY_PER_NODE_IN_G_BS_FIELD);
        map.put("minStorageCount", MIN_STORAGE_COUNT_FIELD);
        map.put("minimumCoreCount", MINIMUM_CORE_COUNT_FIELD);
        map.put("minimumNodeCount", MINIMUM_NODE_COUNT_FIELD);
        map.put("runtimeMinimumCoreCount", RUNTIME_MINIMUM_CORE_COUNT_FIELD);
        map.put("shapeFamily", SHAPE_FAMILY_FIELD);
        map.put("shapeType", SHAPE_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        map.put("areServerTypesSupported", ARE_SERVER_TYPES_SUPPORTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbSystemShapeSummary, T> g) {
        return obj -> g.apply((DbSystemShapeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DbSystemShapeSummary> {
        /**
         * <p>
         * The maximum number of CPU cores that can be enabled for the shape.
         * </p>
         * 
         * @param availableCoreCount
         *        The maximum number of CPU cores that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCoreCount(Integer availableCoreCount);

        /**
         * <p>
         * The maximum number of CPU cores per DB node that can be enabled for the shape.
         * </p>
         * 
         * @param availableCoreCountPerNode
         *        The maximum number of CPU cores per DB node that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCoreCountPerNode(Integer availableCoreCountPerNode);

        /**
         * <p>
         * The maximum amount of data storage, in terabytes (TB), that can be enabled for the shape.
         * </p>
         * 
         * @param availableDataStorageInTBs
         *        The maximum amount of data storage, in terabytes (TB), that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableDataStorageInTBs(Integer availableDataStorageInTBs);

        /**
         * <p>
         * The maximum amount of data storage, in terabytes (TB), that's available per storage server for the shape.
         * </p>
         * 
         * @param availableDataStoragePerServerInTBs
         *        The maximum amount of data storage, in terabytes (TB), that's available per storage server for the
         *        shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableDataStoragePerServerInTBs(Integer availableDataStoragePerServerInTBs);

        /**
         * <p>
         * The maximum amount of DB node storage, in gigabytes (GB), that's available per DB node for the shape.
         * </p>
         * 
         * @param availableDbNodePerNodeInGBs
         *        The maximum amount of DB node storage, in gigabytes (GB), that's available per DB node for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableDbNodePerNodeInGBs(Integer availableDbNodePerNodeInGBs);

        /**
         * <p>
         * The maximum amount of DB node storage, in gigabytes (GB), that can be enabled for the shape.
         * </p>
         * 
         * @param availableDbNodeStorageInGBs
         *        The maximum amount of DB node storage, in gigabytes (GB), that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableDbNodeStorageInGBs(Integer availableDbNodeStorageInGBs);

        /**
         * <p>
         * The maximum amount of memory, in gigabytes (GB), that can be enabled for the shape.
         * </p>
         * 
         * @param availableMemoryInGBs
         *        The maximum amount of memory, in gigabytes (GB), that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableMemoryInGBs(Integer availableMemoryInGBs);

        /**
         * <p>
         * The maximum amount of memory, in gigabytes (GB), that's available per DB node for the shape.
         * </p>
         * 
         * @param availableMemoryPerNodeInGBs
         *        The maximum amount of memory, in gigabytes (GB), that's available per DB node for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableMemoryPerNodeInGBs(Integer availableMemoryPerNodeInGBs);

        /**
         * <p>
         * The discrete number by which the CPU core count for the shape can be increased or decreased.
         * </p>
         * 
         * @param coreCountIncrement
         *        The discrete number by which the CPU core count for the shape can be increased or decreased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreCountIncrement(Integer coreCountIncrement);

        /**
         * <p>
         * The maximum number of Exadata storage servers that's available for the shape.
         * </p>
         * 
         * @param maxStorageCount
         *        The maximum number of Exadata storage servers that's available for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxStorageCount(Integer maxStorageCount);

        /**
         * <p>
         * The maximum number of compute servers that is available for the shape.
         * </p>
         * 
         * @param maximumNodeCount
         *        The maximum number of compute servers that is available for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNodeCount(Integer maximumNodeCount);

        /**
         * <p>
         * The minimum number of CPU cores that can be enabled per node for the shape.
         * </p>
         * 
         * @param minCoreCountPerNode
         *        The minimum number of CPU cores that can be enabled per node for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCoreCountPerNode(Integer minCoreCountPerNode);

        /**
         * <p>
         * The minimum amount of data storage, in terabytes (TB), that must be allocated for the shape.
         * </p>
         * 
         * @param minDataStorageInTBs
         *        The minimum amount of data storage, in terabytes (TB), that must be allocated for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDataStorageInTBs(Integer minDataStorageInTBs);

        /**
         * <p>
         * The minimum amount of DB node storage, in gigabytes (GB), that must be allocated per DB node for the shape.
         * </p>
         * 
         * @param minDbNodeStoragePerNodeInGBs
         *        The minimum amount of DB node storage, in gigabytes (GB), that must be allocated per DB node for the
         *        shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDbNodeStoragePerNodeInGBs(Integer minDbNodeStoragePerNodeInGBs);

        /**
         * <p>
         * The minimum amount of memory, in gigabytes (GB), that must be allocated per DB node for the shape.
         * </p>
         * 
         * @param minMemoryPerNodeInGBs
         *        The minimum amount of memory, in gigabytes (GB), that must be allocated per DB node for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMemoryPerNodeInGBs(Integer minMemoryPerNodeInGBs);

        /**
         * <p>
         * The minimum number of Exadata storage servers that are available for the shape.
         * </p>
         * 
         * @param minStorageCount
         *        The minimum number of Exadata storage servers that are available for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minStorageCount(Integer minStorageCount);

        /**
         * <p>
         * The minimum number of CPU cores that can be enabled for the shape.
         * </p>
         * 
         * @param minimumCoreCount
         *        The minimum number of CPU cores that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCoreCount(Integer minimumCoreCount);

        /**
         * <p>
         * The minimum number of compute servers that are available for the shape.
         * </p>
         * 
         * @param minimumNodeCount
         *        The minimum number of compute servers that are available for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNodeCount(Integer minimumNodeCount);

        /**
         * <p>
         * The runtime minimum number of CPU cores that can be enabled for the shape.
         * </p>
         * 
         * @param runtimeMinimumCoreCount
         *        The runtime minimum number of CPU cores that can be enabled for the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeMinimumCoreCount(Integer runtimeMinimumCoreCount);

        /**
         * <p>
         * The family of the shape.
         * </p>
         * 
         * @param shapeFamily
         *        The family of the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shapeFamily(String shapeFamily);

        /**
         * <p>
         * The shape type. This property is determined by the CPU hardware.
         * </p>
         * 
         * @param shapeType
         *        The shape type. This property is determined by the CPU hardware.
         * @see ShapeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShapeType
         */
        Builder shapeType(String shapeType);

        /**
         * <p>
         * The shape type. This property is determined by the CPU hardware.
         * </p>
         * 
         * @param shapeType
         *        The shape type. This property is determined by the CPU hardware.
         * @see ShapeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShapeType
         */
        Builder shapeType(ShapeType shapeType);

        /**
         * <p>
         * The name of the shape.
         * </p>
         * 
         * @param name
         *        The name of the shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
         * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of
         * compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on
         * the physical core of a processor with hyper-threading enabled.
         * </p>
         * 
         * @param computeModel
         *        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
         *        abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
         *        from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
         *        OCPUs are based on the physical core of a processor with hyper-threading enabled.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(String computeModel);

        /**
         * <p>
         * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
         * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of
         * compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on
         * the physical core of a processor with hyper-threading enabled.
         * </p>
         * 
         * @param computeModel
         *        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
         *        abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
         *        from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
         *        OCPUs are based on the physical core of a processor with hyper-threading enabled.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(ComputeModel computeModel);

        /**
         * <p>
         * Indicates whether the hardware system model supports configurable database and server storage types.
         * </p>
         * 
         * @param areServerTypesSupported
         *        Indicates whether the hardware system model supports configurable database and server storage types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areServerTypesSupported(Boolean areServerTypesSupported);
    }

    static final class BuilderImpl implements Builder {
        private Integer availableCoreCount;

        private Integer availableCoreCountPerNode;

        private Integer availableDataStorageInTBs;

        private Integer availableDataStoragePerServerInTBs;

        private Integer availableDbNodePerNodeInGBs;

        private Integer availableDbNodeStorageInGBs;

        private Integer availableMemoryInGBs;

        private Integer availableMemoryPerNodeInGBs;

        private Integer coreCountIncrement;

        private Integer maxStorageCount;

        private Integer maximumNodeCount;

        private Integer minCoreCountPerNode;

        private Integer minDataStorageInTBs;

        private Integer minDbNodeStoragePerNodeInGBs;

        private Integer minMemoryPerNodeInGBs;

        private Integer minStorageCount;

        private Integer minimumCoreCount;

        private Integer minimumNodeCount;

        private Integer runtimeMinimumCoreCount;

        private String shapeFamily;

        private String shapeType;

        private String name;

        private String computeModel;

        private Boolean areServerTypesSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(DbSystemShapeSummary model) {
            availableCoreCount(model.availableCoreCount);
            availableCoreCountPerNode(model.availableCoreCountPerNode);
            availableDataStorageInTBs(model.availableDataStorageInTBs);
            availableDataStoragePerServerInTBs(model.availableDataStoragePerServerInTBs);
            availableDbNodePerNodeInGBs(model.availableDbNodePerNodeInGBs);
            availableDbNodeStorageInGBs(model.availableDbNodeStorageInGBs);
            availableMemoryInGBs(model.availableMemoryInGBs);
            availableMemoryPerNodeInGBs(model.availableMemoryPerNodeInGBs);
            coreCountIncrement(model.coreCountIncrement);
            maxStorageCount(model.maxStorageCount);
            maximumNodeCount(model.maximumNodeCount);
            minCoreCountPerNode(model.minCoreCountPerNode);
            minDataStorageInTBs(model.minDataStorageInTBs);
            minDbNodeStoragePerNodeInGBs(model.minDbNodeStoragePerNodeInGBs);
            minMemoryPerNodeInGBs(model.minMemoryPerNodeInGBs);
            minStorageCount(model.minStorageCount);
            minimumCoreCount(model.minimumCoreCount);
            minimumNodeCount(model.minimumNodeCount);
            runtimeMinimumCoreCount(model.runtimeMinimumCoreCount);
            shapeFamily(model.shapeFamily);
            shapeType(model.shapeType);
            name(model.name);
            computeModel(model.computeModel);
            areServerTypesSupported(model.areServerTypesSupported);
        }

        public final Integer getAvailableCoreCount() {
            return availableCoreCount;
        }

        public final void setAvailableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
        }

        @Override
        public final Builder availableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
            return this;
        }

        public final Integer getAvailableCoreCountPerNode() {
            return availableCoreCountPerNode;
        }

        public final void setAvailableCoreCountPerNode(Integer availableCoreCountPerNode) {
            this.availableCoreCountPerNode = availableCoreCountPerNode;
        }

        @Override
        public final Builder availableCoreCountPerNode(Integer availableCoreCountPerNode) {
            this.availableCoreCountPerNode = availableCoreCountPerNode;
            return this;
        }

        public final Integer getAvailableDataStorageInTBs() {
            return availableDataStorageInTBs;
        }

        public final void setAvailableDataStorageInTBs(Integer availableDataStorageInTBs) {
            this.availableDataStorageInTBs = availableDataStorageInTBs;
        }

        @Override
        public final Builder availableDataStorageInTBs(Integer availableDataStorageInTBs) {
            this.availableDataStorageInTBs = availableDataStorageInTBs;
            return this;
        }

        public final Integer getAvailableDataStoragePerServerInTBs() {
            return availableDataStoragePerServerInTBs;
        }

        public final void setAvailableDataStoragePerServerInTBs(Integer availableDataStoragePerServerInTBs) {
            this.availableDataStoragePerServerInTBs = availableDataStoragePerServerInTBs;
        }

        @Override
        public final Builder availableDataStoragePerServerInTBs(Integer availableDataStoragePerServerInTBs) {
            this.availableDataStoragePerServerInTBs = availableDataStoragePerServerInTBs;
            return this;
        }

        public final Integer getAvailableDbNodePerNodeInGBs() {
            return availableDbNodePerNodeInGBs;
        }

        public final void setAvailableDbNodePerNodeInGBs(Integer availableDbNodePerNodeInGBs) {
            this.availableDbNodePerNodeInGBs = availableDbNodePerNodeInGBs;
        }

        @Override
        public final Builder availableDbNodePerNodeInGBs(Integer availableDbNodePerNodeInGBs) {
            this.availableDbNodePerNodeInGBs = availableDbNodePerNodeInGBs;
            return this;
        }

        public final Integer getAvailableDbNodeStorageInGBs() {
            return availableDbNodeStorageInGBs;
        }

        public final void setAvailableDbNodeStorageInGBs(Integer availableDbNodeStorageInGBs) {
            this.availableDbNodeStorageInGBs = availableDbNodeStorageInGBs;
        }

        @Override
        public final Builder availableDbNodeStorageInGBs(Integer availableDbNodeStorageInGBs) {
            this.availableDbNodeStorageInGBs = availableDbNodeStorageInGBs;
            return this;
        }

        public final Integer getAvailableMemoryInGBs() {
            return availableMemoryInGBs;
        }

        public final void setAvailableMemoryInGBs(Integer availableMemoryInGBs) {
            this.availableMemoryInGBs = availableMemoryInGBs;
        }

        @Override
        public final Builder availableMemoryInGBs(Integer availableMemoryInGBs) {
            this.availableMemoryInGBs = availableMemoryInGBs;
            return this;
        }

        public final Integer getAvailableMemoryPerNodeInGBs() {
            return availableMemoryPerNodeInGBs;
        }

        public final void setAvailableMemoryPerNodeInGBs(Integer availableMemoryPerNodeInGBs) {
            this.availableMemoryPerNodeInGBs = availableMemoryPerNodeInGBs;
        }

        @Override
        public final Builder availableMemoryPerNodeInGBs(Integer availableMemoryPerNodeInGBs) {
            this.availableMemoryPerNodeInGBs = availableMemoryPerNodeInGBs;
            return this;
        }

        public final Integer getCoreCountIncrement() {
            return coreCountIncrement;
        }

        public final void setCoreCountIncrement(Integer coreCountIncrement) {
            this.coreCountIncrement = coreCountIncrement;
        }

        @Override
        public final Builder coreCountIncrement(Integer coreCountIncrement) {
            this.coreCountIncrement = coreCountIncrement;
            return this;
        }

        public final Integer getMaxStorageCount() {
            return maxStorageCount;
        }

        public final void setMaxStorageCount(Integer maxStorageCount) {
            this.maxStorageCount = maxStorageCount;
        }

        @Override
        public final Builder maxStorageCount(Integer maxStorageCount) {
            this.maxStorageCount = maxStorageCount;
            return this;
        }

        public final Integer getMaximumNodeCount() {
            return maximumNodeCount;
        }

        public final void setMaximumNodeCount(Integer maximumNodeCount) {
            this.maximumNodeCount = maximumNodeCount;
        }

        @Override
        public final Builder maximumNodeCount(Integer maximumNodeCount) {
            this.maximumNodeCount = maximumNodeCount;
            return this;
        }

        public final Integer getMinCoreCountPerNode() {
            return minCoreCountPerNode;
        }

        public final void setMinCoreCountPerNode(Integer minCoreCountPerNode) {
            this.minCoreCountPerNode = minCoreCountPerNode;
        }

        @Override
        public final Builder minCoreCountPerNode(Integer minCoreCountPerNode) {
            this.minCoreCountPerNode = minCoreCountPerNode;
            return this;
        }

        public final Integer getMinDataStorageInTBs() {
            return minDataStorageInTBs;
        }

        public final void setMinDataStorageInTBs(Integer minDataStorageInTBs) {
            this.minDataStorageInTBs = minDataStorageInTBs;
        }

        @Override
        public final Builder minDataStorageInTBs(Integer minDataStorageInTBs) {
            this.minDataStorageInTBs = minDataStorageInTBs;
            return this;
        }

        public final Integer getMinDbNodeStoragePerNodeInGBs() {
            return minDbNodeStoragePerNodeInGBs;
        }

        public final void setMinDbNodeStoragePerNodeInGBs(Integer minDbNodeStoragePerNodeInGBs) {
            this.minDbNodeStoragePerNodeInGBs = minDbNodeStoragePerNodeInGBs;
        }

        @Override
        public final Builder minDbNodeStoragePerNodeInGBs(Integer minDbNodeStoragePerNodeInGBs) {
            this.minDbNodeStoragePerNodeInGBs = minDbNodeStoragePerNodeInGBs;
            return this;
        }

        public final Integer getMinMemoryPerNodeInGBs() {
            return minMemoryPerNodeInGBs;
        }

        public final void setMinMemoryPerNodeInGBs(Integer minMemoryPerNodeInGBs) {
            this.minMemoryPerNodeInGBs = minMemoryPerNodeInGBs;
        }

        @Override
        public final Builder minMemoryPerNodeInGBs(Integer minMemoryPerNodeInGBs) {
            this.minMemoryPerNodeInGBs = minMemoryPerNodeInGBs;
            return this;
        }

        public final Integer getMinStorageCount() {
            return minStorageCount;
        }

        public final void setMinStorageCount(Integer minStorageCount) {
            this.minStorageCount = minStorageCount;
        }

        @Override
        public final Builder minStorageCount(Integer minStorageCount) {
            this.minStorageCount = minStorageCount;
            return this;
        }

        public final Integer getMinimumCoreCount() {
            return minimumCoreCount;
        }

        public final void setMinimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
        }

        @Override
        public final Builder minimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
            return this;
        }

        public final Integer getMinimumNodeCount() {
            return minimumNodeCount;
        }

        public final void setMinimumNodeCount(Integer minimumNodeCount) {
            this.minimumNodeCount = minimumNodeCount;
        }

        @Override
        public final Builder minimumNodeCount(Integer minimumNodeCount) {
            this.minimumNodeCount = minimumNodeCount;
            return this;
        }

        public final Integer getRuntimeMinimumCoreCount() {
            return runtimeMinimumCoreCount;
        }

        public final void setRuntimeMinimumCoreCount(Integer runtimeMinimumCoreCount) {
            this.runtimeMinimumCoreCount = runtimeMinimumCoreCount;
        }

        @Override
        public final Builder runtimeMinimumCoreCount(Integer runtimeMinimumCoreCount) {
            this.runtimeMinimumCoreCount = runtimeMinimumCoreCount;
            return this;
        }

        public final String getShapeFamily() {
            return shapeFamily;
        }

        public final void setShapeFamily(String shapeFamily) {
            this.shapeFamily = shapeFamily;
        }

        @Override
        public final Builder shapeFamily(String shapeFamily) {
            this.shapeFamily = shapeFamily;
            return this;
        }

        public final String getShapeType() {
            return shapeType;
        }

        public final void setShapeType(String shapeType) {
            this.shapeType = shapeType;
        }

        @Override
        public final Builder shapeType(String shapeType) {
            this.shapeType = shapeType;
            return this;
        }

        @Override
        public final Builder shapeType(ShapeType shapeType) {
            this.shapeType(shapeType == null ? null : shapeType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getComputeModel() {
            return computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public final Boolean getAreServerTypesSupported() {
            return areServerTypesSupported;
        }

        public final void setAreServerTypesSupported(Boolean areServerTypesSupported) {
            this.areServerTypesSupported = areServerTypesSupported;
        }

        @Override
        public final Builder areServerTypesSupported(Boolean areServerTypesSupported) {
            this.areServerTypesSupported = areServerTypesSupported;
            return this;
        }

        @Override
        public DbSystemShapeSummary build() {
            return new DbSystemShapeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
