/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteOdbNetworkRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, DeleteOdbNetworkRequest> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(DeleteOdbNetworkRequest.getter(DeleteOdbNetworkRequest::odbNetworkId)).setter(DeleteOdbNetworkRequest.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<Boolean> DELETE_ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleteAssociatedResources").getter(DeleteOdbNetworkRequest.getter(DeleteOdbNetworkRequest::deleteAssociatedResources)).setter(DeleteOdbNetworkRequest.setter(Builder::deleteAssociatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAssociatedResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD, DELETE_ASSOCIATED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteOdbNetworkRequest.memberNameToFieldInitializer();
    private final String odbNetworkId;
    private final Boolean deleteAssociatedResources;

    private DeleteOdbNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.odbNetworkId = builder.odbNetworkId;
        this.deleteAssociatedResources = builder.deleteAssociatedResources;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final Boolean deleteAssociatedResources() {
        return this.deleteAssociatedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAssociatedResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOdbNetworkRequest)) {
            return false;
        }
        DeleteOdbNetworkRequest other = (DeleteOdbNetworkRequest)((Object)obj);
        return Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.deleteAssociatedResources(), other.deleteAssociatedResources());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteOdbNetworkRequest").add("OdbNetworkId", (Object)this.odbNetworkId()).add("DeleteAssociatedResources", (Object)this.deleteAssociatedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "deleteAssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.deleteAssociatedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("deleteAssociatedResources", DELETE_ASSOCIATED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteOdbNetworkRequest, T> g) {
        return obj -> g.apply((DeleteOdbNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String odbNetworkId;
        private Boolean deleteAssociatedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOdbNetworkRequest model) {
            super(model);
            this.odbNetworkId(model.odbNetworkId);
            this.deleteAssociatedResources(model.deleteAssociatedResources);
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final Boolean getDeleteAssociatedResources() {
            return this.deleteAssociatedResources;
        }

        public final void setDeleteAssociatedResources(Boolean deleteAssociatedResources) {
            this.deleteAssociatedResources = deleteAssociatedResources;
        }

        @Override
        public final Builder deleteAssociatedResources(Boolean deleteAssociatedResources) {
            this.deleteAssociatedResources = deleteAssociatedResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOdbNetworkRequest build() {
            return new DeleteOdbNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteOdbNetworkRequest> {
        public Builder odbNetworkId(String var1);

        public Builder deleteAssociatedResources(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

