/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.DbSystemShapeSummary;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse;

public class ListDbSystemShapesIterable
implements SdkIterable<ListDbSystemShapesResponse> {
    private final OdbClient client;
    private final ListDbSystemShapesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbSystemShapesIterable(OdbClient client, ListDbSystemShapesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbSystemShapesResponseFetcher();
    }

    public Iterator<ListDbSystemShapesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbSystemShapeSummary> dbSystemShapes() {
        Function<ListDbSystemShapesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSystemShapes() != null) {
                return response.dbSystemShapes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbSystemShapesResponseFetcher
    implements SyncPageFetcher<ListDbSystemShapesResponse> {
        private ListDbSystemShapesResponseFetcher() {
        }

        public boolean hasNextPage(ListDbSystemShapesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbSystemShapesResponse nextPage(ListDbSystemShapesResponse previousPage) {
            if (previousPage == null) {
                return ListDbSystemShapesIterable.this.client.listDbSystemShapes(ListDbSystemShapesIterable.this.firstRequest);
            }
            return ListDbSystemShapesIterable.this.client.listDbSystemShapes((ListDbSystemShapesRequest)((Object)ListDbSystemShapesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

