/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OciOnboardingStatus {
    NOT_STARTED("NOT_STARTED"),
    PENDING_LINK_GENERATION("PENDING_LINK_GENERATION"),
    PENDING_CUSTOMER_ACTION("PENDING_CUSTOMER_ACTION"),
    PENDING_INITIALIZATION("PENDING_INITIALIZATION"),
    ACTIVATING("ACTIVATING"),
    ACTIVE_IN_HOME_REGION("ACTIVE_IN_HOME_REGION"),
    ACTIVE("ACTIVE"),
    ACTIVE_LIMITED("ACTIVE_LIMITED"),
    FAILED("FAILED"),
    PUBLIC_OFFER_UNSUPPORTED("PUBLIC_OFFER_UNSUPPORTED"),
    SUSPENDED("SUSPENDED"),
    CANCELED("CANCELED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OciOnboardingStatus> VALUE_MAP;
    private final String value;

    private OciOnboardingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OciOnboardingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OciOnboardingStatus> knownValues() {
        EnumSet<OciOnboardingStatus> knownValues = EnumSet.allOf(OciOnboardingStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OciOnboardingStatus.class, OciOnboardingStatus::toString);
    }
}

