/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.AutonomousVirtualMachineSummary;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse;

public class ListAutonomousVirtualMachinesPublisher
implements SdkPublisher<ListAutonomousVirtualMachinesResponse> {
    private final OdbAsyncClient client;
    private final ListAutonomousVirtualMachinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutonomousVirtualMachinesPublisher(OdbAsyncClient client, ListAutonomousVirtualMachinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutonomousVirtualMachinesPublisher(OdbAsyncClient client, ListAutonomousVirtualMachinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutonomousVirtualMachinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutonomousVirtualMachinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutonomousVirtualMachineSummary> autonomousVirtualMachines() {
        Function<ListAutonomousVirtualMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.autonomousVirtualMachines() != null) {
                return response.autonomousVirtualMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutonomousVirtualMachinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutonomousVirtualMachinesResponseFetcher
    implements AsyncPageFetcher<ListAutonomousVirtualMachinesResponse> {
        private ListAutonomousVirtualMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutonomousVirtualMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutonomousVirtualMachinesResponse> nextPage(ListAutonomousVirtualMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListAutonomousVirtualMachinesPublisher.this.client.listAutonomousVirtualMachines(ListAutonomousVirtualMachinesPublisher.this.firstRequest);
            }
            return ListAutonomousVirtualMachinesPublisher.this.client.listAutonomousVirtualMachines((ListAutonomousVirtualMachinesRequest)((Object)ListAutonomousVirtualMachinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

