/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.DayOfWeek;
import software.amazon.awssdk.services.odb.model.DaysOfWeekCopier;
import software.amazon.awssdk.services.odb.model.HoursOfDayCopier;
import software.amazon.awssdk.services.odb.model.Month;
import software.amazon.awssdk.services.odb.model.MonthsCopier;
import software.amazon.awssdk.services.odb.model.PatchingModeType;
import software.amazon.awssdk.services.odb.model.PreferenceType;
import software.amazon.awssdk.services.odb.model.WeeksOfMonthCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindow> {
    private static final SdkField<Integer> CUSTOM_ACTION_TIMEOUT_IN_MINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("customActionTimeoutInMins").getter(MaintenanceWindow.getter(MaintenanceWindow::customActionTimeoutInMins)).setter(MaintenanceWindow.setter(Builder::customActionTimeoutInMins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customActionTimeoutInMins").build()}).build();
    private static final SdkField<List<DayOfWeek>> DAYS_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("daysOfWeek").getter(MaintenanceWindow.getter(MaintenanceWindow::daysOfWeek)).setter(MaintenanceWindow.setter(Builder::daysOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("daysOfWeek").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DayOfWeek::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> HOURS_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hoursOfDay").getter(MaintenanceWindow.getter(MaintenanceWindow::hoursOfDay)).setter(MaintenanceWindow.setter(Builder::hoursOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hoursOfDay").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_CUSTOM_ACTION_TIMEOUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isCustomActionTimeoutEnabled").getter(MaintenanceWindow.getter(MaintenanceWindow::isCustomActionTimeoutEnabled)).setter(MaintenanceWindow.setter(Builder::isCustomActionTimeoutEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCustomActionTimeoutEnabled").build()}).build();
    private static final SdkField<Integer> LEAD_TIME_IN_WEEKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("leadTimeInWeeks").getter(MaintenanceWindow.getter(MaintenanceWindow::leadTimeInWeeks)).setter(MaintenanceWindow.setter(Builder::leadTimeInWeeks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leadTimeInWeeks").build()}).build();
    private static final SdkField<List<Month>> MONTHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("months").getter(MaintenanceWindow.getter(MaintenanceWindow::months)).setter(MaintenanceWindow.setter(Builder::months)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("months").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Month::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PATCHING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patchingMode").getter(MaintenanceWindow.getter(MaintenanceWindow::patchingModeAsString)).setter(MaintenanceWindow.setter(Builder::patchingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchingMode").build()}).build();
    private static final SdkField<String> PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preference").getter(MaintenanceWindow.getter(MaintenanceWindow::preferenceAsString)).setter(MaintenanceWindow.setter(Builder::preference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preference").build()}).build();
    private static final SdkField<Boolean> SKIP_RU_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipRu").getter(MaintenanceWindow.getter(MaintenanceWindow::skipRu)).setter(MaintenanceWindow.setter(Builder::skipRu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipRu").build()}).build();
    private static final SdkField<List<Integer>> WEEKS_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("weeksOfMonth").getter(MaintenanceWindow.getter(MaintenanceWindow::weeksOfMonth)).setter(MaintenanceWindow.setter(Builder::weeksOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weeksOfMonth").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_TIMEOUT_IN_MINS_FIELD, DAYS_OF_WEEK_FIELD, HOURS_OF_DAY_FIELD, IS_CUSTOM_ACTION_TIMEOUT_ENABLED_FIELD, LEAD_TIME_IN_WEEKS_FIELD, MONTHS_FIELD, PATCHING_MODE_FIELD, PREFERENCE_FIELD, SKIP_RU_FIELD, WEEKS_OF_MONTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MaintenanceWindow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer customActionTimeoutInMins;
    private final List<DayOfWeek> daysOfWeek;
    private final List<Integer> hoursOfDay;
    private final Boolean isCustomActionTimeoutEnabled;
    private final Integer leadTimeInWeeks;
    private final List<Month> months;
    private final String patchingMode;
    private final String preference;
    private final Boolean skipRu;
    private final List<Integer> weeksOfMonth;

    private MaintenanceWindow(BuilderImpl builder) {
        this.customActionTimeoutInMins = builder.customActionTimeoutInMins;
        this.daysOfWeek = builder.daysOfWeek;
        this.hoursOfDay = builder.hoursOfDay;
        this.isCustomActionTimeoutEnabled = builder.isCustomActionTimeoutEnabled;
        this.leadTimeInWeeks = builder.leadTimeInWeeks;
        this.months = builder.months;
        this.patchingMode = builder.patchingMode;
        this.preference = builder.preference;
        this.skipRu = builder.skipRu;
        this.weeksOfMonth = builder.weeksOfMonth;
    }

    public final Integer customActionTimeoutInMins() {
        return this.customActionTimeoutInMins;
    }

    public final boolean hasDaysOfWeek() {
        return this.daysOfWeek != null && !(this.daysOfWeek instanceof SdkAutoConstructList);
    }

    public final List<DayOfWeek> daysOfWeek() {
        return this.daysOfWeek;
    }

    public final boolean hasHoursOfDay() {
        return this.hoursOfDay != null && !(this.hoursOfDay instanceof SdkAutoConstructList);
    }

    public final List<Integer> hoursOfDay() {
        return this.hoursOfDay;
    }

    public final Boolean isCustomActionTimeoutEnabled() {
        return this.isCustomActionTimeoutEnabled;
    }

    public final Integer leadTimeInWeeks() {
        return this.leadTimeInWeeks;
    }

    public final boolean hasMonths() {
        return this.months != null && !(this.months instanceof SdkAutoConstructList);
    }

    public final List<Month> months() {
        return this.months;
    }

    public final PatchingModeType patchingMode() {
        return PatchingModeType.fromValue(this.patchingMode);
    }

    public final String patchingModeAsString() {
        return this.patchingMode;
    }

    public final PreferenceType preference() {
        return PreferenceType.fromValue(this.preference);
    }

    public final String preferenceAsString() {
        return this.preference;
    }

    public final Boolean skipRu() {
        return this.skipRu;
    }

    public final boolean hasWeeksOfMonth() {
        return this.weeksOfMonth != null && !(this.weeksOfMonth instanceof SdkAutoConstructList);
    }

    public final List<Integer> weeksOfMonth() {
        return this.weeksOfMonth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customActionTimeoutInMins());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDaysOfWeek() ? this.daysOfWeek() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHoursOfDay() ? this.hoursOfDay() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isCustomActionTimeoutEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.leadTimeInWeeks());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonths() ? this.months() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.patchingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipRu());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWeeksOfMonth() ? this.weeksOfMonth() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindow)) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow)obj;
        return Objects.equals(this.customActionTimeoutInMins(), other.customActionTimeoutInMins()) && this.hasDaysOfWeek() == other.hasDaysOfWeek() && Objects.equals(this.daysOfWeek(), other.daysOfWeek()) && this.hasHoursOfDay() == other.hasHoursOfDay() && Objects.equals(this.hoursOfDay(), other.hoursOfDay()) && Objects.equals(this.isCustomActionTimeoutEnabled(), other.isCustomActionTimeoutEnabled()) && Objects.equals(this.leadTimeInWeeks(), other.leadTimeInWeeks()) && this.hasMonths() == other.hasMonths() && Objects.equals(this.months(), other.months()) && Objects.equals(this.patchingModeAsString(), other.patchingModeAsString()) && Objects.equals(this.preferenceAsString(), other.preferenceAsString()) && Objects.equals(this.skipRu(), other.skipRu()) && this.hasWeeksOfMonth() == other.hasWeeksOfMonth() && Objects.equals(this.weeksOfMonth(), other.weeksOfMonth());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindow").add("CustomActionTimeoutInMins", (Object)this.customActionTimeoutInMins()).add("DaysOfWeek", this.hasDaysOfWeek() ? this.daysOfWeek() : null).add("HoursOfDay", this.hasHoursOfDay() ? this.hoursOfDay() : null).add("IsCustomActionTimeoutEnabled", (Object)this.isCustomActionTimeoutEnabled()).add("LeadTimeInWeeks", (Object)this.leadTimeInWeeks()).add("Months", this.hasMonths() ? this.months() : null).add("PatchingMode", (Object)this.patchingModeAsString()).add("Preference", (Object)this.preferenceAsString()).add("SkipRu", (Object)this.skipRu()).add("WeeksOfMonth", this.hasWeeksOfMonth() ? this.weeksOfMonth() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customActionTimeoutInMins": {
                return Optional.ofNullable(clazz.cast(this.customActionTimeoutInMins()));
            }
            case "daysOfWeek": {
                return Optional.ofNullable(clazz.cast(this.daysOfWeek()));
            }
            case "hoursOfDay": {
                return Optional.ofNullable(clazz.cast(this.hoursOfDay()));
            }
            case "isCustomActionTimeoutEnabled": {
                return Optional.ofNullable(clazz.cast(this.isCustomActionTimeoutEnabled()));
            }
            case "leadTimeInWeeks": {
                return Optional.ofNullable(clazz.cast(this.leadTimeInWeeks()));
            }
            case "months": {
                return Optional.ofNullable(clazz.cast(this.months()));
            }
            case "patchingMode": {
                return Optional.ofNullable(clazz.cast(this.patchingModeAsString()));
            }
            case "preference": {
                return Optional.ofNullable(clazz.cast(this.preferenceAsString()));
            }
            case "skipRu": {
                return Optional.ofNullable(clazz.cast(this.skipRu()));
            }
            case "weeksOfMonth": {
                return Optional.ofNullable(clazz.cast(this.weeksOfMonth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customActionTimeoutInMins", CUSTOM_ACTION_TIMEOUT_IN_MINS_FIELD);
        map.put("daysOfWeek", DAYS_OF_WEEK_FIELD);
        map.put("hoursOfDay", HOURS_OF_DAY_FIELD);
        map.put("isCustomActionTimeoutEnabled", IS_CUSTOM_ACTION_TIMEOUT_ENABLED_FIELD);
        map.put("leadTimeInWeeks", LEAD_TIME_IN_WEEKS_FIELD);
        map.put("months", MONTHS_FIELD);
        map.put("patchingMode", PATCHING_MODE_FIELD);
        map.put("preference", PREFERENCE_FIELD);
        map.put("skipRu", SKIP_RU_FIELD);
        map.put("weeksOfMonth", WEEKS_OF_MONTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindow, T> g) {
        return obj -> g.apply((MaintenanceWindow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer customActionTimeoutInMins;
        private List<DayOfWeek> daysOfWeek = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> hoursOfDay = DefaultSdkAutoConstructList.getInstance();
        private Boolean isCustomActionTimeoutEnabled;
        private Integer leadTimeInWeeks;
        private List<Month> months = DefaultSdkAutoConstructList.getInstance();
        private String patchingMode;
        private String preference;
        private Boolean skipRu;
        private List<Integer> weeksOfMonth = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindow model) {
            this.customActionTimeoutInMins(model.customActionTimeoutInMins);
            this.daysOfWeek(model.daysOfWeek);
            this.hoursOfDay(model.hoursOfDay);
            this.isCustomActionTimeoutEnabled(model.isCustomActionTimeoutEnabled);
            this.leadTimeInWeeks(model.leadTimeInWeeks);
            this.months(model.months);
            this.patchingMode(model.patchingMode);
            this.preference(model.preference);
            this.skipRu(model.skipRu);
            this.weeksOfMonth(model.weeksOfMonth);
        }

        public final Integer getCustomActionTimeoutInMins() {
            return this.customActionTimeoutInMins;
        }

        public final void setCustomActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
        }

        @Override
        public final Builder customActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
            return this;
        }

        public final List<DayOfWeek.Builder> getDaysOfWeek() {
            List<DayOfWeek.Builder> result = DaysOfWeekCopier.copyToBuilder(this.daysOfWeek);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDaysOfWeek(Collection<DayOfWeek.BuilderImpl> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copyFromBuilder(daysOfWeek);
        }

        @Override
        public final Builder daysOfWeek(Collection<DayOfWeek> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(DayOfWeek ... daysOfWeek) {
            this.daysOfWeek(Arrays.asList(daysOfWeek));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(Consumer<DayOfWeek.Builder> ... daysOfWeek) {
            this.daysOfWeek(Stream.of(daysOfWeek).map(c -> (DayOfWeek)((DayOfWeek.Builder)DayOfWeek.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getHoursOfDay() {
            if (this.hoursOfDay instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hoursOfDay;
        }

        public final void setHoursOfDay(Collection<Integer> hoursOfDay) {
            this.hoursOfDay = HoursOfDayCopier.copy(hoursOfDay);
        }

        @Override
        public final Builder hoursOfDay(Collection<Integer> hoursOfDay) {
            this.hoursOfDay = HoursOfDayCopier.copy(hoursOfDay);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfDay(Integer ... hoursOfDay) {
            this.hoursOfDay(Arrays.asList(hoursOfDay));
            return this;
        }

        public final Boolean getIsCustomActionTimeoutEnabled() {
            return this.isCustomActionTimeoutEnabled;
        }

        public final void setIsCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
        }

        @Override
        public final Builder isCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
            return this;
        }

        public final Integer getLeadTimeInWeeks() {
            return this.leadTimeInWeeks;
        }

        public final void setLeadTimeInWeeks(Integer leadTimeInWeeks) {
            this.leadTimeInWeeks = leadTimeInWeeks;
        }

        @Override
        public final Builder leadTimeInWeeks(Integer leadTimeInWeeks) {
            this.leadTimeInWeeks = leadTimeInWeeks;
            return this;
        }

        public final List<Month.Builder> getMonths() {
            List<Month.Builder> result = MonthsCopier.copyToBuilder(this.months);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonths(Collection<Month.BuilderImpl> months) {
            this.months = MonthsCopier.copyFromBuilder(months);
        }

        @Override
        public final Builder months(Collection<Month> months) {
            this.months = MonthsCopier.copy(months);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder months(Month ... months) {
            this.months(Arrays.asList(months));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder months(Consumer<Month.Builder> ... months) {
            this.months(Stream.of(months).map(c -> (Month)((Month.Builder)Month.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPatchingMode() {
            return this.patchingMode;
        }

        public final void setPatchingMode(String patchingMode) {
            this.patchingMode = patchingMode;
        }

        @Override
        public final Builder patchingMode(String patchingMode) {
            this.patchingMode = patchingMode;
            return this;
        }

        @Override
        public final Builder patchingMode(PatchingModeType patchingMode) {
            this.patchingMode(patchingMode == null ? null : patchingMode.toString());
            return this;
        }

        public final String getPreference() {
            return this.preference;
        }

        public final void setPreference(String preference) {
            this.preference = preference;
        }

        @Override
        public final Builder preference(String preference) {
            this.preference = preference;
            return this;
        }

        @Override
        public final Builder preference(PreferenceType preference) {
            this.preference(preference == null ? null : preference.toString());
            return this;
        }

        public final Boolean getSkipRu() {
            return this.skipRu;
        }

        public final void setSkipRu(Boolean skipRu) {
            this.skipRu = skipRu;
        }

        @Override
        public final Builder skipRu(Boolean skipRu) {
            this.skipRu = skipRu;
            return this;
        }

        public final Collection<Integer> getWeeksOfMonth() {
            if (this.weeksOfMonth instanceof SdkAutoConstructList) {
                return null;
            }
            return this.weeksOfMonth;
        }

        public final void setWeeksOfMonth(Collection<Integer> weeksOfMonth) {
            this.weeksOfMonth = WeeksOfMonthCopier.copy(weeksOfMonth);
        }

        @Override
        public final Builder weeksOfMonth(Collection<Integer> weeksOfMonth) {
            this.weeksOfMonth = WeeksOfMonthCopier.copy(weeksOfMonth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weeksOfMonth(Integer ... weeksOfMonth) {
            this.weeksOfMonth(Arrays.asList(weeksOfMonth));
            return this;
        }

        public MaintenanceWindow build() {
            return new MaintenanceWindow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindow> {
        public Builder customActionTimeoutInMins(Integer var1);

        public Builder daysOfWeek(Collection<DayOfWeek> var1);

        public Builder daysOfWeek(DayOfWeek ... var1);

        public Builder daysOfWeek(Consumer<DayOfWeek.Builder> ... var1);

        public Builder hoursOfDay(Collection<Integer> var1);

        public Builder hoursOfDay(Integer ... var1);

        public Builder isCustomActionTimeoutEnabled(Boolean var1);

        public Builder leadTimeInWeeks(Integer var1);

        public Builder months(Collection<Month> var1);

        public Builder months(Month ... var1);

        public Builder months(Consumer<Month.Builder> ... var1);

        public Builder patchingMode(String var1);

        public Builder patchingMode(PatchingModeType var1);

        public Builder preference(String var1);

        public Builder preference(PreferenceType var1);

        public Builder skipRu(Boolean var1);

        public Builder weeksOfMonth(Collection<Integer> var1);

        public Builder weeksOfMonth(Integer ... var1);
    }
}

