/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.DbNodeSummary;
import software.amazon.awssdk.services.odb.model.ListDbNodesRequest;
import software.amazon.awssdk.services.odb.model.ListDbNodesResponse;

public class ListDbNodesPublisher
implements SdkPublisher<ListDbNodesResponse> {
    private final OdbAsyncClient client;
    private final ListDbNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbNodesPublisher(OdbAsyncClient client, ListDbNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbNodesPublisher(OdbAsyncClient client, ListDbNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbNodeSummary> dbNodes() {
        Function<ListDbNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbNodes() != null) {
                return response.dbNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbNodesResponseFetcher
    implements AsyncPageFetcher<ListDbNodesResponse> {
        private ListDbNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListDbNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbNodesResponse> nextPage(ListDbNodesResponse previousPage) {
            if (previousPage == null) {
                return ListDbNodesPublisher.this.client.listDbNodes(ListDbNodesPublisher.this.firstRequest);
            }
            return ListDbNodesPublisher.this.client.listDbNodes((ListDbNodesRequest)((Object)ListDbNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

