/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminAsyncClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineSummary;

public class ListTelemetryPipelinesPublisher
implements SdkPublisher<ListTelemetryPipelinesResponse> {
    private final ObservabilityAdminAsyncClient client;
    private final ListTelemetryPipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTelemetryPipelinesPublisher(ObservabilityAdminAsyncClient client, ListTelemetryPipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTelemetryPipelinesPublisher(ObservabilityAdminAsyncClient client, ListTelemetryPipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTelemetryPipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTelemetryPipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TelemetryPipelineSummary> pipelineSummaries() {
        Function<ListTelemetryPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineSummaries() != null) {
                return response.pipelineSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTelemetryPipelinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTelemetryPipelinesResponseFetcher
    implements AsyncPageFetcher<ListTelemetryPipelinesResponse> {
        private ListTelemetryPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListTelemetryPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTelemetryPipelinesResponse> nextPage(ListTelemetryPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListTelemetryPipelinesPublisher.this.client.listTelemetryPipelines(ListTelemetryPipelinesPublisher.this.firstRequest);
            }
            return ListTelemetryPipelinesPublisher.this.client.listTelemetryPipelines((ListTelemetryPipelinesRequest)((Object)ListTelemetryPipelinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

