/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminAsyncClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsResponse;

public class ListS3TableIntegrationsPublisher
implements SdkPublisher<ListS3TableIntegrationsResponse> {
    private final ObservabilityAdminAsyncClient client;
    private final ListS3TableIntegrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListS3TableIntegrationsPublisher(ObservabilityAdminAsyncClient client, ListS3TableIntegrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListS3TableIntegrationsPublisher(ObservabilityAdminAsyncClient client, ListS3TableIntegrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListS3TableIntegrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListS3TableIntegrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IntegrationSummary> integrationSummaries() {
        Function<ListS3TableIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrationSummaries() != null) {
                return response.integrationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListS3TableIntegrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListS3TableIntegrationsResponseFetcher
    implements AsyncPageFetcher<ListS3TableIntegrationsResponse> {
        private ListS3TableIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListS3TableIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListS3TableIntegrationsResponse> nextPage(ListS3TableIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListS3TableIntegrationsPublisher.this.client.listS3TableIntegrations(ListS3TableIntegrationsPublisher.this.firstRequest);
            }
            return ListS3TableIntegrationsPublisher.this.client.listS3TableIntegrations((ListS3TableIntegrationsRequest)((Object)ListS3TableIntegrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

