/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.FieldToMatch;
import software.amazon.awssdk.services.observabilityadmin.model.LoggingFilter;
import software.amazon.awssdk.services.observabilityadmin.model.RedactedFieldsCopier;
import software.amazon.awssdk.services.observabilityadmin.model.WAFLogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WAFLoggingParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WAFLoggingParameters> {
    private static final SdkField<List<FieldToMatch>> REDACTED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RedactedFields").getter(WAFLoggingParameters.getter(WAFLoggingParameters::redactedFields)).setter(WAFLoggingParameters.setter(Builder::redactedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LoggingFilter> LOGGING_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingFilter").getter(WAFLoggingParameters.getter(WAFLoggingParameters::loggingFilter)).setter(WAFLoggingParameters.setter(Builder::loggingFilter)).constructor(LoggingFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingFilter").build()}).build();
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogType").getter(WAFLoggingParameters.getter(WAFLoggingParameters::logTypeAsString)).setter(WAFLoggingParameters.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDACTED_FIELDS_FIELD, LOGGING_FILTER_FIELD, LOG_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WAFLoggingParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FieldToMatch> redactedFields;
    private final LoggingFilter loggingFilter;
    private final String logType;

    private WAFLoggingParameters(BuilderImpl builder) {
        this.redactedFields = builder.redactedFields;
        this.loggingFilter = builder.loggingFilter;
        this.logType = builder.logType;
    }

    public final boolean hasRedactedFields() {
        return this.redactedFields != null && !(this.redactedFields instanceof SdkAutoConstructList);
    }

    public final List<FieldToMatch> redactedFields() {
        return this.redactedFields;
    }

    public final LoggingFilter loggingFilter() {
        return this.loggingFilter;
    }

    public final WAFLogType logType() {
        return WAFLogType.fromValue(this.logType);
    }

    public final String logTypeAsString() {
        return this.logType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedactedFields() ? this.redactedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WAFLoggingParameters)) {
            return false;
        }
        WAFLoggingParameters other = (WAFLoggingParameters)obj;
        return this.hasRedactedFields() == other.hasRedactedFields() && Objects.equals(this.redactedFields(), other.redactedFields()) && Objects.equals(this.loggingFilter(), other.loggingFilter()) && Objects.equals(this.logTypeAsString(), other.logTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WAFLoggingParameters").add("RedactedFields", this.hasRedactedFields() ? this.redactedFields() : null).add("LoggingFilter", (Object)this.loggingFilter()).add("LogType", (Object)this.logTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedactedFields": {
                return Optional.ofNullable(clazz.cast(this.redactedFields()));
            }
            case "LoggingFilter": {
                return Optional.ofNullable(clazz.cast(this.loggingFilter()));
            }
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RedactedFields", REDACTED_FIELDS_FIELD);
        map.put("LoggingFilter", LOGGING_FILTER_FIELD);
        map.put("LogType", LOG_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WAFLoggingParameters, T> g) {
        return obj -> g.apply((WAFLoggingParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldToMatch> redactedFields = DefaultSdkAutoConstructList.getInstance();
        private LoggingFilter loggingFilter;
        private String logType;

        private BuilderImpl() {
        }

        private BuilderImpl(WAFLoggingParameters model) {
            this.redactedFields(model.redactedFields);
            this.loggingFilter(model.loggingFilter);
            this.logType(model.logType);
        }

        public final List<FieldToMatch.Builder> getRedactedFields() {
            List<FieldToMatch.Builder> result = RedactedFieldsCopier.copyToBuilder(this.redactedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedactedFields(Collection<FieldToMatch.BuilderImpl> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copyFromBuilder(redactedFields);
        }

        @Override
        public final Builder redactedFields(Collection<FieldToMatch> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copy(redactedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(FieldToMatch ... redactedFields) {
            this.redactedFields(Arrays.asList(redactedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(Consumer<FieldToMatch.Builder> ... redactedFields) {
            this.redactedFields(Stream.of(redactedFields).map(c -> (FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LoggingFilter.Builder getLoggingFilter() {
            return this.loggingFilter != null ? this.loggingFilter.toBuilder() : null;
        }

        public final void setLoggingFilter(LoggingFilter.BuilderImpl loggingFilter) {
            this.loggingFilter = loggingFilter != null ? loggingFilter.build() : null;
        }

        @Override
        public final Builder loggingFilter(LoggingFilter loggingFilter) {
            this.loggingFilter = loggingFilter;
            return this;
        }

        public final String getLogType() {
            return this.logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(WAFLogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public WAFLoggingParameters build() {
            return new WAFLoggingParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WAFLoggingParameters> {
        public Builder redactedFields(Collection<FieldToMatch> var1);

        public Builder redactedFields(FieldToMatch ... var1);

        public Builder redactedFields(Consumer<FieldToMatch.Builder> ... var1);

        public Builder loggingFilter(LoggingFilter var1);

        default public Builder loggingFilter(Consumer<LoggingFilter.Builder> loggingFilter) {
            return this.loggingFilter((LoggingFilter)((LoggingFilter.Builder)LoggingFilter.builder().applyMutation(loggingFilter)).build());
        }

        public Builder logType(String var1);

        public Builder logType(WAFLogType var1);
    }
}

