/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    AWS_EC2_INSTANCE("AWS::EC2::Instance"),
    AWS_EC2_VPC("AWS::EC2::VPC"),
    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),
    AWS_CLOUD_TRAIL("AWS::CloudTrail"),
    AWS_EKS_CLUSTER("AWS::EKS::Cluster"),
    AWS_WAF_V2_WEB_ACL("AWS::WAFv2::WebACL"),
    AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("AWS::ElasticLoadBalancingV2::LoadBalancer"),
    AWS_ROUTE53_RESOLVER_RESOLVER_ENDPOINT("AWS::Route53Resolver::ResolverEndpoint"),
    AWS_BEDROCK_AGENT_CORE_RUNTIME("AWS::BedrockAgentCore::Runtime"),
    AWS_BEDROCK_AGENT_CORE_BROWSER("AWS::BedrockAgentCore::Browser"),
    AWS_BEDROCK_AGENT_CORE_CODE_INTERPRETER("AWS::BedrockAgentCore::CodeInterpreter"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

