/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.EncryptionConflictResolutionStrategy;
import software.amazon.awssdk.services.observabilityadmin.model.EncryptionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsEncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogsEncryptionConfiguration> {
    private static final SdkField<String> ENCRYPTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionStrategy").getter(LogsEncryptionConfiguration.getter(LogsEncryptionConfiguration::encryptionStrategyAsString)).setter(LogsEncryptionConfiguration.setter(Builder::encryptionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStrategy").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(LogsEncryptionConfiguration.getter(LogsEncryptionConfiguration::kmsKeyArn)).setter(LogsEncryptionConfiguration.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionConflictResolutionStrategy").getter(LogsEncryptionConfiguration.getter(LogsEncryptionConfiguration::encryptionConflictResolutionStrategyAsString)).setter(LogsEncryptionConfiguration.setter(Builder::encryptionConflictResolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConflictResolutionStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_STRATEGY_FIELD, KMS_KEY_ARN_FIELD, ENCRYPTION_CONFLICT_RESOLUTION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogsEncryptionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String encryptionStrategy;
    private final String kmsKeyArn;
    private final String encryptionConflictResolutionStrategy;

    private LogsEncryptionConfiguration(BuilderImpl builder) {
        this.encryptionStrategy = builder.encryptionStrategy;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.encryptionConflictResolutionStrategy = builder.encryptionConflictResolutionStrategy;
    }

    public final EncryptionStrategy encryptionStrategy() {
        return EncryptionStrategy.fromValue(this.encryptionStrategy);
    }

    public final String encryptionStrategyAsString() {
        return this.encryptionStrategy;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final EncryptionConflictResolutionStrategy encryptionConflictResolutionStrategy() {
        return EncryptionConflictResolutionStrategy.fromValue(this.encryptionConflictResolutionStrategy);
    }

    public final String encryptionConflictResolutionStrategyAsString() {
        return this.encryptionConflictResolutionStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConflictResolutionStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsEncryptionConfiguration)) {
            return false;
        }
        LogsEncryptionConfiguration other = (LogsEncryptionConfiguration)obj;
        return Objects.equals(this.encryptionStrategyAsString(), other.encryptionStrategyAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.encryptionConflictResolutionStrategyAsString(), other.encryptionConflictResolutionStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LogsEncryptionConfiguration").add("EncryptionStrategy", (Object)this.encryptionStrategyAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("EncryptionConflictResolutionStrategy", (Object)this.encryptionConflictResolutionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionStrategy": {
                return Optional.ofNullable(clazz.cast(this.encryptionStrategyAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "EncryptionConflictResolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.encryptionConflictResolutionStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EncryptionStrategy", ENCRYPTION_STRATEGY_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("EncryptionConflictResolutionStrategy", ENCRYPTION_CONFLICT_RESOLUTION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogsEncryptionConfiguration, T> g) {
        return obj -> g.apply((LogsEncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionStrategy;
        private String kmsKeyArn;
        private String encryptionConflictResolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsEncryptionConfiguration model) {
            this.encryptionStrategy(model.encryptionStrategy);
            this.kmsKeyArn(model.kmsKeyArn);
            this.encryptionConflictResolutionStrategy(model.encryptionConflictResolutionStrategy);
        }

        public final String getEncryptionStrategy() {
            return this.encryptionStrategy;
        }

        public final void setEncryptionStrategy(String encryptionStrategy) {
            this.encryptionStrategy = encryptionStrategy;
        }

        @Override
        public final Builder encryptionStrategy(String encryptionStrategy) {
            this.encryptionStrategy = encryptionStrategy;
            return this;
        }

        @Override
        public final Builder encryptionStrategy(EncryptionStrategy encryptionStrategy) {
            this.encryptionStrategy(encryptionStrategy == null ? null : encryptionStrategy.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getEncryptionConflictResolutionStrategy() {
            return this.encryptionConflictResolutionStrategy;
        }

        public final void setEncryptionConflictResolutionStrategy(String encryptionConflictResolutionStrategy) {
            this.encryptionConflictResolutionStrategy = encryptionConflictResolutionStrategy;
        }

        @Override
        public final Builder encryptionConflictResolutionStrategy(String encryptionConflictResolutionStrategy) {
            this.encryptionConflictResolutionStrategy = encryptionConflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder encryptionConflictResolutionStrategy(EncryptionConflictResolutionStrategy encryptionConflictResolutionStrategy) {
            this.encryptionConflictResolutionStrategy(encryptionConflictResolutionStrategy == null ? null : encryptionConflictResolutionStrategy.toString());
            return this;
        }

        public LogsEncryptionConfiguration build() {
            return new LogsEncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogsEncryptionConfiguration> {
        public Builder encryptionStrategy(String var1);

        public Builder encryptionStrategy(EncryptionStrategy var1);

        public Builder kmsKeyArn(String var1);

        public Builder encryptionConflictResolutionStrategy(String var1);

        public Builder encryptionConflictResolutionStrategy(EncryptionConflictResolutionStrategy var1);
    }
}

