/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineSummariesCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTelemetryPipelinesResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, ListTelemetryPipelinesResponse> {
    private static final SdkField<List<TelemetryPipelineSummary>> PIPELINE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineSummaries").getter(ListTelemetryPipelinesResponse.getter(ListTelemetryPipelinesResponse::pipelineSummaries)).setter(ListTelemetryPipelinesResponse.setter(Builder::pipelineSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryPipelineSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTelemetryPipelinesResponse.getter(ListTelemetryPipelinesResponse::nextToken)).setter(ListTelemetryPipelinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTelemetryPipelinesResponse.memberNameToFieldInitializer();
    private final List<TelemetryPipelineSummary> pipelineSummaries;
    private final String nextToken;

    private ListTelemetryPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineSummaries = builder.pipelineSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPipelineSummaries() {
        return this.pipelineSummaries != null && !(this.pipelineSummaries instanceof SdkAutoConstructList);
    }

    public final List<TelemetryPipelineSummary> pipelineSummaries() {
        return this.pipelineSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineSummaries() ? this.pipelineSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTelemetryPipelinesResponse)) {
            return false;
        }
        ListTelemetryPipelinesResponse other = (ListTelemetryPipelinesResponse)((Object)obj);
        return this.hasPipelineSummaries() == other.hasPipelineSummaries() && Objects.equals(this.pipelineSummaries(), other.pipelineSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTelemetryPipelinesResponse").add("PipelineSummaries", this.hasPipelineSummaries() ? this.pipelineSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineSummaries": {
                return Optional.ofNullable(clazz.cast(this.pipelineSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineSummaries", PIPELINE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTelemetryPipelinesResponse, T> g) {
        return obj -> g.apply((ListTelemetryPipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private List<TelemetryPipelineSummary> pipelineSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTelemetryPipelinesResponse model) {
            super(model);
            this.pipelineSummaries(model.pipelineSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TelemetryPipelineSummary.Builder> getPipelineSummaries() {
            List<TelemetryPipelineSummary.Builder> result = TelemetryPipelineSummariesCopier.copyToBuilder(this.pipelineSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineSummaries(Collection<TelemetryPipelineSummary.BuilderImpl> pipelineSummaries) {
            this.pipelineSummaries = TelemetryPipelineSummariesCopier.copyFromBuilder(pipelineSummaries);
        }

        @Override
        public final Builder pipelineSummaries(Collection<TelemetryPipelineSummary> pipelineSummaries) {
            this.pipelineSummaries = TelemetryPipelineSummariesCopier.copy(pipelineSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineSummaries(TelemetryPipelineSummary ... pipelineSummaries) {
            this.pipelineSummaries(Arrays.asList(pipelineSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineSummaries(Consumer<TelemetryPipelineSummary.Builder> ... pipelineSummaries) {
            this.pipelineSummaries(Stream.of(pipelineSummaries).map(c -> (TelemetryPipelineSummary)((TelemetryPipelineSummary.Builder)TelemetryPipelineSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTelemetryPipelinesResponse build() {
            return new ListTelemetryPipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTelemetryPipelinesResponse> {
        public Builder pipelineSummaries(Collection<TelemetryPipelineSummary> var1);

        public Builder pipelineSummaries(TelemetryPipelineSummary ... var1);

        public Builder pipelineSummaries(Consumer<TelemetryPipelineSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

