/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.Condition;
import software.amazon.awssdk.services.observabilityadmin.model.ConditionsCopier;
import software.amazon.awssdk.services.observabilityadmin.model.FilterBehavior;
import software.amazon.awssdk.services.observabilityadmin.model.FilterRequirement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Behavior").getter(Filter.getter(Filter::behaviorAsString)).setter(Filter.setter(Builder::behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()}).build();
    private static final SdkField<String> REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Requirement").getter(Filter.getter(Filter::requirementAsString)).setter(Filter.setter(Builder::requirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requirement").build()}).build();
    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(Filter.getter(Filter::conditions)).setter(Filter.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD, REQUIREMENT_FIELD, CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Filter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String behavior;
    private final String requirement;
    private final List<Condition> conditions;

    private Filter(BuilderImpl builder) {
        this.behavior = builder.behavior;
        this.requirement = builder.requirement;
        this.conditions = builder.conditions;
    }

    public final FilterBehavior behavior() {
        return FilterBehavior.fromValue(this.behavior);
    }

    public final String behaviorAsString() {
        return this.behavior;
    }

    public final FilterRequirement requirement() {
        return FilterRequirement.fromValue(this.requirement);
    }

    public final String requirementAsString() {
        return this.requirement;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<Condition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.behaviorAsString(), other.behaviorAsString()) && Objects.equals(this.requirementAsString(), other.requirementAsString()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("Behavior", (Object)this.behaviorAsString()).add("Requirement", (Object)this.requirementAsString()).add("Conditions", this.hasConditions() ? this.conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Behavior": {
                return Optional.ofNullable(clazz.cast(this.behaviorAsString()));
            }
            case "Requirement": {
                return Optional.ofNullable(clazz.cast(this.requirementAsString()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Behavior", BEHAVIOR_FIELD);
        map.put("Requirement", REQUIREMENT_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String behavior;
        private String requirement;
        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.behavior(model.behavior);
            this.requirement(model.requirement);
            this.conditions(model.conditions);
        }

        public final String getBehavior() {
            return this.behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(FilterBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final String getRequirement() {
            return this.requirement;
        }

        public final void setRequirement(String requirement) {
            this.requirement = requirement;
        }

        @Override
        public final Builder requirement(String requirement) {
            this.requirement = requirement;
            return this;
        }

        @Override
        public final Builder requirement(FilterRequirement requirement) {
            this.requirement(requirement == null ? null : requirement.toString());
            return this;
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (Condition)((Condition.Builder)Condition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder behavior(String var1);

        public Builder behavior(FilterBehavior var1);

        public Builder requirement(String var1);

        public Builder requirement(FilterRequirement var1);

        public Builder conditions(Collection<Condition> var1);

        public Builder conditions(Condition ... var1);

        public Builder conditions(Consumer<Condition.Builder> ... var1);
    }
}

