/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.AdvancedEventSelector;
import software.amazon.awssdk.services.observabilityadmin.model.AdvancedEventSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudtrailParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudtrailParameters> {
    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedEventSelectors").getter(CloudtrailParameters.getter(CloudtrailParameters::advancedEventSelectors)).setter(CloudtrailParameters.setter(Builder::advancedEventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedEventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADVANCED_EVENT_SELECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudtrailParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AdvancedEventSelector> advancedEventSelectors;

    private CloudtrailParameters(BuilderImpl builder) {
        this.advancedEventSelectors = builder.advancedEventSelectors;
    }

    public final boolean hasAdvancedEventSelectors() {
        return this.advancedEventSelectors != null && !(this.advancedEventSelectors instanceof SdkAutoConstructList);
    }

    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return this.advancedEventSelectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudtrailParameters)) {
            return false;
        }
        CloudtrailParameters other = (CloudtrailParameters)obj;
        return this.hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors() && Objects.equals(this.advancedEventSelectors(), other.advancedEventSelectors());
    }

    public final String toString() {
        return ToString.builder((String)"CloudtrailParameters").add("AdvancedEventSelectors", this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdvancedEventSelectors": {
                return Optional.ofNullable(clazz.cast(this.advancedEventSelectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<AdvancedEventSelector>>> map = new HashMap<String, SdkField<List<AdvancedEventSelector>>>();
        map.put("AdvancedEventSelectors", ADVANCED_EVENT_SELECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudtrailParameters, T> g) {
        return obj -> g.apply((CloudtrailParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudtrailParameters model) {
            this.advancedEventSelectors(model.advancedEventSelectors);
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
            this.advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... advancedEventSelectors) {
            this.advancedEventSelectors(Stream.of(advancedEventSelectors).map(c -> (AdvancedEventSelector)((AdvancedEventSelector.Builder)AdvancedEventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CloudtrailParameters build() {
            return new CloudtrailParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudtrailParameters> {
        public Builder advancedEventSelectors(Collection<AdvancedEventSelector> var1);

        public Builder advancedEventSelectors(AdvancedEventSelector ... var1);

        public Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... var1);
    }
}

