/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for WAF logging, including redacted fields and logging filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WAFLoggingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<WAFLoggingParameters.Builder, WAFLoggingParameters> {
    private static final SdkField<List<FieldToMatch>> REDACTED_FIELDS_FIELD = SdkField
            .<List<FieldToMatch>> builder(MarshallingType.LIST)
            .memberName("RedactedFields")
            .getter(getter(WAFLoggingParameters::redactedFields))
            .setter(setter(Builder::redactedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldToMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldToMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LoggingFilter> LOGGING_FILTER_FIELD = SdkField
            .<LoggingFilter> builder(MarshallingType.SDK_POJO).memberName("LoggingFilter")
            .getter(getter(WAFLoggingParameters::loggingFilter)).setter(setter(Builder::loggingFilter))
            .constructor(LoggingFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingFilter").build()).build();

    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(WAFLoggingParameters::logTypeAsString)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDACTED_FIELDS_FIELD,
            LOGGING_FILTER_FIELD, LOG_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldToMatch> redactedFields;

    private final LoggingFilter loggingFilter;

    private final String logType;

    private WAFLoggingParameters(BuilderImpl builder) {
        this.redactedFields = builder.redactedFields;
        this.loggingFilter = builder.loggingFilter;
        this.logType = builder.logType;
    }

    /**
     * For responses, this returns true if the service returned a value for the RedactedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRedactedFields() {
        return redactedFields != null && !(redactedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fields to redact from WAF logs to protect sensitive information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRedactedFields} method.
     * </p>
     * 
     * @return The fields to redact from WAF logs to protect sensitive information.
     */
    public final List<FieldToMatch> redactedFields() {
        return redactedFields;
    }

    /**
     * <p>
     * A filter configuration that determines which WAF log records to include or exclude.
     * </p>
     * 
     * @return A filter configuration that determines which WAF log records to include or exclude.
     */
    public final LoggingFilter loggingFilter() {
        return loggingFilter;
    }

    /**
     * <p>
     * The type of WAF logs to collect (currently supports WAF_LOGS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link WAFLogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return The type of WAF logs to collect (currently supports WAF_LOGS).
     * @see WAFLogType
     */
    public final WAFLogType logType() {
        return WAFLogType.fromValue(logType);
    }

    /**
     * <p>
     * The type of WAF logs to collect (currently supports WAF_LOGS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link WAFLogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return The type of WAF logs to collect (currently supports WAF_LOGS).
     * @see WAFLogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRedactedFields() ? redactedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(loggingFilter());
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WAFLoggingParameters)) {
            return false;
        }
        WAFLoggingParameters other = (WAFLoggingParameters) obj;
        return hasRedactedFields() == other.hasRedactedFields() && Objects.equals(redactedFields(), other.redactedFields())
                && Objects.equals(loggingFilter(), other.loggingFilter())
                && Objects.equals(logTypeAsString(), other.logTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WAFLoggingParameters").add("RedactedFields", hasRedactedFields() ? redactedFields() : null)
                .add("LoggingFilter", loggingFilter()).add("LogType", logTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedactedFields":
            return Optional.ofNullable(clazz.cast(redactedFields()));
        case "LoggingFilter":
            return Optional.ofNullable(clazz.cast(loggingFilter()));
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RedactedFields", REDACTED_FIELDS_FIELD);
        map.put("LoggingFilter", LOGGING_FILTER_FIELD);
        map.put("LogType", LOG_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WAFLoggingParameters, T> g) {
        return obj -> g.apply((WAFLoggingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WAFLoggingParameters> {
        /**
         * <p>
         * The fields to redact from WAF logs to protect sensitive information.
         * </p>
         * 
         * @param redactedFields
         *        The fields to redact from WAF logs to protect sensitive information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactedFields(Collection<FieldToMatch> redactedFields);

        /**
         * <p>
         * The fields to redact from WAF logs to protect sensitive information.
         * </p>
         * 
         * @param redactedFields
         *        The fields to redact from WAF logs to protect sensitive information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactedFields(FieldToMatch... redactedFields);

        /**
         * <p>
         * The fields to redact from WAF logs to protect sensitive information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.FieldToMatch.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.observabilityadmin.model.FieldToMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.FieldToMatch.Builder#build()} is called
         * immediately and its result is passed to {@link #redactedFields(List<FieldToMatch>)}.
         * 
         * @param redactedFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.FieldToMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redactedFields(java.util.Collection<FieldToMatch>)
         */
        Builder redactedFields(Consumer<FieldToMatch.Builder>... redactedFields);

        /**
         * <p>
         * A filter configuration that determines which WAF log records to include or exclude.
         * </p>
         * 
         * @param loggingFilter
         *        A filter configuration that determines which WAF log records to include or exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingFilter(LoggingFilter loggingFilter);

        /**
         * <p>
         * A filter configuration that determines which WAF log records to include or exclude.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingFilter.Builder} avoiding the need
         * to create one manually via {@link LoggingFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingFilter(LoggingFilter)}.
         * 
         * @param loggingFilter
         *        a consumer that will call methods on {@link LoggingFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingFilter(LoggingFilter)
         */
        default Builder loggingFilter(Consumer<LoggingFilter.Builder> loggingFilter) {
            return loggingFilter(LoggingFilter.builder().applyMutation(loggingFilter).build());
        }

        /**
         * <p>
         * The type of WAF logs to collect (currently supports WAF_LOGS).
         * </p>
         * 
         * @param logType
         *        The type of WAF logs to collect (currently supports WAF_LOGS).
         * @see WAFLogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WAFLogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * The type of WAF logs to collect (currently supports WAF_LOGS).
         * </p>
         * 
         * @param logType
         *        The type of WAF logs to collect (currently supports WAF_LOGS).
         * @see WAFLogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WAFLogType
         */
        Builder logType(WAFLogType logType);
    }

    static final class BuilderImpl implements Builder {
        private List<FieldToMatch> redactedFields = DefaultSdkAutoConstructList.getInstance();

        private LoggingFilter loggingFilter;

        private String logType;

        private BuilderImpl() {
        }

        private BuilderImpl(WAFLoggingParameters model) {
            redactedFields(model.redactedFields);
            loggingFilter(model.loggingFilter);
            logType(model.logType);
        }

        public final List<FieldToMatch.Builder> getRedactedFields() {
            List<FieldToMatch.Builder> result = RedactedFieldsCopier.copyToBuilder(this.redactedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedactedFields(Collection<FieldToMatch.BuilderImpl> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copyFromBuilder(redactedFields);
        }

        @Override
        public final Builder redactedFields(Collection<FieldToMatch> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copy(redactedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(FieldToMatch... redactedFields) {
            redactedFields(Arrays.asList(redactedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(Consumer<FieldToMatch.Builder>... redactedFields) {
            redactedFields(Stream.of(redactedFields).map(c -> FieldToMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LoggingFilter.Builder getLoggingFilter() {
            return loggingFilter != null ? loggingFilter.toBuilder() : null;
        }

        public final void setLoggingFilter(LoggingFilter.BuilderImpl loggingFilter) {
            this.loggingFilter = loggingFilter != null ? loggingFilter.build() : null;
        }

        @Override
        public final Builder loggingFilter(LoggingFilter loggingFilter) {
            this.loggingFilter = loggingFilter;
            return this;
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(WAFLogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        @Override
        public WAFLoggingParameters build() {
            return new WAFLoggingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
