/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a complete telemetry pipeline resource with configuration, status, and metadata for data processing and
 * transformation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryPipeline implements SdkPojo, Serializable,
        ToCopyableBuilder<TelemetryPipeline.Builder, TelemetryPipeline> {
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreatedTimeStamp").getter(getter(TelemetryPipeline::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastUpdateTimeStamp").getter(getter(TelemetryPipeline::lastUpdateTimeStamp))
            .setter(setter(Builder::lastUpdateTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TelemetryPipeline::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TelemetryPipeline::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<TelemetryPipelineConfiguration> CONFIGURATION_FIELD = SdkField
            .<TelemetryPipelineConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(TelemetryPipeline::configuration)).setter(setter(Builder::configuration))
            .constructor(TelemetryPipelineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TelemetryPipeline::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<TelemetryPipelineStatusReason> STATUS_REASON_FIELD = SdkField
            .<TelemetryPipelineStatusReason> builder(MarshallingType.SDK_POJO).memberName("StatusReason")
            .getter(getter(TelemetryPipeline::statusReason)).setter(setter(Builder::statusReason))
            .constructor(TelemetryPipelineStatusReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(TelemetryPipeline::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_STAMP_FIELD,
            LAST_UPDATE_TIME_STAMP_FIELD, ARN_FIELD, NAME_FIELD, CONFIGURATION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long createdTimeStamp;

    private final Long lastUpdateTimeStamp;

    private final String arn;

    private final String name;

    private final TelemetryPipelineConfiguration configuration;

    private final String status;

    private final TelemetryPipelineStatusReason statusReason;

    private final Map<String, String> tags;

    private TelemetryPipeline(BuilderImpl builder) {
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.arn = builder.arn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The timestamp when the telemetry pipeline was created.
     * </p>
     * 
     * @return The timestamp when the telemetry pipeline was created.
     */
    public final Long createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The timestamp when the telemetry pipeline was last updated.
     * </p>
     * 
     * @return The timestamp when the telemetry pipeline was last updated.
     */
    public final Long lastUpdateTimeStamp() {
        return lastUpdateTimeStamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the telemetry pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the telemetry pipeline.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the telemetry pipeline.
     * </p>
     * 
     * @return The name of the telemetry pipeline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration that defines how the telemetry pipeline processes data.
     * </p>
     * 
     * @return The configuration that defines how the telemetry pipeline processes data.
     */
    public final TelemetryPipelineConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The current status of the telemetry pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the telemetry pipeline.
     * @see TelemetryPipelineStatus
     */
    public final TelemetryPipelineStatus status() {
        return TelemetryPipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the telemetry pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the telemetry pipeline.
     * @see TelemetryPipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the pipeline status, including reasons for failure states.
     * </p>
     * 
     * @return Additional information about the pipeline status, including reasons for failure states.
     */
    public final TelemetryPipelineStatusReason statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs associated with the telemetry pipeline resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pairs associated with the telemetry pipeline resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryPipeline)) {
            return false;
        }
        TelemetryPipeline other = (TelemetryPipeline) obj;
        return Objects.equals(createdTimeStamp(), other.createdTimeStamp())
                && Objects.equals(lastUpdateTimeStamp(), other.lastUpdateTimeStamp()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelemetryPipeline").add("CreatedTimeStamp", createdTimeStamp())
                .add("LastUpdateTimeStamp", lastUpdateTimeStamp()).add("Arn", arn()).add("Name", name())
                .add("Configuration", configuration()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "LastUpdateTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimeStamp()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryPipeline, T> g) {
        return obj -> g.apply((TelemetryPipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryPipeline> {
        /**
         * <p>
         * The timestamp when the telemetry pipeline was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The timestamp when the telemetry pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Long createdTimeStamp);

        /**
         * <p>
         * The timestamp when the telemetry pipeline was last updated.
         * </p>
         * 
         * @param lastUpdateTimeStamp
         *        The timestamp when the telemetry pipeline was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the telemetry pipeline.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the telemetry pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the telemetry pipeline.
         * </p>
         * 
         * @param name
         *        The name of the telemetry pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration that defines how the telemetry pipeline processes data.
         * </p>
         * 
         * @param configuration
         *        The configuration that defines how the telemetry pipeline processes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(TelemetryPipelineConfiguration configuration);

        /**
         * <p>
         * The configuration that defines how the telemetry pipeline processes data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelemetryPipelineConfiguration.Builder}
         * avoiding the need to create one manually via {@link TelemetryPipelineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryPipelineConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(TelemetryPipelineConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link TelemetryPipelineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(TelemetryPipelineConfiguration)
         */
        default Builder configuration(Consumer<TelemetryPipelineConfiguration.Builder> configuration) {
            return configuration(TelemetryPipelineConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The current status of the telemetry pipeline.
         * </p>
         * 
         * @param status
         *        The current status of the telemetry pipeline.
         * @see TelemetryPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryPipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the telemetry pipeline.
         * </p>
         * 
         * @param status
         *        The current status of the telemetry pipeline.
         * @see TelemetryPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryPipelineStatus
         */
        Builder status(TelemetryPipelineStatus status);

        /**
         * <p>
         * Additional information about the pipeline status, including reasons for failure states.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the pipeline status, including reasons for failure states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(TelemetryPipelineStatusReason statusReason);

        /**
         * <p>
         * Additional information about the pipeline status, including reasons for failure states.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelemetryPipelineStatusReason.Builder}
         * avoiding the need to create one manually via {@link TelemetryPipelineStatusReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryPipelineStatusReason.Builder#build()} is called
         * immediately and its result is passed to {@link #statusReason(TelemetryPipelineStatusReason)}.
         * 
         * @param statusReason
         *        a consumer that will call methods on {@link TelemetryPipelineStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReason(TelemetryPipelineStatusReason)
         */
        default Builder statusReason(Consumer<TelemetryPipelineStatusReason.Builder> statusReason) {
            return statusReason(TelemetryPipelineStatusReason.builder().applyMutation(statusReason).build());
        }

        /**
         * <p>
         * The key-value pairs associated with the telemetry pipeline resource.
         * </p>
         * 
         * @param tags
         *        The key-value pairs associated with the telemetry pipeline resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private Long createdTimeStamp;

        private Long lastUpdateTimeStamp;

        private String arn;

        private String name;

        private TelemetryPipelineConfiguration configuration;

        private String status;

        private TelemetryPipelineStatusReason statusReason;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryPipeline model) {
            createdTimeStamp(model.createdTimeStamp);
            lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            arn(model.arn);
            name(model.name);
            configuration(model.configuration);
            status(model.status);
            statusReason(model.statusReason);
            tags(model.tags);
        }

        public final Long getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TelemetryPipelineConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(TelemetryPipelineConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(TelemetryPipelineConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TelemetryPipelineStatusReason.Builder getStatusReason() {
            return statusReason != null ? statusReason.toBuilder() : null;
        }

        public final void setStatusReason(TelemetryPipelineStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(TelemetryPipelineStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
            return this;
        }

        @Override
        public TelemetryPipeline build() {
            return new TelemetryPipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
