/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class TelemetryConfigurationStateCopier {
    static Map<String, String> copy(Map<String, String> telemetryConfigurationStateParam) {
        Map<String, String> map;
        if (telemetryConfigurationStateParam == null || telemetryConfigurationStateParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>(telemetryConfigurationStateParam.size());
            telemetryConfigurationStateParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, String> copyEnumToString(Map<TelemetryType, TelemetryState> telemetryConfigurationStateParam) {
        Map<String, String> map;
        if (telemetryConfigurationStateParam == null || telemetryConfigurationStateParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>(telemetryConfigurationStateParam.size());
            telemetryConfigurationStateParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                String result1 = value == null ? null : value.toString();
                modifiableMap.put(result, result1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<TelemetryType, TelemetryState> copyStringToEnum(Map<String, String> telemetryConfigurationStateParam) {
        Map<TelemetryType, TelemetryState> map;
        if (telemetryConfigurationStateParam == null || telemetryConfigurationStateParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<TelemetryType, TelemetryState> modifiableMap = new LinkedHashMap<>(telemetryConfigurationStateParam.size());
            telemetryConfigurationStateParam.forEach((key, value) -> {
                TelemetryType result = TelemetryType.fromValue(key);
                TelemetryState result1 = TelemetryState.fromValue(value);
                if (result != TelemetryType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, result1);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
