/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a test record structure used for pipeline testing operations to validate data processing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Record implements SdkPojo, Serializable, ToCopyableBuilder<Record.Builder, Record> {
    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Data")
            .getter(getter(Record::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Record::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String data;

    private final String type;

    private Record(BuilderImpl builder) {
        this.data = builder.data;
        this.type = builder.type;
    }

    /**
     * <p>
     * The data content of the test record used for pipeline validation.
     * </p>
     * 
     * @return The data content of the test record used for pipeline validation.
     */
    public final String data() {
        return data;
    }

    /**
     * <p>
     * The type of the test record, indicating the format or category of the data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecordFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the test record, indicating the format or category of the data.
     * @see RecordFormat
     */
    public final RecordFormat type() {
        return RecordFormat.fromValue(type);
    }

    /**
     * <p>
     * The type of the test record, indicating the format or category of the data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecordFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the test record, indicating the format or category of the data.
     * @see RecordFormat
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Record").add("Data", data()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Data", DATA_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Record> {
        /**
         * <p>
         * The data content of the test record used for pipeline validation.
         * </p>
         * 
         * @param data
         *        The data content of the test record used for pipeline validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * The type of the test record, indicating the format or category of the data.
         * </p>
         * 
         * @param type
         *        The type of the test record, indicating the format or category of the data.
         * @see RecordFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormat
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the test record, indicating the format or category of the data.
         * </p>
         * 
         * @param type
         *        The type of the test record, indicating the format or category of the data.
         * @see RecordFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormat
         */
        Builder type(RecordFormat type);
    }

    static final class BuilderImpl implements Builder {
        private String data;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            data(model.data);
            type(model.type);
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecordFormat type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Record build() {
            return new Record(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
