/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration specifying the primary destination for centralized telemetry data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CentralizationRuleDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<CentralizationRuleDestination.Builder, CentralizationRuleDestination> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(CentralizationRuleDestination::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(CentralizationRuleDestination::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<DestinationLogsConfiguration> DESTINATION_LOGS_CONFIGURATION_FIELD = SdkField
            .<DestinationLogsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationLogsConfiguration")
            .getter(getter(CentralizationRuleDestination::destinationLogsConfiguration))
            .setter(setter(Builder::destinationLogsConfiguration))
            .constructor(DestinationLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLogsConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, ACCOUNT_FIELD,
            DESTINATION_LOGS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String account;

    private final DestinationLogsConfiguration destinationLogsConfiguration;

    private CentralizationRuleDestination(BuilderImpl builder) {
        this.region = builder.region;
        this.account = builder.account;
        this.destinationLogsConfiguration = builder.destinationLogsConfiguration;
    }

    /**
     * <p>
     * The primary destination region to which telemetry data should be centralized.
     * </p>
     * 
     * @return The primary destination region to which telemetry data should be centralized.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The destination account (within the organization) to which the telemetry data should be centralized.
     * </p>
     * 
     * @return The destination account (within the organization) to which the telemetry data should be centralized.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * Log specific configuration for centralization destination log groups.
     * </p>
     * 
     * @return Log specific configuration for centralization destination log groups.
     */
    public final DestinationLogsConfiguration destinationLogsConfiguration() {
        return destinationLogsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(destinationLogsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CentralizationRuleDestination)) {
            return false;
        }
        CentralizationRuleDestination other = (CentralizationRuleDestination) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(account(), other.account())
                && Objects.equals(destinationLogsConfiguration(), other.destinationLogsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CentralizationRuleDestination").add("Region", region()).add("Account", account())
                .add("DestinationLogsConfiguration", destinationLogsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "DestinationLogsConfiguration":
            return Optional.ofNullable(clazz.cast(destinationLogsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("Account", ACCOUNT_FIELD);
        map.put("DestinationLogsConfiguration", DESTINATION_LOGS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CentralizationRuleDestination, T> g) {
        return obj -> g.apply((CentralizationRuleDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CentralizationRuleDestination> {
        /**
         * <p>
         * The primary destination region to which telemetry data should be centralized.
         * </p>
         * 
         * @param region
         *        The primary destination region to which telemetry data should be centralized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The destination account (within the organization) to which the telemetry data should be centralized.
         * </p>
         * 
         * @param account
         *        The destination account (within the organization) to which the telemetry data should be centralized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * Log specific configuration for centralization destination log groups.
         * </p>
         * 
         * @param destinationLogsConfiguration
         *        Log specific configuration for centralization destination log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationLogsConfiguration(DestinationLogsConfiguration destinationLogsConfiguration);

        /**
         * <p>
         * Log specific configuration for centralization destination log groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationLogsConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationLogsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationLogsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationLogsConfiguration(DestinationLogsConfiguration)}.
         * 
         * @param destinationLogsConfiguration
         *        a consumer that will call methods on {@link DestinationLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationLogsConfiguration(DestinationLogsConfiguration)
         */
        default Builder destinationLogsConfiguration(Consumer<DestinationLogsConfiguration.Builder> destinationLogsConfiguration) {
            return destinationLogsConfiguration(DestinationLogsConfiguration.builder()
                    .applyMutation(destinationLogsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String account;

        private DestinationLogsConfiguration destinationLogsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CentralizationRuleDestination model) {
            region(model.region);
            account(model.account);
            destinationLogsConfiguration(model.destinationLogsConfiguration);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final DestinationLogsConfiguration.Builder getDestinationLogsConfiguration() {
            return destinationLogsConfiguration != null ? destinationLogsConfiguration.toBuilder() : null;
        }

        public final void setDestinationLogsConfiguration(DestinationLogsConfiguration.BuilderImpl destinationLogsConfiguration) {
            this.destinationLogsConfiguration = destinationLogsConfiguration != null ? destinationLogsConfiguration.build()
                    : null;
        }

        @Override
        public final Builder destinationLogsConfiguration(DestinationLogsConfiguration destinationLogsConfiguration) {
            this.destinationLogsConfiguration = destinationLogsConfiguration;
            return this;
        }

        @Override
        public CentralizationRuleDestination build() {
            return new CentralizationRuleDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
