/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceType;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryDestinationConfiguration;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryRule> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TelemetryRule.getter(TelemetryRule::resourceTypeAsString)).setter(TelemetryRule.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> TELEMETRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TelemetryType").getter(TelemetryRule.getter(TelemetryRule::telemetryTypeAsString)).setter(TelemetryRule.setter(Builder::telemetryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryType").build()}).build();
    private static final SdkField<TelemetryDestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfiguration").getter(TelemetryRule.getter(TelemetryRule::destinationConfiguration)).setter(TelemetryRule.setter(Builder::destinationConfiguration)).constructor(TelemetryDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfiguration").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(TelemetryRule.getter(TelemetryRule::scope)).setter(TelemetryRule.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> SELECTION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionCriteria").getter(TelemetryRule.getter(TelemetryRule::selectionCriteria)).setter(TelemetryRule.setter(Builder::selectionCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, TELEMETRY_TYPE_FIELD, DESTINATION_CONFIGURATION_FIELD, SCOPE_FIELD, SELECTION_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelemetryRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String telemetryType;
    private final TelemetryDestinationConfiguration destinationConfiguration;
    private final String scope;
    private final String selectionCriteria;

    private TelemetryRule(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.telemetryType = builder.telemetryType;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.scope = builder.scope;
        this.selectionCriteria = builder.selectionCriteria;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final TelemetryType telemetryType() {
        return TelemetryType.fromValue(this.telemetryType);
    }

    public final String telemetryTypeAsString() {
        return this.telemetryType;
    }

    public final TelemetryDestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    public final String scope() {
        return this.scope;
    }

    public final String selectionCriteria() {
        return this.selectionCriteria;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryRule)) {
            return false;
        }
        TelemetryRule other = (TelemetryRule)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.telemetryTypeAsString(), other.telemetryTypeAsString()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.selectionCriteria(), other.selectionCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryRule").add("ResourceType", (Object)this.resourceTypeAsString()).add("TelemetryType", (Object)this.telemetryTypeAsString()).add("DestinationConfiguration", (Object)this.destinationConfiguration()).add("Scope", (Object)this.scope()).add("SelectionCriteria", (Object)this.selectionCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "TelemetryType": {
                return Optional.ofNullable(clazz.cast(this.telemetryTypeAsString()));
            }
            case "DestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "SelectionCriteria": {
                return Optional.ofNullable(clazz.cast(this.selectionCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("TelemetryType", TELEMETRY_TYPE_FIELD);
        map.put("DestinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("SelectionCriteria", SELECTION_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryRule, T> g) {
        return obj -> g.apply((TelemetryRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String telemetryType;
        private TelemetryDestinationConfiguration destinationConfiguration;
        private String scope;
        private String selectionCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryRule model) {
            this.resourceType(model.resourceType);
            this.telemetryType(model.telemetryType);
            this.destinationConfiguration(model.destinationConfiguration);
            this.scope(model.scope);
            this.selectionCriteria(model.selectionCriteria);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getTelemetryType() {
            return this.telemetryType;
        }

        public final void setTelemetryType(String telemetryType) {
            this.telemetryType = telemetryType;
        }

        @Override
        public final Builder telemetryType(String telemetryType) {
            this.telemetryType = telemetryType;
            return this;
        }

        @Override
        public final Builder telemetryType(TelemetryType telemetryType) {
            this.telemetryType(telemetryType == null ? null : telemetryType.toString());
            return this;
        }

        public final TelemetryDestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(TelemetryDestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(TelemetryDestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final String getSelectionCriteria() {
            return this.selectionCriteria;
        }

        public final void setSelectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
        }

        @Override
        public final Builder selectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        public TelemetryRule build() {
            return new TelemetryRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryRule> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder telemetryType(String var1);

        public Builder telemetryType(TelemetryType var1);

        public Builder destinationConfiguration(TelemetryDestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<TelemetryDestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((TelemetryDestinationConfiguration)((TelemetryDestinationConfiguration.Builder)TelemetryDestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder scope(String var1);

        public Builder selectionCriteria(String var1);
    }
}

