/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminServiceClientConfiguration;
import software.amazon.awssdk.services.observabilityadmin.internal.ObservabilityAdminServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.observabilityadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusResponse;
import software.amazon.awssdk.services.observabilityadmin.model.InternalServerException;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminException;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ValidationException;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryEvaluationStatusForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListResourceTelemetryForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListResourceTelemetryRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StartTelemetryEvaluationForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StartTelemetryEvaluationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StopTelemetryEvaluationForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StopTelemetryEvaluationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultObservabilityAdminClient
implements ObservabilityAdminClient {
    private static final Logger log = Logger.loggerFor(DefaultObservabilityAdminClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultObservabilityAdminClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTelemetryEvaluationStatusResponse getTelemetryEvaluationStatus(GetTelemetryEvaluationStatusRequest getTelemetryEvaluationStatusRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTelemetryEvaluationStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTelemetryEvaluationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, getTelemetryEvaluationStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTelemetryEvaluationStatus");
            GetTelemetryEvaluationStatusResponse getTelemetryEvaluationStatusResponse = (GetTelemetryEvaluationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTelemetryEvaluationStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTelemetryEvaluationStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTelemetryEvaluationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTelemetryEvaluationStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$getTelemetryEvaluationStatus$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTelemetryEvaluationStatusForOrganizationResponse getTelemetryEvaluationStatusForOrganization(GetTelemetryEvaluationStatusForOrganizationRequest getTelemetryEvaluationStatusForOrganizationRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTelemetryEvaluationStatusForOrganizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTelemetryEvaluationStatusForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, getTelemetryEvaluationStatusForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTelemetryEvaluationStatusForOrganization");
            GetTelemetryEvaluationStatusForOrganizationResponse getTelemetryEvaluationStatusForOrganizationResponse = (GetTelemetryEvaluationStatusForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTelemetryEvaluationStatusForOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTelemetryEvaluationStatusForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTelemetryEvaluationStatusForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTelemetryEvaluationStatusForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$getTelemetryEvaluationStatusForOrganization$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTelemetryResponse listResourceTelemetry(ListResourceTelemetryRequest listResourceTelemetryRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTelemetryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTelemetryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, listResourceTelemetryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTelemetry");
            ListResourceTelemetryResponse listResourceTelemetryResponse = (ListResourceTelemetryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTelemetry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceTelemetryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTelemetryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTelemetryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$listResourceTelemetry$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTelemetryForOrganizationResponse listResourceTelemetryForOrganization(ListResourceTelemetryForOrganizationRequest listResourceTelemetryForOrganizationRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTelemetryForOrganizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTelemetryForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, listResourceTelemetryForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTelemetryForOrganization");
            ListResourceTelemetryForOrganizationResponse listResourceTelemetryForOrganizationResponse = (ListResourceTelemetryForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTelemetryForOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceTelemetryForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTelemetryForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTelemetryForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$listResourceTelemetryForOrganization$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTelemetryEvaluationResponse startTelemetryEvaluation(StartTelemetryEvaluationRequest startTelemetryEvaluationRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTelemetryEvaluationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTelemetryEvaluationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, startTelemetryEvaluationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTelemetryEvaluation");
            StartTelemetryEvaluationResponse startTelemetryEvaluationResponse = (StartTelemetryEvaluationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTelemetryEvaluation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTelemetryEvaluationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTelemetryEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTelemetryEvaluationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$startTelemetryEvaluation$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTelemetryEvaluationForOrganizationResponse startTelemetryEvaluationForOrganization(StartTelemetryEvaluationForOrganizationRequest startTelemetryEvaluationForOrganizationRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTelemetryEvaluationForOrganizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTelemetryEvaluationForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, startTelemetryEvaluationForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTelemetryEvaluationForOrganization");
            StartTelemetryEvaluationForOrganizationResponse startTelemetryEvaluationForOrganizationResponse = (StartTelemetryEvaluationForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTelemetryEvaluationForOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTelemetryEvaluationForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTelemetryEvaluationForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTelemetryEvaluationForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$startTelemetryEvaluationForOrganization$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTelemetryEvaluationResponse stopTelemetryEvaluation(StopTelemetryEvaluationRequest stopTelemetryEvaluationRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTelemetryEvaluationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTelemetryEvaluationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, stopTelemetryEvaluationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTelemetryEvaluation");
            StopTelemetryEvaluationResponse stopTelemetryEvaluationResponse = (StopTelemetryEvaluationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTelemetryEvaluation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopTelemetryEvaluationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTelemetryEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTelemetryEvaluationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$stopTelemetryEvaluation$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTelemetryEvaluationForOrganizationResponse stopTelemetryEvaluationForOrganization(StopTelemetryEvaluationForOrganizationRequest stopTelemetryEvaluationForOrganizationRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTelemetryEvaluationForOrganizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTelemetryEvaluationForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultObservabilityAdminClient.resolveMetricPublishers(clientConfiguration, stopTelemetryEvaluationForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTelemetryEvaluationForOrganization");
            StopTelemetryEvaluationForOrganizationResponse stopTelemetryEvaluationForOrganizationResponse = (StopTelemetryEvaluationForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTelemetryEvaluationForOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopTelemetryEvaluationForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTelemetryEvaluationForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTelemetryEvaluationForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultObservabilityAdminClient.lambda$stopTelemetryEvaluationForOrganization$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "observabilityadmin";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ObservabilityAdminServiceClientConfigurationBuilder serviceConfigBuilder = new ObservabilityAdminServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ObservabilityAdminException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final ObservabilityAdminServiceClientConfiguration serviceClientConfiguration() {
        return new ObservabilityAdminServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$stopTelemetryEvaluationForOrganization$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTelemetryEvaluation$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTelemetryEvaluationForOrganization$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTelemetryEvaluation$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTelemetryForOrganization$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTelemetry$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTelemetryEvaluationStatusForOrganization$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTelemetryEvaluationStatus$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

