/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.observabilityadmin.model.AccountIdentifiersCopier;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceType;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceTypesCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TagMapInputCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfigurationStateCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryState;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceTelemetryForOrganizationRequest
extends ObservabilityAdminRequest
implements ToCopyableBuilder<Builder, ListResourceTelemetryForOrganizationRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIdentifiers").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::accountIdentifiers)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::accountIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifierPrefix").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::resourceIdentifierPrefix)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::resourceIdentifierPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifierPrefix").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::resourceTypesAsStrings)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TELEMETRY_CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TelemetryConfigurationState").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::telemetryConfigurationStateAsStrings)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::telemetryConfigurationStateWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfigurationState").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResourceTags").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::resourceTags)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::maxResults)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceTelemetryForOrganizationRequest.getter(ListResourceTelemetryForOrganizationRequest::nextToken)).setter(ListResourceTelemetryForOrganizationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDENTIFIERS_FIELD, RESOURCE_IDENTIFIER_PREFIX_FIELD, RESOURCE_TYPES_FIELD, TELEMETRY_CONFIGURATION_STATE_FIELD, RESOURCE_TAGS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceTelemetryForOrganizationRequest.memberNameToFieldInitializer();
    private final List<String> accountIdentifiers;
    private final String resourceIdentifierPrefix;
    private final List<String> resourceTypes;
    private final Map<String, String> telemetryConfigurationState;
    private final Map<String, String> resourceTags;
    private final Integer maxResults;
    private final String nextToken;

    private ListResourceTelemetryForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.accountIdentifiers = builder.accountIdentifiers;
        this.resourceIdentifierPrefix = builder.resourceIdentifierPrefix;
        this.resourceTypes = builder.resourceTypes;
        this.telemetryConfigurationState = builder.telemetryConfigurationState;
        this.resourceTags = builder.resourceTags;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountIdentifiers() {
        return this.accountIdentifiers != null && !(this.accountIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> accountIdentifiers() {
        return this.accountIdentifiers;
    }

    public final String resourceIdentifierPrefix() {
        return this.resourceIdentifierPrefix;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypesCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final Map<TelemetryType, TelemetryState> telemetryConfigurationState() {
        return TelemetryConfigurationStateCopier.copyStringToEnum(this.telemetryConfigurationState);
    }

    public final boolean hasTelemetryConfigurationState() {
        return this.telemetryConfigurationState != null && !(this.telemetryConfigurationState instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> telemetryConfigurationStateAsStrings() {
        return this.telemetryConfigurationState;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdentifiers() ? this.accountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifierPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetryConfigurationState() ? this.telemetryConfigurationStateAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTelemetryForOrganizationRequest)) {
            return false;
        }
        ListResourceTelemetryForOrganizationRequest other = (ListResourceTelemetryForOrganizationRequest)((Object)obj);
        return this.hasAccountIdentifiers() == other.hasAccountIdentifiers() && Objects.equals(this.accountIdentifiers(), other.accountIdentifiers()) && Objects.equals(this.resourceIdentifierPrefix(), other.resourceIdentifierPrefix()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && this.hasTelemetryConfigurationState() == other.hasTelemetryConfigurationState() && Objects.equals(this.telemetryConfigurationStateAsStrings(), other.telemetryConfigurationStateAsStrings()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceTelemetryForOrganizationRequest").add("AccountIdentifiers", this.hasAccountIdentifiers() ? this.accountIdentifiers() : null).add("ResourceIdentifierPrefix", (Object)this.resourceIdentifierPrefix()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("TelemetryConfigurationState", this.hasTelemetryConfigurationState() ? this.telemetryConfigurationStateAsStrings() : null).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.accountIdentifiers()));
            }
            case "ResourceIdentifierPrefix": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifierPrefix()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "TelemetryConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.telemetryConfigurationStateAsStrings()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountIdentifiers", ACCOUNT_IDENTIFIERS_FIELD);
        map.put("ResourceIdentifierPrefix", RESOURCE_IDENTIFIER_PREFIX_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("TelemetryConfigurationState", TELEMETRY_CONFIGURATION_STATE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTelemetryForOrganizationRequest, T> g) {
        return obj -> g.apply((ListResourceTelemetryForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminRequest.BuilderImpl
    implements Builder {
        private List<String> accountIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String resourceIdentifierPrefix;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> telemetryConfigurationState = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTelemetryForOrganizationRequest model) {
            super(model);
            this.accountIdentifiers(model.accountIdentifiers);
            this.resourceIdentifierPrefix(model.resourceIdentifierPrefix);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.telemetryConfigurationStateWithStrings(model.telemetryConfigurationState);
            this.resourceTags(model.resourceTags);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAccountIdentifiers() {
            if (this.accountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIdentifiers;
        }

        public final void setAccountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdentifiersCopier.copy(accountIdentifiers);
        }

        @Override
        public final Builder accountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdentifiersCopier.copy(accountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdentifiers(String ... accountIdentifiers) {
            this.accountIdentifiers(Arrays.asList(accountIdentifiers));
            return this;
        }

        public final String getResourceIdentifierPrefix() {
            return this.resourceIdentifierPrefix;
        }

        public final void setResourceIdentifierPrefix(String resourceIdentifierPrefix) {
            this.resourceIdentifierPrefix = resourceIdentifierPrefix;
        }

        @Override
        public final Builder resourceIdentifierPrefix(String resourceIdentifierPrefix) {
            this.resourceIdentifierPrefix = resourceIdentifierPrefix;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Map<String, String> getTelemetryConfigurationState() {
            if (this.telemetryConfigurationState instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.telemetryConfigurationState;
        }

        public final void setTelemetryConfigurationState(Map<String, String> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copy(telemetryConfigurationState);
        }

        @Override
        public final Builder telemetryConfigurationStateWithStrings(Map<String, String> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copy(telemetryConfigurationState);
            return this;
        }

        @Override
        public final Builder telemetryConfigurationState(Map<TelemetryType, TelemetryState> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copyEnumToString(telemetryConfigurationState);
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (this.resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapInputCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapInputCopier.copy(resourceTags);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceTelemetryForOrganizationRequest build() {
            return new ListResourceTelemetryForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceTelemetryForOrganizationRequest> {
        public Builder accountIdentifiers(Collection<String> var1);

        public Builder accountIdentifiers(String ... var1);

        public Builder resourceIdentifierPrefix(String var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder telemetryConfigurationStateWithStrings(Map<String, String> var1);

        public Builder telemetryConfigurationState(Map<TelemetryType, TelemetryState> var1);

        public Builder resourceTags(Map<String, String> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

