/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceType;
import software.amazon.awssdk.services.observabilityadmin.model.TagMapOutputCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfigurationStateCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryState;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryConfiguration> {
    private static final SdkField<String> ACCOUNT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountIdentifier").getter(TelemetryConfiguration.getter(TelemetryConfiguration::accountIdentifier)).setter(TelemetryConfiguration.setter(Builder::accountIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> TELEMETRY_CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TelemetryConfigurationState").getter(TelemetryConfiguration.getter(TelemetryConfiguration::telemetryConfigurationStateAsStrings)).setter(TelemetryConfiguration.setter(Builder::telemetryConfigurationStateWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfigurationState").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TelemetryConfiguration.getter(TelemetryConfiguration::resourceTypeAsString)).setter(TelemetryConfiguration.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(TelemetryConfiguration.getter(TelemetryConfiguration::resourceIdentifier)).setter(TelemetryConfiguration.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResourceTags").getter(TelemetryConfiguration.getter(TelemetryConfiguration::resourceTags)).setter(TelemetryConfiguration.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdateTimeStamp").getter(TelemetryConfiguration.getter(TelemetryConfiguration::lastUpdateTimeStamp)).setter(TelemetryConfiguration.setter(Builder::lastUpdateTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDENTIFIER_FIELD, TELEMETRY_CONFIGURATION_STATE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_IDENTIFIER_FIELD, RESOURCE_TAGS_FIELD, LAST_UPDATE_TIME_STAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountIdentifier", ACCOUNT_IDENTIFIER_FIELD);
            this.put("TelemetryConfigurationState", TELEMETRY_CONFIGURATION_STATE_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
            this.put("ResourceTags", RESOURCE_TAGS_FIELD);
            this.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountIdentifier;
    private final Map<String, String> telemetryConfigurationState;
    private final String resourceType;
    private final String resourceIdentifier;
    private final Map<String, String> resourceTags;
    private final Long lastUpdateTimeStamp;

    private TelemetryConfiguration(BuilderImpl builder) {
        this.accountIdentifier = builder.accountIdentifier;
        this.telemetryConfigurationState = builder.telemetryConfigurationState;
        this.resourceType = builder.resourceType;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceTags = builder.resourceTags;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
    }

    public final String accountIdentifier() {
        return this.accountIdentifier;
    }

    public final Map<TelemetryType, TelemetryState> telemetryConfigurationState() {
        return TelemetryConfigurationStateCopier.copyStringToEnum(this.telemetryConfigurationState);
    }

    public final boolean hasTelemetryConfigurationState() {
        return this.telemetryConfigurationState != null && !(this.telemetryConfigurationState instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> telemetryConfigurationStateAsStrings() {
        return this.telemetryConfigurationState;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public final Long lastUpdateTimeStamp() {
        return this.lastUpdateTimeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetryConfigurationState() ? this.telemetryConfigurationStateAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryConfiguration)) {
            return false;
        }
        TelemetryConfiguration other = (TelemetryConfiguration)obj;
        return Objects.equals(this.accountIdentifier(), other.accountIdentifier()) && this.hasTelemetryConfigurationState() == other.hasTelemetryConfigurationState() && Objects.equals(this.telemetryConfigurationStateAsStrings(), other.telemetryConfigurationStateAsStrings()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.lastUpdateTimeStamp(), other.lastUpdateTimeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryConfiguration").add("AccountIdentifier", (Object)this.accountIdentifier()).add("TelemetryConfigurationState", this.hasTelemetryConfigurationState() ? this.telemetryConfigurationStateAsStrings() : null).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("LastUpdateTimeStamp", (Object)this.lastUpdateTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIdentifier": {
                return Optional.ofNullable(clazz.cast(this.accountIdentifier()));
            }
            case "TelemetryConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.telemetryConfigurationStateAsStrings()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "LastUpdateTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TelemetryConfiguration, T> g) {
        return obj -> g.apply((TelemetryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountIdentifier;
        private Map<String, String> telemetryConfigurationState = DefaultSdkAutoConstructMap.getInstance();
        private String resourceType;
        private String resourceIdentifier;
        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();
        private Long lastUpdateTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryConfiguration model) {
            this.accountIdentifier(model.accountIdentifier);
            this.telemetryConfigurationStateWithStrings(model.telemetryConfigurationState);
            this.resourceType(model.resourceType);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceTags(model.resourceTags);
            this.lastUpdateTimeStamp(model.lastUpdateTimeStamp);
        }

        public final String getAccountIdentifier() {
            return this.accountIdentifier;
        }

        public final void setAccountIdentifier(String accountIdentifier) {
            this.accountIdentifier = accountIdentifier;
        }

        @Override
        public final Builder accountIdentifier(String accountIdentifier) {
            this.accountIdentifier = accountIdentifier;
            return this;
        }

        public final Map<String, String> getTelemetryConfigurationState() {
            if (this.telemetryConfigurationState instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.telemetryConfigurationState;
        }

        public final void setTelemetryConfigurationState(Map<String, String> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copy(telemetryConfigurationState);
        }

        @Override
        public final Builder telemetryConfigurationStateWithStrings(Map<String, String> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copy(telemetryConfigurationState);
            return this;
        }

        @Override
        public final Builder telemetryConfigurationState(Map<TelemetryType, TelemetryState> telemetryConfigurationState) {
            this.telemetryConfigurationState = TelemetryConfigurationStateCopier.copyEnumToString(telemetryConfigurationState);
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (this.resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapOutputCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapOutputCopier.copy(resourceTags);
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return this.lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public TelemetryConfiguration build() {
            return new TelemetryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryConfiguration> {
        public Builder accountIdentifier(String var1);

        public Builder telemetryConfigurationStateWithStrings(Map<String, String> var1);

        public Builder telemetryConfigurationState(Map<TelemetryType, TelemetryState> var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceIdentifier(String var1);

        public Builder resourceTags(Map<String, String> var1);

        public Builder lastUpdateTimeStamp(Long var1);
    }
}

