/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.oam.OamAsyncClient;
import software.amazon.awssdk.services.oam.internal.UserAgentUtils;
import software.amazon.awssdk.services.oam.model.ListLinksItem;
import software.amazon.awssdk.services.oam.model.ListLinksRequest;
import software.amazon.awssdk.services.oam.model.ListLinksResponse;

public class ListLinksPublisher
implements SdkPublisher<ListLinksResponse> {
    private final OamAsyncClient client;
    private final ListLinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLinksPublisher(OamAsyncClient client, ListLinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLinksPublisher(OamAsyncClient client, ListLinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListLinksItem> items() {
        Function<ListLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLinksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLinksResponseFetcher
    implements AsyncPageFetcher<ListLinksResponse> {
        private ListLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLinksResponse> nextPage(ListLinksResponse previousPage) {
            if (previousPage == null) {
                return ListLinksPublisher.this.client.listLinks(ListLinksPublisher.this.firstRequest);
            }
            return ListLinksPublisher.this.client.listLinks((ListLinksRequest)((Object)ListLinksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

