/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.oam.DefaultOamBaseClientBuilder;
import software.amazon.awssdk.services.oam.DefaultOamClient;
import software.amazon.awssdk.services.oam.OamClient;
import software.amazon.awssdk.services.oam.OamClientBuilder;
import software.amazon.awssdk.services.oam.OamServiceClientConfiguration;
import software.amazon.awssdk.services.oam.endpoints.OamEndpointProvider;

@SdkInternalApi
final class DefaultOamClientBuilder
extends DefaultOamBaseClientBuilder<OamClientBuilder, OamClient>
implements OamClientBuilder {
    DefaultOamClientBuilder() {
    }

    @Override
    public DefaultOamClientBuilder endpointProvider(OamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OamClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOamClientBuilder.validateClientOptions(clientConfiguration);
        OamServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOamClient client = new DefaultOamClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OamServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

