/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.novaact.NovaActAsyncClient;
import software.amazon.awssdk.services.novaact.internal.UserAgentUtils;
import software.amazon.awssdk.services.novaact.model.ActSummary;
import software.amazon.awssdk.services.novaact.model.ListActsRequest;
import software.amazon.awssdk.services.novaact.model.ListActsResponse;

public class ListActsPublisher
implements SdkPublisher<ListActsResponse> {
    private final NovaActAsyncClient client;
    private final ListActsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActsPublisher(NovaActAsyncClient client, ListActsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActsPublisher(NovaActAsyncClient client, ListActsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActSummary> actSummaries() {
        Function<ListActsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actSummaries() != null) {
                return response.actSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActsResponseFetcher
    implements AsyncPageFetcher<ListActsResponse> {
        private ListActsResponseFetcher() {
        }

        public boolean hasNextPage(ListActsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActsResponse> nextPage(ListActsResponse previousPage) {
            if (previousPage == null) {
                return ListActsPublisher.this.client.listActs(ListActsPublisher.this.firstRequest);
            }
            return ListActsPublisher.this.client.listActs((ListActsRequest)((Object)ListActsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

