/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.ActSummariesCopier;
import software.amazon.awssdk.services.novaact.model.ActSummary;
import software.amazon.awssdk.services.novaact.model.NovaActResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActsResponse
extends NovaActResponse
implements ToCopyableBuilder<Builder, ListActsResponse> {
    private static final SdkField<List<ActSummary>> ACT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actSummaries").getter(ListActsResponse.getter(ListActsResponse::actSummaries)).setter(ListActsResponse.setter(Builder::actSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActsResponse.getter(ListActsResponse::nextToken)).setter(ListActsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActsResponse.memberNameToFieldInitializer();
    private final List<ActSummary> actSummaries;
    private final String nextToken;

    private ListActsResponse(BuilderImpl builder) {
        super(builder);
        this.actSummaries = builder.actSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActSummaries() {
        return this.actSummaries != null && !(this.actSummaries instanceof SdkAutoConstructList);
    }

    public final List<ActSummary> actSummaries() {
        return this.actSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActSummaries() ? this.actSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActsResponse)) {
            return false;
        }
        ListActsResponse other = (ListActsResponse)((Object)obj);
        return this.hasActSummaries() == other.hasActSummaries() && Objects.equals(this.actSummaries(), other.actSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActsResponse").add("ActSummaries", this.hasActSummaries() ? this.actSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actSummaries": {
                return Optional.ofNullable(clazz.cast(this.actSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actSummaries", ACT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActsResponse, T> g) {
        return obj -> g.apply((ListActsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActResponse.BuilderImpl
    implements Builder {
        private List<ActSummary> actSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActsResponse model) {
            super(model);
            this.actSummaries(model.actSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ActSummary.Builder> getActSummaries() {
            List<ActSummary.Builder> result = ActSummariesCopier.copyToBuilder(this.actSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActSummaries(Collection<ActSummary.BuilderImpl> actSummaries) {
            this.actSummaries = ActSummariesCopier.copyFromBuilder(actSummaries);
        }

        @Override
        public final Builder actSummaries(Collection<ActSummary> actSummaries) {
            this.actSummaries = ActSummariesCopier.copy(actSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actSummaries(ActSummary ... actSummaries) {
            this.actSummaries(Arrays.asList(actSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actSummaries(Consumer<ActSummary.Builder> ... actSummaries) {
            this.actSummaries(Stream.of(actSummaries).map(c -> (ActSummary)((ActSummary.Builder)ActSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActsResponse build() {
            return new ListActsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActsResponse> {
        public Builder actSummaries(Collection<ActSummary> var1);

        public Builder actSummaries(ActSummary ... var1);

        public Builder actSummaries(Consumer<ActSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

