/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.ActStatus;
import software.amazon.awssdk.services.novaact.model.NovaActResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActResponse
extends NovaActResponse
implements ToCopyableBuilder<Builder, CreateActResponse> {
    private static final SdkField<String> ACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actId").getter(CreateActResponse.getter(CreateActResponse::actId)).setter(CreateActResponse.setter(Builder::actId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateActResponse.getter(CreateActResponse::statusAsString)).setter(CreateActResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACT_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateActResponse.memberNameToFieldInitializer();
    private final String actId;
    private final String status;

    private CreateActResponse(BuilderImpl builder) {
        super(builder);
        this.actId = builder.actId;
        this.status = builder.status;
    }

    public final String actId() {
        return this.actId;
    }

    public final ActStatus status() {
        return ActStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActResponse)) {
            return false;
        }
        CreateActResponse other = (CreateActResponse)((Object)obj);
        return Objects.equals(this.actId(), other.actId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateActResponse").add("ActId", (Object)this.actId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actId": {
                return Optional.ofNullable(clazz.cast(this.actId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("actId", ACT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateActResponse, T> g) {
        return obj -> g.apply((CreateActResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActResponse.BuilderImpl
    implements Builder {
        private String actId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActResponse model) {
            super(model);
            this.actId(model.actId);
            this.status(model.status);
        }

        public final String getActId() {
            return this.actId;
        }

        public final void setActId(String actId) {
            this.actId = actId;
        }

        @Override
        public final Builder actId(String actId) {
            this.actId = actId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateActResponse build() {
            return new CreateActResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateActResponse> {
        public Builder actId(String var1);

        public Builder status(String var1);

        public Builder status(ActStatus var1);
    }
}

