/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.novaact.NovaActClient;
import software.amazon.awssdk.services.novaact.internal.UserAgentUtils;
import software.amazon.awssdk.services.novaact.model.ListWorkflowRunsRequest;
import software.amazon.awssdk.services.novaact.model.ListWorkflowRunsResponse;
import software.amazon.awssdk.services.novaact.model.WorkflowRunSummary;

public class ListWorkflowRunsIterable
implements SdkIterable<ListWorkflowRunsResponse> {
    private final NovaActClient client;
    private final ListWorkflowRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowRunsIterable(NovaActClient client, ListWorkflowRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowRunsResponseFetcher();
    }

    public Iterator<ListWorkflowRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowRunSummary> workflowRunSummaries() {
        Function<ListWorkflowRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowRunSummaries() != null) {
                return response.workflowRunSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowRunsResponseFetcher
    implements SyncPageFetcher<ListWorkflowRunsResponse> {
        private ListWorkflowRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowRunsResponse nextPage(ListWorkflowRunsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowRunsIterable.this.client.listWorkflowRuns(ListWorkflowRunsIterable.this.firstRequest);
            }
            return ListWorkflowRunsIterable.this.client.listWorkflowRuns((ListWorkflowRunsRequest)((Object)ListWorkflowRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

