/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.novaact.NovaActAsyncClient;
import software.amazon.awssdk.services.novaact.internal.UserAgentUtils;
import software.amazon.awssdk.services.novaact.model.ListSessionsRequest;
import software.amazon.awssdk.services.novaact.model.ListSessionsResponse;
import software.amazon.awssdk.services.novaact.model.SessionSummary;

public class ListSessionsPublisher
implements SdkPublisher<ListSessionsResponse> {
    private final NovaActAsyncClient client;
    private final ListSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionsPublisher(NovaActAsyncClient client, ListSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionsPublisher(NovaActAsyncClient client, ListSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SessionSummary> sessionSummaries() {
        Function<ListSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionSummaries() != null) {
                return response.sessionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSessionsResponseFetcher
    implements AsyncPageFetcher<ListSessionsResponse> {
        private ListSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionsResponse> nextPage(ListSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsPublisher.this.client.listSessions(ListSessionsPublisher.this.firstRequest);
            }
            return ListSessionsPublisher.this.client.listSessions((ListSessionsRequest)((Object)ListSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

